/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.block.custom;

import com.coolerpromc.uncrafteverything.blockentity.custom.UncraftingTableBlockEntity;
import com.coolerpromc.uncrafteverything.networking.RequestConfigPayload;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class UncraftingTableBlock
extends BaseEntityBlock {
    public UncraftingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return UncraftingTableBlock.simpleCodec(UncraftingTableBlock::new);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new UncraftingTableBlockEntity(pos, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity entity = level.getBlockEntity(blockPos);
            if (!(entity instanceof UncraftingTableBlockEntity)) throw new IllegalStateException("Container provider is missing");
            UncraftingTableBlockEntity blockEntity = (UncraftingTableBlockEntity)entity;
            player.openMenu((MenuProvider)blockEntity, blockPos);
            blockEntity.getOutputStacks();
            if (level.isClientSide()) return ItemInteractionResult.SUCCESS;
            level.sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
            return ItemInteractionResult.SUCCESS;
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new RequestConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return ItemInteractionResult.SUCCESS;
    }
}

