/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.compat.jei;

import com.coolerpromc.uncrafteverything.block.UEBlocks;
import com.coolerpromc.uncrafteverything.blockentity.custom.UncraftingTableBlockEntity;
import com.coolerpromc.uncrafteverything.compat.jei.UncraftingRecipeCategory;
import com.coolerpromc.uncrafteverything.config.UncraftEverythingConfig;
import com.coolerpromc.uncrafteverything.screen.custom.UncraftingTableScreen;
import com.coolerpromc.uncrafteverything.util.JEIUncraftingTableRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class UEJEIPlugin
implements IModPlugin {
    public static final RecipeType<JEIUncraftingTableRecipe> UNCRAFTING_TYPE = RecipeType.create((String)"uncrafteverything", (String)"uncrafting_table", JEIUncraftingTableRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new UncraftingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        ArrayList entries = new ArrayList();
        Ingredient shulkerBoxIngredient = Ingredient.of((TagKey)Tags.Items.SHULKER_BOXES);
        Arrays.stream(shulkerBoxIngredient.getItems()).forEach(itemStack -> {
            if (!itemStack.is(Items.SHULKER_BOX)) {
                ItemStack dyeStack = new ItemStack((ItemLike)DyeItem.byColor((DyeColor)Objects.requireNonNull(((ShulkerBoxBlock)((BlockItem)itemStack.getItem()).getBlock()).getColor())));
                entries.add(new JEIUncraftingTableRecipe((ItemStack)itemStack, List.of(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SHULKER_BOX}), Ingredient.of((ItemStack[])new ItemStack[]{dyeStack}))));
            }
        });
        BuiltInRegistries.POTION.stream().forEach(potion -> {
            if (potion != Potions.WATER) {
                ItemStack tippedArrow = PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)new Holder.Direct(potion));
                ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemStack[])new ItemStack[]{PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)new Holder.Direct(potion))}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                entries.add(new JEIUncraftingTableRecipe(tippedArrow, output));
            }
        });
        Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().forEach(enchantment -> {
            if (enchantment != null) {
                ItemStack enchantedBook = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantment, ((Enchantment)enchantment.value()).getMaxLevel()));
                ItemStack dirt = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
                dirt.enchant((Holder)enchantment, ((Enchantment)enchantment.value()).getMaxLevel());
                ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                output.add(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_SWORD)}));
                output.add(Ingredient.of((ItemStack[])new ItemStack[]{enchantedBook}));
                entries.add(new JEIUncraftingTableRecipe(dirt, output));
            }
        });
        recipeManager.getRecipes().forEach(recipeHolder -> {
            Recipe patt3$temp;
            Recipe patt2$temp;
            Recipe patt1$temp;
            Recipe patt0$temp = recipeHolder.value();
            if (patt0$temp instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)patt0$temp;
                boolean isVanillaInput = BuiltInRegistries.ITEM.getKey((Object)shapedRecipe.result.getItem()).getNamespace().equals("minecraft");
                if (!isVanillaInput || !UncraftEverythingConfig.CONFIG.preventModdedIngredientRecipes() || UncraftingTableBlockEntity.isVanillaIngredientRecipe(shapedRecipe)) {
                    entries.add(new JEIUncraftingTableRecipe(shapedRecipe.result, (List<Ingredient>)shapedRecipe.getIngredients()));
                }
            }
            if ((patt1$temp = recipeHolder.value()) instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)patt1$temp;
                boolean isVanillaInput = BuiltInRegistries.ITEM.getKey((Object)shapelessRecipe.result.getItem()).getNamespace().equals("minecraft");
                if (!isVanillaInput || !UncraftEverythingConfig.CONFIG.preventModdedIngredientRecipes() || UncraftingTableBlockEntity.isVanillaIngredientRecipe(shapelessRecipe)) {
                    entries.add(new JEIUncraftingTableRecipe(shapelessRecipe.result, (List<Ingredient>)shapelessRecipe.ingredients));
                }
            }
            if ((patt2$temp = recipeHolder.value()) instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe smithingTransformRecipe = (SmithingTransformRecipe)patt2$temp;
                boolean isVanillaInput = BuiltInRegistries.ITEM.getKey((Object)smithingTransformRecipe.result.getItem()).getNamespace().equals("minecraft");
                if (!isVanillaInput || !UncraftEverythingConfig.CONFIG.preventModdedIngredientRecipes() || UncraftingTableBlockEntity.isVanillaIngredientRecipe(smithingTransformRecipe)) {
                    NonNullList ingredients = NonNullList.create();
                    ingredients.add((Object)smithingTransformRecipe.base);
                    ingredients.add((Object)smithingTransformRecipe.addition);
                    ingredients.add((Object)smithingTransformRecipe.template);
                    entries.add(new JEIUncraftingTableRecipe(smithingTransformRecipe.result, (List<Ingredient>)ingredients));
                }
            }
            if ((patt3$temp = recipeHolder.value()) instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe smithingTrimRecipe = (SmithingTrimRecipe)patt3$temp;
                RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
                ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                output.add(0, smithingTrimRecipe.base);
                output.add(1, smithingTrimRecipe.addition);
                output.add(smithingTrimRecipe.template);
                Arrays.stream(smithingTrimRecipe.base.getItems()).forEach(itemStack -> {
                    output.set(0, Ingredient.of((ItemStack[])new ItemStack[]{itemStack}));
                    Arrays.stream(smithingTrimRecipe.addition.getItems()).forEach(itemStack1 -> {
                        output.set(1, Ingredient.of((ItemStack[])new ItemStack[]{itemStack1}));
                        Optional trimMaterialReference = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)smithingTrimRecipe.addition.getItems()[0]);
                        Optional trimPatternReference = TrimPatterns.getFromTemplate((HolderLookup.Provider)registryAccess, (ItemStack)smithingTrimRecipe.template.getItems()[0]);
                        if (trimPatternReference.isPresent() && trimMaterialReference.isPresent()) {
                            itemStack.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)trimMaterialReference.get(), (Holder)trimPatternReference.get()));
                            entries.add(new JEIUncraftingTableRecipe((ItemStack)itemStack, (List<Ingredient>)output));
                        }
                    });
                });
            }
        });
        registration.addRecipes(UNCRAFTING_TYPE, entries);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(UncraftingTableScreen.class, 59, 35, 22, 15, new RecipeType[]{UNCRAFTING_TYPE});
        registration.addGuiContainerHandler(UncraftingTableScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<UncraftingTableScreen>(this){

            public List<Rect2i> getGuiExtraAreas(UncraftingTableScreen containerScreen) {
                return Collections.singletonList(new Rect2i(containerScreen.getGuiLeft() - 152, containerScreen.getGuiTop(), 125, 184));
            }
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)UEBlocks.UNCRAFTING_TABLE.get()), new RecipeType[]{UNCRAFTING_TYPE});
    }
}

