/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.compat.rei;

import com.coolerpromc.uncrafteverything.block.UEBlocks;
import com.coolerpromc.uncrafteverything.compat.rei.UncraftingRecipeCategory;
import com.coolerpromc.uncrafteverything.compat.rei.UncraftingRecipeDisplay;
import com.coolerpromc.uncrafteverything.screen.custom.UncraftingTableScreen;
import com.coolerpromc.uncrafteverything.util.JEIUncraftingTableRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.neoforged.neoforge.common.Tags;

@REIPluginClient
public class UEREIPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new UncraftingRecipeCategory(), configuration -> configuration.addWorkstations(new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)UEBlocks.UNCRAFTING_TABLE.get()))}));
    }

    public void registerDisplays(DisplayRegistry registry) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        ArrayList entries = new ArrayList();
        Ingredient shulkerBoxIngredient = Ingredient.of((TagKey)Tags.Items.SHULKER_BOXES);
        Arrays.stream(shulkerBoxIngredient.getItems()).forEach(itemStack -> {
            if (!itemStack.is(Items.SHULKER_BOX)) {
                ItemStack dyeStack = new ItemStack((ItemLike)DyeItem.byColor((DyeColor)Objects.requireNonNull(((ShulkerBoxBlock)((BlockItem)itemStack.getItem()).getBlock()).getColor())));
                entries.add(new JEIUncraftingTableRecipe((ItemStack)itemStack, List.of(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SHULKER_BOX}), Ingredient.of((ItemStack[])new ItemStack[]{dyeStack}))));
            }
        });
        BuiltInRegistries.POTION.stream().forEach(potion -> {
            if (potion != Potions.WATER) {
                ItemStack tippedArrow = PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)new Holder.Direct(potion));
                ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemStack[])new ItemStack[]{PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)new Holder.Direct(potion))}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                output.add(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
                entries.add(new JEIUncraftingTableRecipe(tippedArrow, output));
            }
        });
        Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().forEach(enchantment -> {
            if (enchantment != null) {
                ItemStack enchantedBook = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantment, ((Enchantment)enchantment.value()).getMaxLevel()));
                ItemStack dirt = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
                dirt.enchant((Holder)enchantment, ((Enchantment)enchantment.value()).getMaxLevel());
                ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                output.add(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_SWORD)}));
                output.add(Ingredient.of((ItemStack[])new ItemStack[]{enchantedBook}));
                entries.add(new JEIUncraftingTableRecipe(dirt, output));
            }
        });
        recipeManager.getRecipes().forEach(recipeHolder -> {
            Recipe patt3$temp;
            Recipe patt2$temp;
            Recipe patt1$temp;
            Recipe patt0$temp = recipeHolder.value();
            if (patt0$temp instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)patt0$temp;
                entries.add(new JEIUncraftingTableRecipe(shapedRecipe.result, (List<Ingredient>)shapedRecipe.getIngredients()));
            }
            if ((patt1$temp = recipeHolder.value()) instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)patt1$temp;
                entries.add(new JEIUncraftingTableRecipe(shapelessRecipe.result, (List<Ingredient>)shapelessRecipe.getIngredients()));
            }
            if ((patt2$temp = recipeHolder.value()) instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe smithingTransformRecipe = (SmithingTransformRecipe)patt2$temp;
                NonNullList ingredients = NonNullList.create();
                ingredients.add((Object)smithingTransformRecipe.base);
                ingredients.add((Object)smithingTransformRecipe.addition);
                ingredients.add((Object)smithingTransformRecipe.template);
                entries.add(new JEIUncraftingTableRecipe(smithingTransformRecipe.result, (List<Ingredient>)ingredients));
            }
            if ((patt3$temp = recipeHolder.value()) instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe smithingTrimRecipe = (SmithingTrimRecipe)patt3$temp;
                RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
                ArrayList<Ingredient> output = new ArrayList<Ingredient>();
                output.add(0, smithingTrimRecipe.base);
                output.add(1, smithingTrimRecipe.addition);
                output.add(smithingTrimRecipe.template);
                Arrays.stream(smithingTrimRecipe.base.getItems()).forEach(itemStack -> {
                    output.set(0, Ingredient.of((ItemStack[])new ItemStack[]{itemStack}));
                    Arrays.stream(smithingTrimRecipe.addition.getItems()).forEach(itemStack1 -> {
                        output.set(1, Ingredient.of((ItemStack[])new ItemStack[]{itemStack1}));
                        Optional trimMaterialReference = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)smithingTrimRecipe.addition.getItems()[0]);
                        Optional trimPatternReference = TrimPatterns.getFromTemplate((HolderLookup.Provider)registryAccess, (ItemStack)smithingTrimRecipe.template.getItems()[0]);
                        if (trimPatternReference.isPresent() && trimMaterialReference.isPresent()) {
                            itemStack.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)trimMaterialReference.get(), (Holder)trimPatternReference.get()));
                            entries.add(new JEIUncraftingTableRecipe((ItemStack)itemStack, (List<Ingredient>)output));
                        }
                    });
                });
            }
        });
        entries.forEach(jeiUncraftingTableRecipe -> registry.add((Display)new UncraftingRecipeDisplay(List.of(EntryIngredients.of((ItemStack)jeiUncraftingTableRecipe.getInput())), EntryIngredients.ofIngredients(jeiUncraftingTableRecipe.getOutputs()))));
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(screen -> new Rectangle((screen.width - 176) / 2 + 59, (screen.height - 166) / 2 + 27, 22, 15), UncraftingTableScreen.class, new CategoryIdentifier[]{UncraftingRecipeDisplay.CATEGORY_IDENTIFIER});
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(UncraftingTableScreen.class, screen -> List.of(new Rectangle(0, 0, screen.getGuiLeft(), screen.height)));
    }
}

