/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.networking;

import com.coolerpromc.uncrafteverything.config.UncraftEverythingConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record ResponseConfigPayload(UncraftEverythingConfig.RestrictionType restrictionType, List<String> restrictedItems, boolean allowEnchantedItem, UncraftEverythingConfig.ExperienceType experienceType, int experience, boolean allowUnsmithing, boolean allowDamaged, boolean preventModdedIngredientsFromVanillaItems, Map<String, Integer> perItemExp, List<String> restrictedModIngredients, Map<String, String> ftbQuestProgression, boolean enableProgression, boolean onlyAllowDefinedProgression, boolean outputEnchantedBook) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ResponseConfigPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"response_config"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ResponseConfigPayload> STREAM_CODEC = StreamCodec.of(ResponseConfigPayload::encode, ResponseConfigPayload::decode);

    private static void encode(RegistryFriendlyByteBuf buf, ResponseConfigPayload payload) {
        UncraftEverythingConfig.RestrictionType.STREAM_CODEC.encode((Object)buf, (Object)payload.restrictionType);
        ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()).encode((Object)buf, payload.restrictedItems);
        ByteBufCodecs.BOOL.encode((Object)buf, (Object)payload.allowEnchantedItem);
        UncraftEverythingConfig.ExperienceType.STREAM_CODEC.encode((Object)buf, (Object)payload.experienceType);
        ByteBufCodecs.INT.encode((Object)buf, (Object)payload.experience);
        ByteBufCodecs.BOOL.encode((Object)buf, (Object)payload.allowUnsmithing);
        ByteBufCodecs.BOOL.encode((Object)buf, (Object)payload.allowDamaged);
        ByteBufCodecs.BOOL.encode((Object)buf, (Object)payload.preventModdedIngredientsFromVanillaItems);
        ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.VAR_INT).encode((Object)buf, new HashMap<String, Integer>(payload.perItemExp));
        ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()).encode((Object)buf, payload.restrictedModIngredients);
        ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.STRING_UTF8).encode((Object)buf, new HashMap<String, String>(payload.ftbQuestProgression));
        ByteBufCodecs.BOOL.encode((Object)buf, (Object)payload.enableProgression);
        ByteBufCodecs.BOOL.encode((Object)buf, (Object)payload.onlyAllowDefinedProgression);
        ByteBufCodecs.BOOL.encode((Object)buf, (Object)payload.outputEnchantedBook);
    }

    private static ResponseConfigPayload decode(RegistryFriendlyByteBuf buf) {
        UncraftEverythingConfig.RestrictionType restrictionType = (UncraftEverythingConfig.RestrictionType)((Object)UncraftEverythingConfig.RestrictionType.STREAM_CODEC.decode((Object)buf));
        List restrictedItems = (List)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()).decode((Object)buf);
        boolean allowEnchantedItem = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
        UncraftEverythingConfig.ExperienceType experienceType = (UncraftEverythingConfig.ExperienceType)((Object)UncraftEverythingConfig.ExperienceType.STREAM_CODEC.decode((Object)buf));
        int experience = (Integer)ByteBufCodecs.INT.decode((Object)buf);
        boolean allowUnsmithing = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
        boolean allowDamaged = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
        boolean preventModdedIngredientsFromVanillaItems = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
        Map perItemExp = (Map)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.VAR_INT).decode((Object)buf);
        List restrictedModIngredients = (List)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()).decode((Object)buf);
        Map ftbQuestProgression = (Map)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.STRING_UTF8).decode((Object)buf);
        boolean enableProgression = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
        boolean onlyAllowDefinedProgression = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
        boolean outputEnchantedBook = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
        return new ResponseConfigPayload(restrictionType, restrictedItems, allowEnchantedItem, experienceType, experience, allowUnsmithing, allowDamaged, preventModdedIngredientsFromVanillaItems, perItemExp, restrictedModIngredients, ftbQuestProgression, enableProgression, onlyAllowDefinedProgression, outputEnchantedBook);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

