/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.screen.custom;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractScrollableScreen
extends Screen {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller_background");
    protected int contentHeight;
    protected boolean scrolling = false;
    protected double scrollAmount = 0.0;

    protected AbstractScrollableScreen(Component title, int contentHeight) {
        super(title);
        this.contentHeight = contentHeight;
    }

    protected void renderScrollbar(GuiGraphics guiGraphics, int footerHeight) {
        int i = this.scrollBarX();
        int j = this.scrollerHeight();
        int k = this.scrollBarY();
        if (this.getMaxScroll() > 0) {
            guiGraphics.blitSprite(SCROLLER_BACKGROUND_SPRITE, i, 25, 6, this.height - footerHeight);
            guiGraphics.blitSprite(SCROLLER_SPRITE, i, k, 6, j);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 264) {
            this.mouseScrolled(0.0, 0.0, 0.0, -1.0);
            return true;
        }
        if (keyCode == 265) {
            this.mouseScrolled(0.0, 0.0, 0.0, 1.0);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.scrollBarX() && mouseY >= (double)this.scrollBarY() & mouseY <= (double)(this.scrollBarY() + this.scrollerHeight())) {
            this.scrolling = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            this.mouseScrolled(mouseX, mouseY, 0.0, -(dragY / 4.0));
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        double newScroll = this.scrollAmount - verticalAmount * 10.0;
        this.scrollAmount = Math.max(0.0, Math.min(newScroll, (double)this.getMaxScroll()));
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected abstract int scrollBarX();

    protected abstract int scrollBarY();

    protected abstract int scrollerHeight();

    protected abstract int getMaxScroll();
}

