/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.screen.custom;

import com.coolerpromc.uncrafteverything.compat.ftbquests.QuestHelper;
import com.coolerpromc.uncrafteverything.networking.UncraftingRecipeSelectionDataPayload;
import com.coolerpromc.uncrafteverything.networking.UncraftingRecipeSelectionPayload;
import com.coolerpromc.uncrafteverything.networking.UncraftingTableCraftButtonClickPayload;
import com.coolerpromc.uncrafteverything.screen.custom.FTBQuestsProgressionConfigScreen;
import com.coolerpromc.uncrafteverything.screen.custom.PerItemExpConfigScreen;
import com.coolerpromc.uncrafteverything.screen.custom.UEConfigScreen;
import com.coolerpromc.uncrafteverything.screen.custom.UncraftingTableMenu;
import com.coolerpromc.uncrafteverything.screen.widget.RecipeSelectionButton;
import com.coolerpromc.uncrafteverything.util.UncraftingTableRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class UncraftingTableScreen
extends AbstractContainerScreen<UncraftingTableMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"textures/gui/uncrafting_table_gui.png");
    private static final ResourceLocation RECIPE_PANEL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"textures/gui/recipe_selection_panel.png");
    private List<UncraftingTableRecipe> recipes = List.of();
    private int selectedRecipe = 0;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_PADDING = 2;
    private int page = 0;
    private final int MAX_PAGE_SIZE = 7;
    private int recipeSize = 0;

    public UncraftingTableScreen(UncraftingTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public void updateFromBlockEntity(List<UncraftingTableRecipe> recipes, int size) {
        this.recipes = recipes;
        this.recipeSize = size;
        if (size < 7 && this.page != 0) {
            this.page = 0;
            PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingRecipeSelectionDataPayload(this.page, ((UncraftingTableMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void init() {
        this.imageHeight = 184;
        this.inventoryLabelY = this.imageHeight - 94;
        super.init();
        this.leftPos = Math.max((this.width - this.imageWidth) / 2, 152);
        int buttonX = this.leftPos + (this.imageWidth - 64) - 20;
        int buttonY = this.topPos + 72;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.uncrafteverything.uncraft"), this::onPressed).pos(buttonX, buttonY).size(64, 16).build());
        if (((UncraftingTableMenu)this.menu).player.isCreative() || ((UncraftingTableMenu)this.menu).player.hasPermissions(4)) {
            SpriteIconButton configButton = SpriteIconButton.builder((Component)Component.translatable((String)"screen.uncrafteverything.blank"), this::openConfigScreen, (boolean)true).size(12, 12).sprite(ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"config"), 8, 8).build();
            configButton.setX(this.leftPos + this.imageWidth - 16);
            configButton.setY(this.topPos + 3);
            this.addRenderableWidget((GuiEventListener)configButton);
            SpriteIconButton expButton = SpriteIconButton.builder((Component)Component.translatable((String)"screen.uncrafteverything.blank"), this::openExpScreen, (boolean)true).size(12, 12).sprite(ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"exp"), 8, 8).build();
            expButton.setX(this.leftPos + this.imageWidth - 30);
            expButton.setY(this.topPos + 3);
            this.addRenderableWidget((GuiEventListener)expButton);
            if (QuestHelper.FTBQUESTS_LOADED) {
                SpriteIconButton progressionButton = SpriteIconButton.builder((Component)Component.translatable((String)"screen.uncrafteverything.blank"), this::openProgressionScreen, (boolean)true).size(12, 12).sprite(ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"book"), 8, 8).build();
                progressionButton.setX(this.leftPos + this.imageWidth - 44);
                progressionButton.setY(this.topPos + 3);
                this.addRenderableWidget((GuiEventListener)progressionButton);
            }
        }
    }

    private void onPressed(Button button) {
        UncraftingTableCraftButtonClickPayload payload = new UncraftingTableCraftButtonClickPayload(((UncraftingTableMenu)this.menu).blockEntity.getBlockPos(), UncraftingTableScreen.hasShiftDown());
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void openConfigScreen(Button button) {
        this.getMinecraft().setScreen((Screen)new UEConfigScreen((Component)Component.translatable((String)"screen.uncrafteverything.uncraft_everything_config"), (Screen)this));
    }

    private void openExpScreen(Button button) {
        this.getMinecraft().setScreen((Screen)new PerItemExpConfigScreen((Screen)this));
    }

    private void openProgressionScreen(Button button) {
        this.getMinecraft().setScreen((Screen)new FTBQuestsProgressionConfigScreen((Screen)this));
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.leftPos;
        int y = this.topPos;
        pGuiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int status;
        int pageToDisplay;
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.clearWidgets();
        this.init();
        MutableComponent exp = Component.translatable((String)("screen.uncrafteverything.exp_" + ((UncraftingTableMenu)this.menu).getExpType().toLowerCase() + "_required"), (Object[])new Object[]{((UncraftingTableMenu)this.menu).getExpAmount()});
        int expX = this.leftPos + (this.imageWidth - 64) - 20 + 32;
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().scale(0.75f, 0.75f, 0.75f);
        pGuiGraphics.pose().translate((float)expX * 1.3334f, (float)this.topPos * 1.3334f + 121.0f, 0.0f);
        this.drawCenteredWordWrapWithoutShadow(pGuiGraphics, this.font, (Component)exp, 0, 0, -16733696);
        pGuiGraphics.pose().popPose();
        int x = this.leftPos;
        int y = this.topPos;
        int maxPageCount = (int)Math.ceil((double)this.recipeSize / 7.0);
        int n = pageToDisplay = this.recipes.isEmpty() ? 0 : this.page + 1;
        if (this.page > maxPageCount - 1) {
            this.page = 0;
        }
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(0.0f, 0.0f, 600.0f);
        pGuiGraphics.blit(RECIPE_PANEL_TEXTURE, x - 152, y, 0.0f, 0.0f, 152, 184, 152, 184);
        this.drawCenteredWordWrapWithoutShadow(pGuiGraphics, this.font, (Component)Component.translatable((String)"screen.uncrafteverything.uncraft_recipe_selection"), x - 75, y + 7, -12566464);
        this.drawCenteredWordWrapWithoutShadow(pGuiGraphics, this.font, (Component)Component.translatable((String)"screen.uncrafteverything.page", (Object[])new Object[]{pageToDisplay, maxPageCount}), x - 75, y + this.imageHeight - 18, -12566464);
        Button prevButton = Button.builder((Component)Component.translatable((String)"screen.uncrafteverything.prev_button"), button -> {
            this.page = this.page > 0 ? --this.page : Math.max(maxPageCount - 1, 0);
            PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingRecipeSelectionDataPayload(this.page, ((UncraftingTableMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).pos(x - 152 + 5, y + this.imageHeight - 23).size(16, 16).build();
        ((Button)this.addRenderableWidget((GuiEventListener)prevButton)).render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        Button nextButton = Button.builder((Component)Component.translatable((String)"screen.uncrafteverything.next_button"), button -> {
            this.page = this.page < maxPageCount - 1 ? ++this.page : 0;
            PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingRecipeSelectionDataPayload(this.page, ((UncraftingTableMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).pos(x - 21, y + this.imageHeight - 23).size(16, 16).build();
        ((Button)this.addRenderableWidget((GuiEventListener)nextButton)).render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int visibleCount = 0;
        for (int j = 0; j < this.recipes.size() && visibleCount < 7; ++visibleCount, ++j) {
            UncraftingTableRecipe recipe = this.recipes.get(j);
            int displayIndex = visibleCount;
            int recipeWidth = 149;
            Rectangle2D.Double bounds = new Rectangle2D.Double(x - recipeWidth, y + displayIndex * 18 + 30, recipeWidth - 3, 18.0);
            int finalJ = j;
            RecipeSelectionButton button2 = new RecipeSelectionButton((int)((RectangularShape)bounds).getX(), (int)((RectangularShape)bounds).getY(), (int)((RectangularShape)bounds).getWidth(), (int)((RectangularShape)bounds).getHeight(), (Component)Component.translatable((String)"screen.uncrafteverything.blank"), ignored -> {
                this.selectedRecipe = finalJ;
            });
            if (this.selectedRecipe == j) {
                button2.setFocused(true);
            }
            ((RecipeSelectionButton)this.addRenderableWidget((GuiEventListener)button2)).render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            int i = 0;
            HashMap<Item, Integer> inputs = new HashMap<Item, Integer>();
            HashMap<Item, DataComponentMap> inputComponents = new HashMap<Item, DataComponentMap>();
            for (ItemStack itemStack : recipe.getOutputs()) {
                if (inputs.containsKey(itemStack.getItem())) {
                    inputs.put(itemStack.getItem(), itemStack.getCount() + (Integer)inputs.get(itemStack.getItem()));
                    inputComponents.put(itemStack.getItem(), itemStack.getComponents());
                    continue;
                }
                inputs.put(itemStack.getItem(), itemStack.getCount());
                inputComponents.put(itemStack.getItem(), itemStack.getComponents());
            }
            for (Map.Entry entry : inputs.entrySet()) {
                if (entry.getKey() == Items.AIR) continue;
                ItemStack itemStack = new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue());
                if (inputComponents.containsKey(entry.getKey())) {
                    itemStack.applyComponents((DataComponentMap)inputComponents.get(entry.getKey()));
                }
                pGuiGraphics.renderFakeItem(itemStack, x - recipeWidth + i * 16 + 1, y + displayIndex * 18 + 31);
                pGuiGraphics.renderItemDecorations(this.font, itemStack, x - recipeWidth + i * 16 + 1, y + displayIndex * 18 + 31);
                if (pMouseX >= x - recipeWidth + i * 16 + 1 && pMouseX <= x - recipeWidth + i * 16 + 17 && pMouseY >= y + displayIndex * 18 + 31 && pMouseY <= y + displayIndex * 18 + 31 + 16) {
                    pGuiGraphics.renderTooltip(this.font, itemStack, pMouseX, pMouseY);
                }
                ++i;
            }
        }
        pGuiGraphics.pose().popPose();
        if (this.selectedRecipe >= this.recipes.size()) {
            this.selectedRecipe = 0;
        }
        if (!this.recipes.isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingRecipeSelectionPayload(((UncraftingTableMenu)this.menu).blockEntity.getBlockPos(), this.recipes.get(this.selectedRecipe)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            List<ItemStack> outputs = this.recipes.get(this.selectedRecipe).getOutputs();
            for (int i = 0; i < outputs.size(); ++i) {
                ItemStack itemStack = outputs.get(i);
                pGuiGraphics.renderFakeItem(itemStack, x + 98 + 18 * (i % 3), y + 17 + i / 3 * 18);
                pGuiGraphics.fill(x + 98 + 18 * (i % 3), y + 17 + i / 3 * 18, x + 98 + 18 * (i % 3) + 16, y + 17 + i / 3 * 18 + 16, 200, -1433695349);
            }
        }
        if ((status = ((UncraftingTableMenu)this.menu).getStatus()) != -1) {
            MutableComponent statusText = Component.translatable((String)(switch (status) {
                case 0 -> "screen.uncrafteverything.no_recipe_found";
                case 1 -> "screen.uncrafteverything.no_suitable_output_slot";
                case 2 -> "screen.uncrafteverything.not_enough_exp";
                case 3 -> "screen.uncrafteverything.not_enough_input";
                case 4 -> "screen.uncrafteverything.not_empty_shulker";
                case 5 -> "screen.uncrafteverything.restricted_by_config";
                case 6 -> "screen.uncrafteverything.damaged_item";
                case 7 -> "screen.uncrafteverything.enchanted_item";
                case 8 -> "screen.uncrafteverything.locked_item";
                case 9 -> "screen.uncrafteverything.progression_not_defined";
                default -> "screen.uncrafteverything.blank";
            }));
            int textY = y + 55;
            float scale = 0.75f;
            int boxWidth = 52;
            int boxLeft = x + 9;
            float boxCenterX = (float)boxLeft + (float)boxWidth / 2.0f;
            List formattedText = this.font.split(FormattedText.of((String)statusText.getString()), (int)((double)boxWidth * 1.3));
            switch (formattedText.size()) {
                case 1: {
                    textY += 14;
                    break;
                }
                case 2: {
                    textY += 9;
                    break;
                }
                default: {
                    textY += 5;
                }
            }
            for (FormattedCharSequence line : formattedText) {
                float rawWidth = this.font.width(line);
                float f = -rawWidth / 2.0f;
                pGuiGraphics.pose().pushPose();
                pGuiGraphics.pose().translate(boxCenterX, (float)textY, 0.0f);
                pGuiGraphics.pose().scale(scale, scale, scale);
                pGuiGraphics.drawString(this.font, line, Math.round(f), 0, ChatFormatting.RED.getColor().intValue(), false);
                pGuiGraphics.pose().popPose();
                textY += 7;
            }
        }
        if (((UncraftingTableMenu)this.menu).player.hasPermissions(4) || ((UncraftingTableMenu)this.menu).player.isCreative()) {
            if (pMouseX >= this.leftPos + this.imageWidth - 16 && pMouseX <= this.leftPos + this.imageWidth - 4 && pMouseY >= this.topPos + 3 && pMouseY <= this.topPos + 15) {
                pGuiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.uncrafteverything.uncraft_everything_config"), pMouseX, pMouseY);
            }
            if (pMouseX >= this.leftPos + this.imageWidth - 30 && pMouseX <= this.leftPos + this.imageWidth - 18 && pMouseY >= this.topPos + 3 && pMouseY <= this.topPos + 15) {
                pGuiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.uncrafteverything.per_item_xp_config"), pMouseX, pMouseY);
            }
            if (pMouseX >= this.leftPos + this.imageWidth - 44 && pMouseX <= this.leftPos + this.imageWidth - 32 && pMouseY >= this.topPos + 3 && pMouseY <= this.topPos + 15 && QuestHelper.FTBQUESTS_LOADED) {
                pGuiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.uncrafteverything.ftb_quest_progression_config"), pMouseX, pMouseY);
            }
        }
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollDelta) {
        if (scrollDelta == 1.0 && this.page > 0) {
            --this.page;
        } else if (scrollDelta == -1.0 && (this.page + 1) * 7 < this.recipeSize) {
            ++this.page;
        } else if (scrollDelta == 1.0 && this.page == 0 && !this.recipes.isEmpty()) {
            this.page = (int)Math.ceil((double)this.recipeSize / 7.0) - 1;
        } else if (scrollDelta == -1.0 && (this.page + 1) * 7 >= this.recipeSize) {
            this.page = 0;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingRecipeSelectionDataPayload(this.page, ((UncraftingTableMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollDelta);
    }

    public void drawCenteredWordWrapWithoutShadow(GuiGraphics context, Font textRenderer, Component text, int centerX, int y, int color) {
        List lines = textRenderer.split((FormattedText)text, 140);
        Objects.requireNonNull(textRenderer);
        int lineHeight = 9 + 2;
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            int lineWidth = textRenderer.width(line);
            int lineX = centerX - lineWidth / 2;
            int lineY = y + i * lineHeight;
            context.drawString(textRenderer, line, lineX, lineY, color, false);
        }
    }

    public void getRecipeSelection() {
        UncraftingTableRecipe recipe = null;
        try {
            if (!this.recipes.isEmpty()) {
                recipe = this.recipes.get(this.selectedRecipe);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (recipe != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UncraftingRecipeSelectionPayload(((UncraftingTableMenu)this.menu).blockEntity.getBlockPos(), recipe), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

