/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.screen.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RecipeSelectionButton
extends AbstractButton {
    private static final WidgetSprites TEXTURES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"widget/button"), ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"widget/button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"uncrafteverything", (String)"widget/button_highlighted"));
    protected final PressAction onPress;

    public RecipeSelectionButton(int x, int y, int width, int height, Component message, PressAction onPress) {
        super(x, y, width, height, message);
        this.onPress = onPress;
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
        Minecraft minecraftClient = Minecraft.getInstance();
        context.blitSprite(TEXTURES.get(this.active, this.isFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int i = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderString(context, minecraftClient.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.onPress(this);
        }
    }

    public static interface PressAction {
        public void onPress(RecipeSelectionButton var1);
    }
}

