/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class UncraftingTableRecipe {
    private final ItemStack input;
    private final List<ItemStack> outputs = new ArrayList<ItemStack>();
    public static final StreamCodec<RegistryFriendlyByteBuf, UncraftingTableRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, UncraftingTableRecipe::getInput, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), UncraftingTableRecipe::getOutputs, UncraftingTableRecipe::new);

    public UncraftingTableRecipe(ItemStack input) {
        this.input = input;
    }

    public UncraftingTableRecipe(ItemStack input, List<ItemStack> outputs) {
        this.input = input;
        this.outputs.addAll(outputs);
    }

    public boolean addOutput(ItemStack output) {
        return this.outputs.add(output);
    }

    public void setOutput(int index, ItemStack output) {
        this.outputs.set(index, output);
    }

    public ItemStack getInput() {
        return this.input;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public CompoundTag serializeNbt(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.put("input", this.input.saveOptional(provider));
        ListTag listTag = new ListTag();
        for (ItemStack itemStack : this.outputs) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.put("output", itemStack.saveOptional(provider));
            listTag.add((Object)itemTag);
        }
        tag.put("outputs", (Tag)listTag);
        return tag;
    }

    public static UncraftingTableRecipe deserializeNbt(CompoundTag tag, HolderLookup.Provider provider) {
        ItemStack input = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("input"));
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (tag.contains("outputs", 9)) {
            ListTag listTag = tag.getList("outputs", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag itemTag = listTag.getCompound(i);
                outputs.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTag.getCompound("output")));
            }
        }
        return new UncraftingTableRecipe(input, outputs);
    }
}

