/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.screen.custom;

import com.coolerpromc.uncrafteverything.config.UncraftEverythingConfig;
import com.coolerpromc.uncrafteverything.networking.ClientPayloadHandler;
import com.coolerpromc.uncrafteverything.networking.RequestConfigPayload;
import com.coolerpromc.uncrafteverything.networking.ResponseConfigPayload;
import com.coolerpromc.uncrafteverything.networking.UEConfigPayload;
import com.coolerpromc.uncrafteverything.screen.custom.AbstractScrollableScreen;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

public class UEConfigScreen
extends AbstractScrollableScreen {
    private final Screen parent;
    private final ResponseConfigPayload config = ClientPayloadHandler.payloadFromServer;
    private UncraftEverythingConfig.ExperienceType experienceType = this.config.experienceType();
    private int experience = this.config.experience();
    private UncraftEverythingConfig.RestrictionType restrictionType = this.config.restrictionType();
    private List<String> restrictions = this.config.restrictedItems();
    private boolean allowEnchantedItems = this.config.allowEnchantedItem();
    private boolean allowUnsmithing = this.config.allowUnsmithing();
    private boolean allowDamagedItems = this.config.allowDamaged();
    private boolean preventModdedIngredientsFromVanillaItems = this.config.preventModdedIngredientsFromVanillaItems();
    private List<String> restrictedModIngredients = this.config.restrictedModIngredients();
    private boolean enableProgression = this.config.enableProgression();
    private boolean onlyAllowDefinedProgression = this.config.onlyAllowDefinedProgression();
    private Button restrictionTypeButton;
    private Button toggleEnchantedBtn;
    private Button toggleEnchantmentTypeBtn;
    private Button toggleAllowUnsmithing;
    private Button toggleAllowDamaged;
    private Button toggleEnableProgression;
    private Button toggleOnlyAllowDefinedProgression;
    private Button togglePreventModdedIngredientsFromVanillaItems;
    private MultiLineEditBox restrictionsInput;
    private EditBox experienceInput;
    private MultiLineEditBox restrictedModInput;
    private Button saveButton;

    protected UEConfigScreen(Component title, Screen parent) {
        super(title, 388);
        this.parent = parent;
    }

    protected void init() {
        int x = this.width / 2 + 10;
        int widgetWidth = this.width - x - 10;
        int baseY = 30;
        this.restrictionTypeButton = Button.builder((Component)Component.translatable((String)("screen.uncrafteverything.config.restriction_type_" + this.restrictionType.toString().toLowerCase())), this::pressRestrictionTypeButton).bounds(x, (int)((double)baseY - this.scrollAmount), widgetWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.restrictionTypeButton);
        String joined = String.join((CharSequence)"\n", this.restrictions);
        this.restrictionsInput = MultiLineEditBox.builder().setX(x).setY((int)((double)(baseY + 25) - this.scrollAmount)).build(this.font, widgetWidth, 90, (Component)Component.translatable((String)"screen.uncrafteverything.blank"));
        this.restrictionsInput.setValue(joined);
        this.addRenderableWidget((GuiEventListener)this.restrictionsInput);
        this.toggleEnchantedBtn = Button.builder((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.allow_enchanted_", this.allowEnchantedItems)), btn -> {
            this.allowEnchantedItems = !this.allowEnchantedItems;
            btn.setMessage((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.allow_enchanted_", this.allowEnchantedItems)));
        }).bounds(x, (int)((double)(baseY + 120) - this.scrollAmount), widgetWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleEnchantedBtn);
        this.toggleEnchantmentTypeBtn = Button.builder((Component)Component.translatable((String)("screen.uncrafteverything.config.exp_type_" + this.experienceType.toString().toLowerCase())), btn -> {
            UncraftEverythingConfig.ExperienceType next;
            UncraftEverythingConfig.ExperienceType[] values = UncraftEverythingConfig.ExperienceType.values();
            this.experienceType = next = values[(this.experienceType.ordinal() + 1) % values.length];
            btn.setMessage((Component)Component.translatable((String)("screen.uncrafteverything.config.exp_type_" + next.toString().toLowerCase())));
        }).bounds(x, (int)((double)(baseY + 145) - this.scrollAmount), widgetWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleEnchantmentTypeBtn);
        this.experienceInput = new EditBox(this.font, x, (int)((double)(baseY + 170) - this.scrollAmount), widgetWidth, 20, (Component)Component.translatable((String)"screen.uncrafteverything.blank"));
        this.experienceInput.setValue(Integer.toString(this.experience));
        this.experienceInput.setFilter(s -> s.matches("\\d*"));
        this.addRenderableWidget((GuiEventListener)this.experienceInput);
        this.toggleAllowUnsmithing = Button.builder((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.allow_unsmithing_", this.allowUnsmithing)), btn -> {
            this.allowUnsmithing = !this.allowUnsmithing;
            btn.setMessage((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.allow_unsmithing_", this.allowUnsmithing)));
        }).bounds(x, (int)((double)(baseY + 195) - this.scrollAmount), widgetWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleAllowUnsmithing);
        this.toggleAllowDamaged = Button.builder((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.allow_damaged_", this.allowDamagedItems)), btn -> {
            this.allowDamagedItems = !this.allowDamagedItems;
            btn.setMessage((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.allow_damaged_", this.allowDamagedItems)));
        }).bounds(x, (int)((double)(baseY + 220) - this.scrollAmount), widgetWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleAllowDamaged);
        this.togglePreventModdedIngredientsFromVanillaItems = Button.builder((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.prevent_modded_ingredients_from_vanilla_items_", this.preventModdedIngredientsFromVanillaItems)), btn -> {
            this.preventModdedIngredientsFromVanillaItems = !this.preventModdedIngredientsFromVanillaItems;
            btn.setMessage((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.prevent_modded_ingredients_from_vanilla_items_", this.preventModdedIngredientsFromVanillaItems)));
        }).bounds(x, (int)((double)(baseY + 245) - this.scrollAmount), widgetWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.togglePreventModdedIngredientsFromVanillaItems);
        String joinedMod = String.join((CharSequence)"\n", this.restrictedModIngredients);
        this.restrictedModInput = MultiLineEditBox.builder().setX(x).setY((int)((double)(baseY + 270) - this.scrollAmount)).build(this.font, widgetWidth, 90, (Component)Component.translatable((String)"screen.uncrafteverything.blank"));
        this.restrictedModInput.setValue(joinedMod);
        this.addRenderableWidget((GuiEventListener)this.restrictedModInput);
        this.toggleEnableProgression = Button.builder((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.enable_progression_", this.enableProgression)), btn -> {
            this.enableProgression = !this.enableProgression;
            btn.setMessage((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.enable_progression_", this.enableProgression)));
        }).bounds(x, (int)((double)(baseY + 365) - this.scrollAmount), widgetWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleEnableProgression);
        this.toggleOnlyAllowDefinedProgression = Button.builder((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.only_allow_defined_progression_", this.onlyAllowDefinedProgression)), btn -> {
            this.onlyAllowDefinedProgression = !this.onlyAllowDefinedProgression;
            btn.setMessage((Component)Component.translatable((String)this.getLabel("screen.uncrafteverything.config.only_allow_defined_progression_", this.onlyAllowDefinedProgression)));
        }).bounds(x, (int)((double)(baseY + 390) - this.scrollAmount), widgetWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleOnlyAllowDefinedProgression);
        this.saveButton = Button.builder((Component)Component.translatable((String)"screen.uncrafteverything.save"), this::pressSaveButton).bounds(this.width / 2 - 100, this.height - 45 + 15, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.saveButton);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderMenuBackground(guiGraphics);
        this.renderBlurredBackground(guiGraphics);
        this.renderSeparator(guiGraphics);
        this.renderScrollbar(guiGraphics, 70);
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int scissorTop = 25;
        int scissorBottom = this.height - 45;
        pGuiGraphics.enableScissor(0, scissorTop, this.width, scissorBottom);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int x = 10;
        int textWidth = this.width / 2 - 10;
        int baseY = 30;
        MutableComponent mutableComponent = Component.translatable((String)"screen.uncrafteverything.config.restriction_type_label");
        double d = (double)baseY - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawString(this.font, (Component)mutableComponent, x, (int)(d + 9.0 / 2.0 + 2.0), -1);
        MutableComponent format = Component.translatable((String)"screen.uncrafteverything.config.restricted_item_label");
        double d2 = (double)(baseY + 25) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)format, x, (int)(d2 + 9.0 / 2.0 + 20.0), textWidth, -1);
        pGuiGraphics.pose().pushMatrix();
        pGuiGraphics.pose().scale(0.65f, 0.65f);
        Matrix3x2fStack matrix3x2fStack = pGuiGraphics.pose();
        float f = (float)((double)x * 1.55);
        double d3 = ((double)(baseY + 25) - this.scrollAmount) * (double)1.6f + (double)(this.font.wordWrapHeight((FormattedText)format, textWidth) * 2);
        Objects.requireNonNull(this.font);
        matrix3x2fStack.translate(f, (float)(d3 - 9.0 * 0.65 + 40.0));
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)Component.translatable((String)"screen.uncrafteverything.config.format_label"), 0, 0, (int)((double)textWidth * 1.5), -5592406);
        pGuiGraphics.pose().popMatrix();
        MutableComponent allowEnchantedItem = Component.translatable((String)"screen.uncrafteverything.config.allow_enchanted_label");
        double d4 = (double)(baseY + 120) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)allowEnchantedItem, x, (int)(d4 + 9.0 / 2.0 + 1.0 - (double)this.font.wordWrapHeight((FormattedText)allowEnchantedItem, textWidth) / 4.0), textWidth, -1);
        MutableComponent mutableComponent2 = Component.translatable((String)"screen.uncrafteverything.config.exp_type_label");
        double d5 = (double)(baseY + 145) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)mutableComponent2, x, (int)(d5 + 9.0 / 2.0 + 2.0), textWidth, -1);
        MutableComponent expRequired = Component.translatable((String)"screen.uncrafteverything.config.exp_required_label");
        double d6 = (double)(baseY + 170) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)expRequired, x, (int)(d6 + 9.0 / 2.0 + 1.0 - (double)this.font.wordWrapHeight((FormattedText)expRequired, textWidth) / 4.0), textWidth, -1);
        MutableComponent mutableComponent3 = Component.translatable((String)"screen.uncrafteverything.config.allow_unsmithing_label");
        double d7 = (double)(baseY + 195) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)mutableComponent3, x, (int)(d7 + 9.0 / 2.0 + 2.0), textWidth, -1);
        MutableComponent allowDamagedItem = Component.translatable((String)"screen.uncrafteverything.config.allow_damaged_label");
        double d8 = (double)(baseY + 220) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)allowDamagedItem, x, (int)(d8 + 9.0 / 2.0 + 1.0 - (double)this.font.wordWrapHeight((FormattedText)allowDamagedItem, textWidth) / 4.0), textWidth, -1);
        MutableComponent preventModded = Component.translatable((String)"screen.uncrafteverything.config.prevent_modded_ingredients_from_vanilla_items_label");
        double d9 = (double)(baseY + 245) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)preventModded, x, (int)(d9 + 9.0 / 2.0 + 1.0 - (double)this.font.wordWrapHeight((FormattedText)preventModded, textWidth) / 4.0), textWidth, -1);
        MutableComponent restrictedMod = Component.translatable((String)"screen.uncrafteverything.config.prevent_modid");
        double d10 = (double)(baseY + 304) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)restrictedMod, x, (int)(d10 + 9.0 / 2.0 + 1.0 - (double)this.font.wordWrapHeight((FormattedText)restrictedMod, textWidth) / 4.0), textWidth, -1);
        MutableComponent enableProgression = Component.translatable((String)"screen.uncrafteverything.config.enable_progression");
        double d11 = (double)(baseY + 367) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)enableProgression, x, (int)(d11 + 9.0 / 2.0 + 1.0 - (double)this.font.wordWrapHeight((FormattedText)restrictedMod, textWidth) / 4.0), textWidth, -1);
        MutableComponent onlyAllowDefined = Component.translatable((String)"screen.uncrafteverything.config.only_allow_defined_progression");
        double d12 = (double)(baseY + 392) - this.scrollAmount;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawWordWrap(this.font, (FormattedText)onlyAllowDefined, x, (int)(d12 + 9.0 / 2.0 + 1.0 - (double)this.font.wordWrapHeight((FormattedText)restrictedMod, textWidth) / 4.0), textWidth, -1);
        pGuiGraphics.disableScissor();
        MutableComponent mutableComponent4 = Component.translatable((String)"screen.uncrafteverything.uncraft_everything_config");
        int n = this.width / 2;
        Objects.requireNonNull(this.font);
        pGuiGraphics.drawCenteredString(this.font, (Component)mutableComponent4, n, (23 - 9) / 2, -1);
        this.saveButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderButtonTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    @Override
    protected int scrollBarX() {
        return this.width - 6;
    }

    @Override
    protected int scrollBarY() {
        int scrollBarHeight = Math.max(10, (int)((double)((this.height - 70) * (this.height - 70)) / (double)this.contentHeight));
        return (int)(25.0 + this.scrollAmount / (double)this.getMaxScroll() * (double)(this.height - 70 - scrollBarHeight));
    }

    @Override
    protected int scrollerHeight() {
        return Math.max(10, (int)((double)((this.height - 70) * (this.height - 70)) / (double)this.contentHeight));
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        this.clearWidgets();
        this.init();
        return true;
    }

    @Override
    protected int getMaxScroll() {
        return Math.max(0, this.contentHeight - (this.height - 100));
    }

    public void onClose() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new RequestConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.getMinecraft().setScreen(this.parent);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean inScrollArea;
        int scrollTop = 25;
        int scrollBottom = this.height - 45;
        boolean bl = inScrollArea = mouseY >= (double)scrollTop && mouseY <= (double)scrollBottom;
        if (!inScrollArea) {
            if (!this.saveButton.isMouseOver(mouseX, mouseY)) {
                return false;
            }
            return this.saveButton.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderSeparator(GuiGraphics guiGraphics) {
        ResourceLocation header = this.getMinecraft().level == null ? Screen.HEADER_SEPARATOR : Screen.INWORLD_HEADER_SEPARATOR;
        ResourceLocation footer = this.getMinecraft().level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, header, 0, 23, 0.0f, 0.0f, this.width, 2, 32, 2);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, footer, 0, this.height - 45, 0.0f, 0.0f, this.width, 2, 32, 2);
    }

    private String getLabel(String label, boolean enabled) {
        return label + (enabled ? "yes" : "no");
    }

    private void pressRestrictionTypeButton(Button button) {
        UncraftEverythingConfig.RestrictionType next;
        UncraftEverythingConfig.RestrictionType[] values = UncraftEverythingConfig.RestrictionType.values();
        this.restrictionType = next = values[(this.restrictionType.ordinal() + 1) % values.length];
        button.setMessage((Component)Component.translatable((String)("screen.uncrafteverything.config.restriction_type_" + next.toString().toLowerCase())));
    }

    private void pressSaveButton(Button button) {
        this.restrictions = Arrays.stream(this.restrictionsInput.getValue().split("\n")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        this.experience = Integer.parseInt(this.experienceInput.getValue());
        this.restrictedModIngredients = Arrays.stream(this.restrictedModInput.getValue().split("\n")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        UEConfigPayload configPayload = new UEConfigPayload(this.restrictionType, this.restrictions, this.allowEnchantedItems, this.experienceType, this.experience, this.allowUnsmithing, this.allowDamagedItems, this.preventModdedIngredientsFromVanillaItems, this.restrictedModIngredients, this.enableProgression, this.onlyAllowDefinedProgression);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)configPayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new RequestConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.getMinecraft().setScreen(this.parent);
    }

    private void renderButtonTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        List<Component> tooltip;
        if (this.restrictionTypeButton.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.toggle_restriction_type"), this.valueInfo("tooltip.uncrafteverything.config.blacklist", "tooltip.uncrafteverything.config.blacklist_info"), Component.empty(), this.valueInfo("tooltip.uncrafteverything.config.whitelist", "tooltip.uncrafteverything.config.whitelist_info"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.restrictionsInput.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.edit_restricted_items"), this.description("tooltip.uncrafteverything.config.edit_restricted_items_description"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.toggleEnchantedBtn.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.toggle_allow_enchanted_items"), this.valueInfo("tooltip.uncrafteverything.config.yes", "tooltip.uncrafteverything.config.allow_enchanted_yes"), Component.empty(), this.valueInfo("tooltip.uncrafteverything.config.no", "tooltip.uncrafteverything.config.allow_enchanted_no"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.toggleEnchantmentTypeBtn.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.toggle_experience_type"), this.valueInfo("tooltip.uncrafteverything.config.point", "tooltip.uncrafteverything.config.point_info"), Component.empty(), this.valueInfo("tooltip.uncrafteverything.config.level", "tooltip.uncrafteverything.config.level_info"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.experienceInput.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.edit_experience_required"), this.description("tooltip.uncrafteverything.config.edit_experience_required_description"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.toggleAllowUnsmithing.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.toggle_allow_unsmithing"), this.valueInfo("tooltip.uncrafteverything.config.yes", "tooltip.uncrafteverything.config.toggle_allow_unsmithing_yes"), Component.empty(), this.valueInfo("tooltip.uncrafteverything.config.no", "tooltip.uncrafteverything.config.toggle_allow_unsmithing_no"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.toggleAllowDamaged.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.toggle_allow_damaged_items"), this.valueInfo("tooltip.uncrafteverything.config.yes", "tooltip.uncrafteverything.config.toggle_allow_damaged_items_yes"), Component.empty(), this.valueInfo("tooltip.uncrafteverything.config.no", "tooltip.uncrafteverything.config.toggle_allow_damaged_items_no"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.togglePreventModdedIngredientsFromVanillaItems.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.toggle_prevent_modded_ingredients"), this.valueInfo("tooltip.uncrafteverything.config.yes", "tooltip.uncrafteverything.config.toggle_prevent_modded_ingredients_yes"), Component.empty(), this.valueInfo("tooltip.uncrafteverything.config.no", "tooltip.uncrafteverything.config.toggle_prevent_modded_ingredients_no"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.restrictedModInput.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.edit_restricted_mods"), this.description("tooltip.uncrafteverything.config.edit_restricted_mods_description"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.toggleEnableProgression.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.toggle_enable_progression"), this.valueInfo("tooltip.uncrafteverything.config.yes", "tooltip.uncrafteverything.config.toggle_enable_progression_yes"), Component.empty(), this.valueInfo("tooltip.uncrafteverything.config.no", "tooltip.uncrafteverything.config.toggle_enable_progression_no"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.toggleOnlyAllowDefinedProgression.isHovered()) {
            tooltip = List.of(this.title("tooltip.uncrafteverything.config.toggle_only_allow_defined_progression"), this.description("tooltip.uncrafteverything.config.toggle_only_allow_defined_progression_description"), Component.empty(), this.valueInfo("tooltip.uncrafteverything.config.yes", "tooltip.uncrafteverything.config.toggle_only_allow_defined_progression_yes"), Component.empty(), this.valueInfo("tooltip.uncrafteverything.config.no", "tooltip.uncrafteverything.config.toggle_only_allow_defined_progression_no"));
            guiGraphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private Component title(String title) {
        return Component.translatable((String)title).withStyle(ChatFormatting.BLUE);
    }

    private Component valueInfo(String value, String info) {
        return Component.translatable((String)value).append(": ").withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)info).withStyle(ChatFormatting.GRAY));
    }

    private Component description(String desc) {
        return Component.translatable((String)desc).withStyle(ChatFormatting.GRAY);
    }
}

