/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.fml.loading.FMLPaths;

public class PerItemExpCostConfig {
    private static final Gson GSON = new Gson();
    private static final Type MAP_TYPE = new TypeToken<Map<String, Integer>>(){}.getType();
    private static Map<String, Integer> perItemExp = new ConcurrentHashMap<String, Integer>();
    private static final File CONFIG_FILE = new File(FMLPaths.CONFIGDIR.get().toFile(), "uncrafteverything-exp.json");
    private static WatchService watchService;
    private static Thread watchThread;

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            PerItemExpCostConfig.saveDefaults();
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Map loaded = (Map)GSON.fromJson((Reader)reader, MAP_TYPE);
            perItemExp = loaded != null ? new ConcurrentHashMap<String, Integer>(loaded) : new ConcurrentHashMap<String, Integer>();
        }
        catch (Exception e) {
            System.out.println("Failed to load per item exp config! " + e.getMessage());
            perItemExp = new ConcurrentHashMap<String, Integer>();
        }
    }

    public static void saveDefaults() {
        perItemExp.put("minecraft:diamond_sword", 2);
        PerItemExpCostConfig.save();
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(perItemExp, (Appendable)writer);
        }
        catch (Exception e) {
            System.out.println("Failed to save per item exp config! " + e.getMessage());
        }
    }

    public static Map<String, Integer> getPerItemExp() {
        if (perItemExp == null) {
            PerItemExpCostConfig.load();
        }
        return perItemExp;
    }

    public static synchronized void startWatcher() {
        if (watchThread != null && watchThread.isAlive()) {
            return;
        }
        try {
            watchService = FileSystems.getDefault().newWatchService();
            Path configDir = CONFIG_FILE.getParentFile().toPath();
            configDir.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            watchThread = new Thread(() -> {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        WatchKey key = watchService.take();
                        for (WatchEvent<?> event : key.pollEvents()) {
                            Path changed = (Path)event.context();
                            if (!changed.toString().equals(CONFIG_FILE.getName())) continue;
                            System.out.println("[UncraftEverything] Per item exp config file changed, reloading...");
                            PerItemExpCostConfig.load();
                        }
                        key.reset();
                    }
                }
                catch (ClosedWatchServiceException key) {
                }
                catch (Exception e) {
                    System.out.println("Error watching config file: " + e.getMessage());
                }
            }, "PerItemExpConfig Watcher");
            watchThread.setDaemon(true);
            watchThread.start();
        }
        catch (Exception e) {
            System.out.println("Error hot reloading per item exp config: " + e.getMessage());
        }
    }

    public static synchronized void stopWatcher() {
        try {
            if (watchService != null) {
                watchService.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (watchThread != null) {
            watchThread.interrupt();
        }
        watchService = null;
        watchThread = null;
        System.out.println("[UncraftEverything] Per item exp config watcher stopped.");
    }
}

