/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.util;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class JEIUncraftingTableRecipe {
    private final ItemStack input;
    private final List<Ingredient> outputs = new ArrayList<Ingredient>();
    private final List<ItemStack> itemStackOutputs = new ArrayList<ItemStack>();
    private final boolean isItemStackOutputs;

    public JEIUncraftingTableRecipe(ItemStack input, List<Ingredient> outputs) {
        this.input = input;
        this.outputs.addAll(outputs);
        this.isItemStackOutputs = false;
    }

    public JEIUncraftingTableRecipe(ItemStack input, List<ItemStack> outputs, boolean isItemStackOutputs) {
        this.input = input;
        this.itemStackOutputs.addAll(outputs);
        this.isItemStackOutputs = isItemStackOutputs;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public List<Ingredient> getOutputs() {
        return this.outputs;
    }

    public List<EntryIngredient> getEntryIngredientOutput() {
        ArrayList<EntryIngredient> entryIngredients = new ArrayList<EntryIngredient>();
        if (this.isItemStackOutputs) {
            for (ItemStack output : this.itemStackOutputs) {
                if (output.isEmpty()) {
                    entryIngredients.add(EntryIngredient.empty());
                    continue;
                }
                entryIngredients.add(EntryIngredients.of((ItemStack)output));
            }
        } else {
            for (Ingredient output : this.outputs) {
                if (output == null) {
                    entryIngredients.add(EntryIngredient.empty());
                    continue;
                }
                entryIngredients.add(EntryIngredients.ofIngredient((Ingredient)output));
            }
        }
        return entryIngredients;
    }
}

