/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.blockentity.custom;

import com.coolerpromc.uncrafteverything.blockentity.UEBlockEntities;
import com.coolerpromc.uncrafteverything.config.PerItemExpCostConfig;
import com.coolerpromc.uncrafteverything.config.UncraftEverythingConfig;
import com.coolerpromc.uncrafteverything.networking.UncraftingRecipeSelectionRequestPayload;
import com.coolerpromc.uncrafteverything.networking.UncraftingTableDataPayload;
import com.coolerpromc.uncrafteverything.screen.custom.UncraftingTableMenu;
import com.coolerpromc.uncrafteverything.util.ImplementedInventory;
import com.coolerpromc.uncrafteverything.util.UncraftingTableRecipe;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_10192;
import net.minecraft.class_10223;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9284;
import net.minecraft.class_9288;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9890;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class UncraftingTableBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338> {
    public static final int NO_RECIPE = 0;
    public static final int NO_SUITABLE_OUTPUT_SLOT = 1;
    public static final int NO_ENOUGH_EXPERIENCE = 2;
    public static final int NO_ENOUGH_INPUT = 3;
    public static final int SHULKER_WITH_ITEM = 4;
    public static final int RESTRICTED_ITEM = 5;
    public static final int DAMAGED_ITEM = 6;
    public static final int ENCHANTED_ITEM = 7;
    public static final int LOCKED_ITEM = 8;
    public static final int PROGRESSION_NOT_DEFINED = 9;
    private List<UncraftingTableRecipe> currentRecipes = new ArrayList<UncraftingTableRecipe>();
    private UncraftingTableRecipe currentRecipe = null;
    private class_3222 player;
    private final class_3913 data;
    private int experience = 0;
    private int experienceType;
    private int status = -1;
    private class_1799 currentStack = class_1799.field_8037;
    private int page = 0;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)10, (Object)class_1799.field_8037);
    private final int[] inputSlots = new int[]{0};
    private final int[] outputSlots = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final ImplementedInventory slots = new ImplementedInventory(10){

        public void method_5447(int slot, class_1799 stack) {
            super.method_5447(slot, stack);
            UncraftingTableBlockEntity.this.getOutputStacks();
            if (UncraftingTableBlockEntity.this.field_11863 != null && !UncraftingTableBlockEntity.this.field_11863.method_8608() && slot == UncraftingTableBlockEntity.this.inputSlots[0] && UncraftingTableBlockEntity.this.player != null) {
                if (UncraftingTableBlockEntity.this.currentStack.method_7909() != this.method_5438(0).method_7909() && !this.method_5438(0).method_7960()) {
                    for (int outputSlot : UncraftingTableBlockEntity.this.outputSlots) {
                        class_1799 outputStack = this.method_5438(outputSlot);
                        if (outputStack.method_7960()) continue;
                        UncraftingTableBlockEntity.this.player.method_31548().method_7398(outputStack);
                        this.method_5447(outputSlot, class_1799.field_8037);
                        this.method_5431();
                    }
                }
                UncraftingTableBlockEntity.this.currentStack = this.method_5438(0);
                UncraftingTableBlockEntity.this.field_11863.method_8413(UncraftingTableBlockEntity.this.field_11867, UncraftingTableBlockEntity.this.method_11010(), UncraftingTableBlockEntity.this.method_11010(), 3);
                ServerPlayNetworking.send((class_3222)UncraftingTableBlockEntity.this.player, (class_8710)new UncraftingTableDataPayload(UncraftingTableBlockEntity.this.method_11016(), new ArrayList<UncraftingTableRecipe>(UncraftingTableBlockEntity.this.currentRecipes.subList(UncraftingTableBlockEntity.this.currentRecipes.isEmpty() ? 0 : UncraftingTableBlockEntity.this.page * 7, Math.min(UncraftingTableBlockEntity.this.page * 7 + 7, UncraftingTableBlockEntity.this.currentRecipes.size()))), UncraftingTableBlockEntity.this.currentRecipes.size()));
                UncraftingTableBlockEntity.this.player.field_7512.method_7623();
            }
        }

        public class_1799 method_5441(int slot) {
            UncraftingTableBlockEntity.this.getOutputStacks();
            if (slot != 0 && UncraftingTableBlockEntity.this.player != null) {
                UncraftingTableBlockEntity.this.handleRecipeSelection(UncraftingTableBlockEntity.this.currentRecipe);
            }
            return super.method_5441(slot);
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
            return Arrays.asList(new int[][]{UncraftingTableBlockEntity.this.inputSlots}).contains(slot) && side != class_2350.field_11033;
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
            return Arrays.asList(new int[][]{UncraftingTableBlockEntity.this.outputSlots}).contains(slot) && side == class_2350.field_11033;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            return Arrays.stream(UncraftingTableBlockEntity.this.outputSlots).noneMatch(value -> value == slot);
        }
    };

    public UncraftingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(UEBlockEntities.UNCRAFTING_TABLE_BE, pos, state);
        this.experienceType = UncraftEverythingConfig.experienceType == UncraftEverythingConfig.ExperienceType.LEVEL ? 1 : 0;
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> UncraftingTableBlockEntity.this.experience;
                    case 1 -> UncraftingTableBlockEntity.this.experienceType;
                    case 2 -> UncraftingTableBlockEntity.this.status;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        UncraftingTableBlockEntity.this.experience = value;
                        break;
                    }
                    case 1: {
                        UncraftingTableBlockEntity.this.experienceType = value;
                        break;
                    }
                    case 2: {
                        UncraftingTableBlockEntity.this.status = value;
                    }
                }
            }

            public int method_17389() {
                return 3;
            }
        };
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayerEntity) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.uncrafteverything.uncrafting_table");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer;
            this.player = serverPlayer = (class_3222)player;
        }
        return new UncraftingTableMenu(syncId, playerInventory, this, this.data);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        class_1262.method_5426((class_11372)view, this.inventory);
        view.method_71465("experience", this.experience);
        view.method_71465("experienceType", this.experienceType);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        class_1262.method_5429((class_11368)view, this.inventory);
        this.experience = view.method_71424("experience", UncraftEverythingConfig.experience);
        this.experienceType = view.method_71424("experienceType", UncraftEverythingConfig.experienceType == UncraftEverythingConfig.ExperienceType.LEVEL ? 1 : 0);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public int[] getInputSlots() {
        return this.inputSlots;
    }

    public int[] getOutputSlots() {
        return this.outputSlots;
    }

    public class_2960 inputStackLocation() {
        return class_7923.field_41178.method_10221((Object)this.slots.method_5438(this.inputSlots[0]).method_7909());
    }

    public void getOutputStacks() {
        class_1860 output;
        class_3218 serverLevel;
        block68: {
            block67: {
                class_1937 class_19372 = this.field_11863;
                if (!(class_19372 instanceof class_3218)) break block67;
                serverLevel = (class_3218)class_19372;
                if (this.player != null) break block68;
            }
            return;
        }
        this.status = -1;
        class_1799 inputStack = this.slots.method_5438(this.inputSlots[0]);
        List<String> blacklist = UncraftEverythingConfig.restrictions;
        List<Pattern> wildcardBlacklist = blacklist.stream().filter(s -> s.contains("*")).map(s -> Pattern.compile(s.replace("*", ".*"))).toList();
        if (this.slots.method_5438(this.inputSlots[0]).method_7960() || (Boolean)UncraftEverythingConfig.isItemLocked(this.player, this.slots.method_5438(this.inputSlots[0])).getLeft() != false || this.slots.method_5438(this.inputSlots[0]).method_7919() > 0 && !UncraftEverythingConfig.allowDamaged() || UncraftEverythingConfig.isItemBlacklisted(this.slots.method_5438(this.inputSlots[0])) || UncraftEverythingConfig.isItemWhitelisted(this.slots.method_5438(this.inputSlots[0])) || !UncraftEverythingConfig.isEnchantedItemsAllowed(this.slots.method_5438(this.inputSlots[0])) && !inputStack.method_57826(class_9334.field_49607) || inputStack.method_7909() == class_1802.field_8545 && inputStack.method_58694(class_9334.field_49622) != class_9288.field_49334 || inputStack.method_7909() == class_1802.field_8598) {
            Pair<Boolean, Integer> isItemLocked;
            if (this.slots.method_5438(this.inputSlots[0]).method_7919() > 0 && !UncraftEverythingConfig.allowDamaged()) {
                this.status = 6;
            }
            if (UncraftEverythingConfig.isItemBlacklisted(this.slots.method_5438(this.inputSlots[0]))) {
                this.status = 5;
            }
            if (UncraftEverythingConfig.isItemWhitelisted(this.slots.method_5438(this.inputSlots[0]))) {
                this.status = 5;
            }
            if (!UncraftEverythingConfig.isEnchantedItemsAllowed(this.slots.method_5438(this.inputSlots[0])) && !inputStack.method_57826(class_9334.field_49607)) {
                this.status = 7;
            }
            if (inputStack.method_7909() == class_1802.field_8545 && inputStack.method_58694(class_9334.field_49622) != class_9288.field_49334) {
                this.status = 4;
            }
            if (this.slots.method_5438(this.inputSlots[0]).method_7960() || inputStack.method_7909() == class_1802.field_8598) {
                this.status = 0;
            }
            if (((Boolean)(isItemLocked = UncraftEverythingConfig.isItemLocked(this.player, this.slots.method_5438(this.inputSlots[0]))).getLeft()).booleanValue() && !this.slots.method_5438(this.inputSlots[0]).method_7960()) {
                this.status = (Integer)isItemLocked.getRight();
            }
            this.currentRecipes.clear();
            this.currentRecipe = null;
            this.experience = 0;
            this.method_5431();
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
            }
            return;
        }
        List<class_8786> recipes = serverLevel.method_64577().method_8126().stream().filter(recipeHolder -> {
            class_10192 component;
            if (!recipeHolder.comp_1932().method_29177().method_12836().equals("minecraft") && class_7923.field_41178.method_10221((Object)inputStack.method_7909()).method_12836().equals("minecraft") && UncraftEverythingConfig.preventModdedIngredientRecipes()) {
                return false;
            }
            class_1860 patt0$temp = recipeHolder.comp_1933();
            if (patt0$temp instanceof class_1869) {
                class_2960 assetId;
                class_1869 shapedRecipe = (class_1869)patt0$temp;
                if (shapedRecipe.field_9053.method_7909() == inputStack.method_7909() && inputStack.method_7947() < shapedRecipe.field_9053.method_7947()) {
                    this.status = 3;
                }
                if (inputStack.method_58694(class_9334.field_49633) != class_9304.field_49385 && UncraftEverythingConfig.outputEnchantedBook()) {
                    return false;
                }
                component = (class_10192)inputStack.method_58694(class_9334.field_54196);
                if (component != null && component.comp_3174() == class_1304.field_6174 && component.comp_3176().isPresent() && (assetId = ((class_5321)component.comp_3176().get()).method_29177()).method_12836().equals("elytra_chestplate")) {
                    return false;
                }
                return shapedRecipe.field_9053.method_7909() == inputStack.method_7909() && inputStack.method_7947() >= shapedRecipe.field_9053.method_7947();
            }
            class_1860 patt1$temp = recipeHolder.comp_1933();
            if (patt1$temp instanceof class_1867) {
                class_1867 shapelessRecipe = (class_1867)patt1$temp;
                if (shapelessRecipe.field_9050.method_7909() == inputStack.method_7909() && inputStack.method_7947() < shapelessRecipe.field_9050.method_7947()) {
                    this.status = 3;
                }
                if (inputStack.method_58694(class_9334.field_49633) != class_9304.field_49385 && UncraftEverythingConfig.outputEnchantedBook()) {
                    return false;
                }
                return shapelessRecipe.field_9050.method_7909() == inputStack.method_7909() && inputStack.method_7947() >= shapelessRecipe.field_9050.method_7947();
            }
            class_1860 patt2$temp = recipeHolder.comp_1933();
            if (patt2$temp instanceof class_10223) {
                class_10223 transmuteRecipe = (class_10223)patt2$temp;
                return transmuteRecipe.field_54323.comp_3483().comp_349() == inputStack.method_7909();
            }
            class_1860 patt3$temp = recipeHolder.comp_1933();
            if (patt3$temp instanceof class_8060) {
                class_8060 smithingTransformRecipe = (class_8060)patt3$temp;
                if (!UncraftEverythingConfig.allowUnSmithing()) {
                    return false;
                }
                if (inputStack.method_58694(class_9334.field_49633) != class_9304.field_49385 && UncraftEverythingConfig.outputEnchantedBook()) {
                    return false;
                }
                component = (class_10192)inputStack.method_58694(class_9334.field_54196);
                if (component != null && component.comp_3174() == class_1304.field_6174 && component.comp_3176().isPresent()) {
                    class_2960 assetId = ((class_5321)component.comp_3176().get()).method_29177();
                    if (!assetId.method_12836().equals("elytra_chestplate") && smithingTransformRecipe.method_64722().isEmpty()) {
                        return false;
                    }
                    if (inputStack.method_31574(class_1802.field_22028) && smithingTransformRecipe.method_64722().isPresent() && assetId.method_12836().equals("elytra_chestplate")) {
                        return false;
                    }
                }
                return inputStack.method_31574((class_1792)smithingTransformRecipe.field_42033.comp_3483().comp_349());
            }
            class_1860 patt4$temp = recipeHolder.comp_1933();
            if (patt4$temp instanceof class_8062) {
                Optional ingredient;
                class_8062 smithingTrimRecipe = (class_8062)patt4$temp;
                if (!UncraftEverythingConfig.allowUnSmithing()) {
                    return false;
                }
                class_8053 armorTrim = (class_8053)inputStack.method_58694(class_9334.field_49607);
                if (armorTrim != null && (ingredient = smithingTrimRecipe.method_64724()).isPresent() && armorTrim.comp_3180().equals((Object)smithingTrimRecipe.field_56321)) {
                    return true;
                }
            }
            if (this.status == -1) {
                this.status = 0;
            }
            return false;
        }).toList();
        if (!recipes.isEmpty() || inputStack.method_31574(class_1802.field_8087) || UncraftEverythingConfig.allowEnchantedItems && inputStack.method_58694(class_9334.field_49633) != class_9304.field_49385) {
            this.status = -1;
            this.experience = this.getExperience();
            this.experienceType = UncraftEverythingConfig.experienceType == UncraftEverythingConfig.ExperienceType.LEVEL ? 1 : 0;
        }
        ArrayList<UncraftingTableRecipe> outputs = new ArrayList<UncraftingTableRecipe>();
        if (inputStack.method_31574(class_1802.field_8087)) {
            class_1844 potionContents = (class_1844)inputStack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
            UncraftingTableRecipe outputStack = new UncraftingTableRecipe(new class_1799((class_1935)inputStack.method_7909(), 8));
            class_1799 potion = new class_1799((class_1935)class_1802.field_8150);
            potion.method_57379(class_9334.field_49651, (Object)potionContents);
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(potion);
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputStack.addOutput(new class_1799((class_1935)class_1802.field_8107, 1));
            outputs.add(outputStack);
        }
        if (inputStack.method_58694(class_9334.field_49633) != class_9304.field_49385 && recipes.isEmpty() && UncraftEverythingConfig.outputEnchantedBook()) {
            UncraftingTableRecipe outputStack = new UncraftingTableRecipe(new class_1799((class_1935)inputStack.method_7909(), 1));
            class_9304 enchantments = (class_9304)inputStack.method_58694(class_9334.field_49633);
            class_1799 book = new class_1799((class_1935)class_1802.field_8598);
            book.method_57379(class_9334.field_49643, (Object)enchantments);
            output = new class_1799((class_1935)inputStack.method_7909(), 1);
            output.method_7974(inputStack.method_7919());
            outputStack.addOutput((class_1799)output);
            outputStack.addOutput(book);
            outputs.add(outputStack);
        }
        for (class_8786 r : recipes) {
            List<List<class_1792>> allIngredientCombinations;
            class_1799 stack;
            Object allIngredientCombinations2;
            Object allIngredientCombinations22;
            Object ingredients;
            output = r.comp_1933();
            if (output instanceof class_10223) {
                class_10223 transmuteRecipe = (class_10223)output;
                ingredients = List.of(transmuteRecipe.field_54321, transmuteRecipe.field_54322);
                allIngredientCombinations22 = this.getAllShapelessIngredientCombinations((List<class_1856>)ingredients);
                class_9288 itemContainerContents = (class_9288)inputStack.method_58694(class_9334.field_49622);
                Iterator iterator = allIngredientCombinations22.iterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    UncraftingTableRecipe outputStack2 = new UncraftingTableRecipe(new class_1799((class_1935)transmuteRecipe.field_54323.comp_3483().comp_349(), 1));
                    for (class_1792 item2 : list) {
                        if (outputStack2.getOutputs().contains(item2.method_7854())) {
                            class_1799 stack2 = outputStack2.getOutputs().get(outputStack2.getOutputs().indexOf(item2.method_7854()));
                            if (stack2.method_57826(class_9334.field_49622)) {
                                stack2.method_57379(class_9334.field_49622, (Object)itemContainerContents);
                            }
                            stack2.method_7939(stack2.method_7947() + 1);
                            outputStack2.setOutput(outputStack2.getOutputs().indexOf(item2.method_7854()), stack2);
                            continue;
                        }
                        class_1799 itemStack = new class_1799((class_1935)item2, 1);
                        if (itemStack.method_57826(class_9334.field_49622)) {
                            itemStack.method_57379(class_9334.field_49622, (Object)itemContainerContents);
                        }
                        outputStack2.addOutput(itemStack);
                    }
                    outputs.add(outputStack2);
                }
            }
            if ((ingredients = r.comp_1933()) instanceof class_1869) {
                class_1869 shapedRecipe = (class_1869)ingredients;
                allIngredientCombinations2 = this.getAllIngredientCombinations(shapedRecipe.method_61693());
                allIngredientCombinations22 = allIngredientCombinations2.iterator();
                while (allIngredientCombinations22.hasNext()) {
                    List ingredientCombination = (List)allIngredientCombinations22.next();
                    UncraftingTableRecipe outputStack3 = new UncraftingTableRecipe(new class_1799((class_1935)shapedRecipe.field_9053.method_7909(), shapedRecipe.field_9053.method_7947()));
                    HashMap<class_1792, Integer> hashMap = new HashMap<class_1792, Integer>();
                    for (class_1792 class_17922 : ingredientCombination) {
                        if (outputStack3.getOutputs().contains(class_17922.method_7854())) {
                            stack = outputStack3.getOutputs().get(outputStack3.getOutputs().indexOf(class_17922.method_7854()));
                            outputStack3.setOutput(outputStack3.getOutputs().indexOf(class_17922.method_7854()), new class_1799((class_1935)stack.method_7909(), stack.method_7947() + 1));
                        } else {
                            outputStack3.addOutput(new class_1799((class_1935)class_17922, 1));
                        }
                        hashMap.put(class_17922, hashMap.getOrDefault(class_17922, 0) + 1);
                    }
                    if (inputStack.method_7986()) {
                        class_9890 repairableComponent = (class_9890)inputStack.method_58694(class_9334.field_53696);
                        if (repairableComponent != null) {
                            for (Map.Entry x : hashMap.entrySet()) {
                                if (!repairableComponent.method_61713(new class_1799((class_1935)x.getKey(), ((Integer)x.getValue()).intValue()))) continue;
                                int damagedPercentage = (int)Math.ceil((double)inputStack.method_7919() / (double)inputStack.method_7936() * (double)((Integer)x.getValue()).intValue());
                                for (int i = 0; i < outputStack3.getOutputs().size() && damagedPercentage != 0; ++i) {
                                    if (!outputStack3.getOutputs().get(i).method_31574((class_1792)x.getKey())) continue;
                                    outputStack3.setOutput(i, class_1799.field_8037);
                                    --damagedPercentage;
                                }
                                break;
                            }
                        } else {
                            this.status = 6;
                            outputs.clear();
                            return;
                        }
                    }
                    outputs.add(outputStack3);
                }
            }
            if ((allIngredientCombinations2 = r.comp_1933()) instanceof class_1867) {
                class_9284 fireworks;
                class_1867 shapelessRecipe = (class_1867)allIngredientCombinations2;
                ingredients = new ArrayList(shapelessRecipe.field_9047);
                if (inputStack.method_57826(class_9334.field_49616) && (fireworks = (class_9284)inputStack.method_58694(class_9334.field_49616)) != null) {
                    for (int i = 1; i < fireworks.comp_2391(); ++i) {
                        ingredients.add(class_1856.method_8101((class_1935)class_1802.field_8054));
                    }
                }
                allIngredientCombinations = this.getAllShapelessIngredientCombinations((List<class_1856>)ingredients);
                for (List<class_1792> ingredientCombination : allIngredientCombinations) {
                    UncraftingTableRecipe uncraftingTableRecipe = new UncraftingTableRecipe(new class_1799((class_1935)shapelessRecipe.field_9050.method_7909(), shapelessRecipe.field_9050.method_7947()));
                    HashMap<Object, Integer> allIngredients = new HashMap<Object, Integer>();
                    for (Object item : ingredientCombination) {
                        if (item == class_1802.field_8162) continue;
                        if (uncraftingTableRecipe.getOutputs().contains(item.method_7854())) {
                            class_1799 stack3 = uncraftingTableRecipe.getOutputs().get(uncraftingTableRecipe.getOutputs().indexOf(item.method_7854()));
                            uncraftingTableRecipe.setOutput(uncraftingTableRecipe.getOutputs().indexOf(item.method_7854()), new class_1799((class_1935)stack3.method_7909(), stack3.method_7947() + 1));
                        } else {
                            uncraftingTableRecipe.addOutput(new class_1799((class_1935)item, 1));
                        }
                        allIngredients.put(item, allIngredients.getOrDefault(item, 0) + 1);
                    }
                    if (inputStack.method_7986()) {
                        class_9890 class_98902 = (class_9890)inputStack.method_58694(class_9334.field_53696);
                        if (class_98902 != null) {
                            Object item;
                            item = allIngredients.entrySet().iterator();
                            while (item.hasNext()) {
                                Map.Entry x = (Map.Entry)item.next();
                                if (!class_98902.method_61713(new class_1799((class_1935)x.getKey(), ((Integer)x.getValue()).intValue()))) continue;
                                int damagedPercentage = (int)Math.ceil((double)inputStack.method_7919() / (double)inputStack.method_7936() * (double)((Integer)x.getValue()).intValue());
                                for (int i = 0; i < uncraftingTableRecipe.getOutputs().size() && damagedPercentage != 0; ++i) {
                                    if (!uncraftingTableRecipe.getOutputs().get(i).method_31574((class_1792)x.getKey())) continue;
                                    uncraftingTableRecipe.setOutput(i, class_1799.field_8037);
                                    --damagedPercentage;
                                }
                                break;
                            }
                        } else {
                            this.status = 6;
                            outputs.clear();
                            return;
                        }
                    }
                    outputs.add(uncraftingTableRecipe);
                }
            }
            if ((ingredients = r.comp_1933()) instanceof class_8060) {
                class_8060 smithingTransformRecipe = (class_8060)ingredients;
                ingredients = new ArrayList();
                ingredients.add(Optional.of(smithingTransformRecipe.method_64723()));
                ingredients.add(smithingTransformRecipe.method_64724());
                ingredients.add(smithingTransformRecipe.method_64722());
                allIngredientCombinations = this.getAllIngredientCombinations((List<Optional<class_1856>>)ingredients);
                for (List<class_1792> ingredientCombination : allIngredientCombinations) {
                    UncraftingTableRecipe uncraftingTableRecipe = new UncraftingTableRecipe(new class_1799((class_1935)smithingTransformRecipe.field_42033.comp_3483().comp_349(), 1));
                    for (class_1792 class_17923 : ingredientCombination) {
                        if (uncraftingTableRecipe.getOutputs().contains(class_17923.method_7854())) {
                            stack = uncraftingTableRecipe.getOutputs().get(uncraftingTableRecipe.getOutputs().indexOf(class_17923.method_7854()));
                            if (class_17923.method_7854().method_7963()) {
                                stack.method_57379(class_9334.field_49629, (Object)((Integer)inputStack.method_58694(class_9334.field_49629)));
                            }
                            stack.method_7933(1);
                            uncraftingTableRecipe.setOutput(uncraftingTableRecipe.getOutputs().indexOf(class_17923.method_7854()), stack);
                            continue;
                        }
                        class_1799 itemStack = new class_1799((class_1935)class_17923, 1);
                        if (class_17923.method_7854().method_7963()) {
                            itemStack.method_57379(class_9334.field_49629, (Object)((Integer)inputStack.method_58694(class_9334.field_49629)));
                            if ((Integer)itemStack.method_58695(class_9334.field_49629, (Object)0) >= (Integer)itemStack.method_58695(class_9334.field_50072, (Object)0)) {
                                itemStack = class_1799.field_8037;
                            }
                        }
                        uncraftingTableRecipe.addOutput(itemStack);
                    }
                    outputs.add(uncraftingTableRecipe);
                }
            }
            if (!((ingredients = r.comp_1933()) instanceof class_8062)) continue;
            class_8062 smithingTrimRecipe = (class_8062)ingredients;
            class_8053 armorTrim = (class_8053)inputStack.method_58694(class_9334.field_49607);
            Optional additionIngredient = smithingTrimRecipe.method_64724();
            ArrayList<Optional<class_1856>> ingredients2 = new ArrayList<Optional<class_1856>>();
            smithingTrimRecipe.method_64723().method_8105().filter(itemHolder -> inputStack.method_31574((class_1792)itemHolder.comp_349())).forEach(itemHolder -> ingredients2.add(Optional.of(class_1856.method_8101((class_1935)((class_1935)itemHolder.comp_349())))));
            ingredients2.add(smithingTrimRecipe.method_64722());
            if (additionIngredient.isPresent() && armorTrim != null) {
                ((class_1856)additionIngredient.get()).method_8105().filter(itemHolder -> {
                    class_5321 itemResourceKey = itemHolder.method_40230().orElse(null);
                    class_5321 armorTrimKey = armorTrim.comp_3179().method_40230().orElse(null);
                    if (itemResourceKey != null && armorTrimKey != null) {
                        return itemResourceKey.method_29177().method_12832().contains(armorTrimKey.method_29177().method_12832());
                    }
                    return false;
                }).forEach(itemHolder -> ingredients2.add(Optional.of(class_1856.method_8101((class_1935)((class_1935)itemHolder.comp_349())))));
            }
            List<List<class_1792>> allIngredientCombinations3 = this.getAllIngredientCombinations(ingredients2);
            class_9304 class_93042 = (class_9304)inputStack.method_58694(class_9334.field_49633);
            for (List<class_1792> list : allIngredientCombinations3) {
                UncraftingTableRecipe outputStack4 = new UncraftingTableRecipe(inputStack.method_46651(1));
                for (class_1792 item4 : list) {
                    if (outputStack4.getOutputs().contains(item4.method_7854())) {
                        class_1799 stack4 = outputStack4.getOutputs().get(outputStack4.getOutputs().indexOf(item4.method_7854()));
                        if (item4.method_7854().method_31574(((Optional)ingredients2.getFirst()).isPresent() ? (class_1792)((class_6880)((class_1856)((Optional)ingredients2.getFirst()).get()).method_8105().toList().getFirst()).comp_349() : class_1802.field_8162)) {
                            stack4.method_57379(class_9334.field_49633, (Object)class_93042);
                            stack4.method_57379(class_9334.field_49629, (Object)((Integer)inputStack.method_58694(class_9334.field_49629)));
                        }
                        stack4.method_7939(stack4.method_7947() + 1);
                        outputStack4.setOutput(outputStack4.getOutputs().indexOf(item4.method_7854()), stack4);
                        continue;
                    }
                    class_1799 itemStack = new class_1799((class_1935)item4, 1);
                    if (item4.method_7854().method_31574(((Optional)ingredients2.getFirst()).isPresent() ? (class_1792)((class_6880)((class_1856)((Optional)ingredients2.getFirst()).get()).method_8105().toList().getFirst()).comp_349() : class_1802.field_8162)) {
                        itemStack.method_57379(class_9334.field_49633, (Object)class_93042);
                        itemStack.method_57379(class_9334.field_49629, (Object)((Integer)inputStack.method_58694(class_9334.field_49629)));
                    }
                    outputStack4.addOutput(itemStack);
                }
                outputs.add(outputStack4);
            }
        }
        this.currentRecipes = outputs;
        if (!this.currentRecipes.isEmpty()) {
            ServerPlayNetworking.send((class_3222)this.player, (class_8710)new UncraftingRecipeSelectionRequestPayload());
            if (!this.hasRecipe()) {
                this.status = 1;
            } else if (!this.hasEnoughExperience()) {
                this.status = 2;
            }
        } else if (this.status == -1) {
            this.status = 0;
        }
    }

    private List<class_1792> getItemsFromIngredient(class_1856 ingredient) {
        List<Object> items = new ArrayList();
        if (ingredient.getCustomIngredient() != null && !ingredient.getCustomIngredient().getMatchingItems().toList().isEmpty()) {
            for (class_6880 holder : ingredient.getCustomIngredient().getMatchingItems().toList()) {
                items.add((class_1792)holder.comp_349());
            }
        } else {
            try {
                items = ingredient.method_8105().toList().stream().map(class_6880::comp_349).distinct().toList();
            }
            catch (IllegalStateException e) {
                LogUtils.getLogger().warn("Skipping unsupported ingredient type: {}", (Object)ingredient);
                return Collections.emptyList();
            }
        }
        return items.stream().filter(item -> {
            if (item.method_7876().contains("shulker_box")) {
                return item == class_1802.field_8545;
            }
            return item.getRecipeRemainder(item.method_7854()) == class_1799.field_8037 || item.getRecipeRemainder(item.method_7854()).method_7909() != item.method_7854().method_7909();
        }).sorted(Comparator.comparing(class_1792::method_7876)).toList();
    }

    private List<List<class_1792>> getAllIngredientCombinations(List<Optional<class_1856>> ingredients) {
        HashMap<String, Group> groupKeyToGroup = new HashMap<String, Group>();
        for (int i = 0; i < ingredients.size(); ++i) {
            List<class_1792> items;
            Optional<class_1856> optIngredient = ingredients.get(i);
            List<class_1792> finalItems1 = items = optIngredient.map(ingredient -> {
                List<class_1792> ingredientItems = this.getItemsFromIngredient((class_1856)ingredient);
                return ingredientItems.isEmpty() ? List.of(class_1802.field_8162) : ingredientItems;
            }).orElse(List.of(class_1802.field_8162));
            items = items.stream().filter(item -> {
                boolean isVanillaInput = class_7923.field_41178.method_10221((Object)this.slots.method_5438(0).method_7909()).method_12836().equals("minecraft");
                if (isVanillaInput && UncraftEverythingConfig.preventModdedIngredientRecipes()) {
                    return class_7923.field_41178.method_10221(item).method_12836().equals("minecraft");
                }
                if (finalItems1.size() > 1) {
                    class_2960 ingredientRL = class_7923.field_41178.method_10221(item);
                    return !UncraftEverythingConfig.getRestrictedModIngredients().contains(ingredientRL.method_12836());
                }
                return true;
            }).toList();
            String key = items.stream().map(class_1792::method_7876).sorted().collect(Collectors.joining(","));
            List<class_1792> finalItems = items;
            Group group2 = groupKeyToGroup.computeIfAbsent(key, k -> new Group(new ArrayList<Integer>(), finalItems));
            group2.positions.add(i);
        }
        ArrayList groups = new ArrayList(groupKeyToGroup.values());
        List groupChoices = groups.stream().map(group -> group.items).collect(Collectors.toList());
        List product = UncraftingTableBlockEntity.cartesianProduct(groupChoices);
        ArrayList<List<class_1792>> combinations = new ArrayList<List<class_1792>>();
        for (List choiceList : product) {
            Object[] itemsArray = new class_1792[ingredients.size()];
            Arrays.fill(itemsArray, class_1802.field_8162);
            for (int groupIdx = 0; groupIdx < groups.size(); ++groupIdx) {
                Group group3 = (Group)groups.get(groupIdx);
                class_1792 chosenItem = (class_1792)choiceList.get(groupIdx);
                for (int pos : group3.positions) {
                    if (pos < 0 || pos >= itemsArray.length) continue;
                    itemsArray[pos] = chosenItem;
                }
            }
            combinations.add(Arrays.asList(itemsArray));
        }
        return combinations;
    }

    private List<List<class_1792>> getAllShapelessIngredientCombinations(List<class_1856> ingredients) {
        HashMap<String, Group> groupKeyToGroup = new HashMap<String, Group>();
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1856 ingredient = ingredients.get(i);
            List<class_1792> items = this.getItemsFromIngredient(ingredient);
            if (items.isEmpty()) {
                items = List.of(class_1802.field_8162);
            }
            List<class_1792> finalItems1 = items;
            items = items.stream().filter(item -> {
                boolean isVanillaInput = class_7923.field_41178.method_10221((Object)this.slots.method_5438(0).method_7909()).method_12836().equals("minecraft");
                if (isVanillaInput && UncraftEverythingConfig.preventModdedIngredientRecipes()) {
                    return class_7923.field_41178.method_10221(item).method_12836().equals("minecraft");
                }
                if (finalItems1.size() > 1) {
                    class_2960 ingredientRL = class_7923.field_41178.method_10221(item);
                    return !UncraftEverythingConfig.getRestrictedModIngredients().contains(ingredientRL.method_12836());
                }
                return true;
            }).toList();
            String key = items.stream().map(class_1792::method_7876).sorted().collect(Collectors.joining(","));
            List<class_1792> finalItems = items;
            Group group2 = groupKeyToGroup.computeIfAbsent(key, k -> new Group(new ArrayList<Integer>(), finalItems));
            group2.positions.add(i);
        }
        ArrayList groups = new ArrayList(groupKeyToGroup.values());
        List groupChoices = groups.stream().map(group -> group.items).collect(Collectors.toList());
        List product = UncraftingTableBlockEntity.cartesianProduct(groupChoices);
        ArrayList<List<class_1792>> combinations = new ArrayList<List<class_1792>>();
        for (List choiceList : product) {
            Object[] itemsArray = new class_1792[ingredients.size()];
            Arrays.fill(itemsArray, class_1802.field_8162);
            for (int groupIdx = 0; groupIdx < groups.size(); ++groupIdx) {
                Group group3 = (Group)groups.get(groupIdx);
                class_1792 chosenItem = (class_1792)choiceList.get(groupIdx);
                for (int pos : group3.positions) {
                    if (pos < 0 || pos >= itemsArray.length) continue;
                    itemsArray[pos] = chosenItem;
                }
            }
            combinations.add(Arrays.asList(itemsArray));
        }
        return combinations;
    }

    private static <T> List<List<T>> cartesianProduct(List<List<T>> lists) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (lists.isEmpty()) {
            result.add(new ArrayList());
            return result;
        }
        List<T> firstList = lists.getFirst();
        List<List<T>> remainingLists = UncraftingTableBlockEntity.cartesianProduct(lists.subList(1, lists.size()));
        for (T item : firstList) {
            for (List<T> remaining : remainingLists) {
                ArrayList<T> combination = new ArrayList<T>();
                combination.add(item);
                combination.addAll(remaining);
                result.add(combination);
            }
        }
        return result;
    }

    public static boolean isVanillaIngredientRecipe(class_1860<?> recipe) {
        List<Optional> ingredients;
        if (recipe instanceof class_1869) {
            class_1869 shaped = (class_1869)recipe;
            ingredients = shaped.method_61693();
        } else if (recipe instanceof class_1867) {
            class_1867 shapeless = (class_1867)recipe;
            ingredients = shapeless.field_9047.stream().map(Optional::of).toList();
        } else if (recipe instanceof class_8060) {
            class_8060 smithingTransformRecipe = (class_8060)recipe;
            ingredients = List.of(Optional.of(smithingTransformRecipe.method_64723()), smithingTransformRecipe.method_64724(), smithingTransformRecipe.method_64722());
        } else {
            return true;
        }
        for (Optional ingredient : ingredients) {
            if (!ingredient.isPresent()) continue;
            if (((class_1856)ingredient.get()).getCustomIngredient() != null && !((class_1856)ingredient.get()).getCustomIngredient().getMatchingItems().toList().isEmpty()) {
                if (((class_1856)ingredient.get()).getCustomIngredient().getMatchingItems().map(class_6880::comp_349).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).map(class_2960::method_12836).toList().contains("minecraft")) continue;
                return false;
            }
            if (((class_1856)ingredient.get()).method_8105().map(class_6880::comp_349).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).map(class_2960::method_12836).toList().contains("minecraft")) continue;
            return false;
        }
        return true;
    }

    public void handleUncraftButtonClicked(boolean hasShiftDown) {
        if (hasShiftDown) {
            while (this.hasRecipe() && this.hasEnoughExperience()) {
                this.processUncraft(this.hasNextRecipe());
            }
        } else if (this.hasRecipe() && this.hasEnoughExperience()) {
            this.processUncraft(false);
        }
    }

    private void processUncraft(boolean hasNext) {
        List<class_1799> outputs = this.currentRecipe.getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            class_1799 output = outputs.get(i);
            if (i >= this.outputSlots.length) continue;
            class_1799 slotStack = this.slots.method_5438(this.outputSlots[i]);
            if (slotStack.method_7960()) {
                this.slots.method_5447(this.outputSlots[i], output.method_7972());
                continue;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)output) || slotStack.method_7947() + output.method_7947() > slotStack.method_7914()) continue;
            slotStack.method_7933(output.method_7947());
            this.slots.method_5447(this.outputSlots[i], slotStack);
        }
        if (UncraftEverythingConfig.experienceType.equals((Object)UncraftEverythingConfig.ExperienceType.POINT)) {
            this.player.method_7255(-this.getExperience());
        } else if (UncraftEverythingConfig.experienceType.equals((Object)UncraftEverythingConfig.ExperienceType.LEVEL)) {
            this.player.method_7316(-this.getExperience());
        }
        this.slots.method_5434(0, this.currentRecipe.getInput().method_7947());
        this.method_5431();
        this.getOutputStacks();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            if (!hasNext) {
                ServerPlayNetworking.send((class_3222)this.player, (class_8710)new UncraftingTableDataPayload(this.method_11016(), new ArrayList<UncraftingTableRecipe>(this.currentRecipes.subList(this.currentRecipes.isEmpty() ? 0 : this.page * 7, Math.min(this.page * 7 + 7, this.currentRecipes.size()))), this.currentRecipes.size()));
            }
        }
    }

    public void handleRecipeSelection(UncraftingTableRecipe recipe) {
        this.currentRecipe = recipe;
        this.status = !this.hasRecipe() ? (this.slots.method_5438(0).method_7960() ? 0 : (((Boolean)UncraftEverythingConfig.isItemLocked(this.player, this.slots.method_5438(this.inputSlots[0])).getLeft()).booleanValue() ? 8 : 1)) : (this.hasEnoughExperience() ? -1 : 2);
    }

    public void updatePage(int page) {
        this.page = page;
        ServerPlayNetworking.send((class_3222)this.player, (class_8710)new UncraftingTableDataPayload(this.method_11016(), new ArrayList<UncraftingTableRecipe>(this.currentRecipes.subList(page * 7, Math.min(page * 7 + 7, this.currentRecipes.size()))), this.currentRecipes.size()));
    }

    private int getExperience() {
        Map<String, Integer> experienceMap = PerItemExpCostConfig.getPerItemExp();
        int experience = experienceMap.getOrDefault(this.inputStackLocation().toString(), UncraftEverythingConfig.getExperience());
        for (Map.Entry<String, Integer> exp : experienceMap.entrySet()) {
            String regex;
            String tagName;
            Optional<class_6862<class_1792>> tagKey;
            if (exp.getKey().startsWith("#") && (tagKey = UncraftEverythingConfig.tryParseTagKey(tagName = exp.getKey().substring(1))).isPresent() && this.slots.method_5438(this.inputSlots[0]).method_31573(tagKey.get())) {
                experience = exp.getValue();
                break;
            }
            if (!exp.getKey().contains("*") || !Pattern.matches(regex = exp.getKey().replace("*", ".*"), this.inputStackLocation().toString())) continue;
            experience = exp.getValue();
            break;
        }
        return experience;
    }

    private boolean hasEnoughExperience() {
        if (UncraftEverythingConfig.experienceType.equals((Object)UncraftEverythingConfig.ExperienceType.POINT)) {
            return this.player.field_7495 >= this.getExperience() || this.player.method_68878();
        }
        if (UncraftEverythingConfig.experienceType.equals((Object)UncraftEverythingConfig.ExperienceType.LEVEL)) {
            return this.player.field_7520 >= this.getExperience() || this.player.method_68878();
        }
        return true;
    }

    private boolean hasRecipe() {
        if (this.currentRecipes.isEmpty() || this.currentRecipe == null) {
            return false;
        }
        class_1799 inputStack = this.slots.method_5438(this.inputSlots[0]);
        if (inputStack.method_7947() < this.currentRecipe.getInput().method_7947()) {
            return false;
        }
        List<class_1799> results = this.currentRecipe.getOutputs();
        for (int i = 0; i < results.size(); ++i) {
            class_1799 result = results.get(i);
            if (i >= this.outputSlots.length) {
                return false;
            }
            class_1799 slotStack = this.slots.method_5438(this.outputSlots[i]);
            if (slotStack.method_7960()) continue;
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)result)) {
                return false;
            }
            if (slotStack.method_7947() + result.method_7947() <= slotStack.method_7914()) continue;
            return false;
        }
        return true;
    }

    private boolean hasNextRecipe() {
        if (this.currentRecipes.isEmpty() || this.currentRecipe == null) {
            return false;
        }
        if (this.slots.method_5438(this.inputSlots[0]).method_7947() - this.currentRecipe.getInput().method_7947() < this.currentRecipe.getInput().method_7947()) {
            return false;
        }
        List<class_1799> results = this.currentRecipe.getOutputs();
        for (int i = 0; i < results.size(); ++i) {
            class_1799 result = results.get(i);
            if (i >= this.outputSlots.length) {
                return false;
            }
            class_1799 slotStack = this.slots.method_5438(this.outputSlots[i]);
            if (slotStack.method_7960()) continue;
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)result)) {
                return false;
            }
            if (slotStack.method_7947() + result.method_7947() * 2 <= slotStack.method_7914()) continue;
            return false;
        }
        return true;
    }

    public List<UncraftingTableRecipe> getCurrentRecipes() {
        return this.currentRecipes;
    }

    public class_3913 getData() {
        return this.data;
    }

    public ImplementedInventory getSlots() {
        return this.slots;
    }

    private static class Group {
        List<Integer> positions;
        List<class_1792> items;

        Group(List<Integer> positions, List<class_1792> items) {
            this.positions = positions;
            this.items = items;
        }
    }
}

