/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.uncrafteverything.config;

import com.coolerpromc.uncrafteverything.config.UncraftEverythingConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class FTBQuestProgressionConfig {
    private static final Gson GSON = new Gson();
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static Map<String, String> progressionMap = new ConcurrentHashMap<String, String>();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "uncrafteverything-ftbquest-progression.json");
    private static WatchService watchService;
    private static Thread watchThread;

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            FTBQuestProgressionConfig.saveDefaults();
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Map loaded = (Map)GSON.fromJson((Reader)reader, MAP_TYPE);
            progressionMap = loaded != null ? new ConcurrentHashMap<String, String>(loaded) : new ConcurrentHashMap<String, String>();
        }
        catch (Exception e) {
            System.out.println("Failed to load ftb quest progression config! " + e.getMessage());
            progressionMap = new ConcurrentHashMap<String, String>();
        }
    }

    public static void saveDefaults() {
        progressionMap.put("item_id/item_tags/item_id_wildcard", "ftb_quest_id_here");
        FTBQuestProgressionConfig.save();
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(progressionMap, (Appendable)writer);
        }
        catch (Exception e) {
            System.out.println("Failed to save ftb quest progression config! " + e.getMessage());
        }
    }

    public static Map<String, String> getProgressionMap() {
        if (progressionMap == null) {
            FTBQuestProgressionConfig.load();
        }
        return progressionMap;
    }

    public static synchronized void startWatcher() {
        if (watchThread != null && watchThread.isAlive()) {
            return;
        }
        try {
            watchService = FileSystems.getDefault().newWatchService();
            Path configDir = CONFIG_FILE.getParentFile().toPath();
            configDir.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            watchThread = new Thread(() -> {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        WatchKey key = watchService.take();
                        for (WatchEvent<?> event : key.pollEvents()) {
                            Path changed = (Path)event.context();
                            if (!changed.toString().equals(CONFIG_FILE.getName())) continue;
                            System.out.println("[UncraftEverything] ftb quest progression config file changed, reloading...");
                            FTBQuestProgressionConfig.load();
                        }
                        key.reset();
                    }
                }
                catch (ClosedWatchServiceException key) {
                }
                catch (Exception e) {
                    System.out.println("Error watching config file: " + e.getMessage());
                }
            }, "PerItemExpConfig Watcher");
            watchThread.setDaemon(true);
            watchThread.start();
        }
        catch (Exception e) {
            System.out.println("Error hot reloading ftb quest progression config: " + e.getMessage());
        }
    }

    public static synchronized void stopWatcher() {
        try {
            if (watchService != null) {
                watchService.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (watchThread != null) {
            watchThread.interrupt();
        }
        watchService = null;
        watchThread = null;
        System.out.println("[UncraftEverything] ftb quest progression config watcher stopped.");
    }

    public static String getQuestId(class_1799 itemStack) {
        Map<String, String> questMap = FTBQuestProgressionConfig.getProgressionMap();
        for (Map.Entry<String, String> map : questMap.entrySet()) {
            String regex;
            String tagName;
            Optional<class_6862<class_1792>> tagKey;
            if (map.getKey().startsWith("#") && (tagKey = UncraftEverythingConfig.tryParseTagKey(tagName = map.getKey().substring(1))).isPresent() && itemStack.method_31573(tagKey.get())) {
                return map.getValue();
            }
            if (!map.getKey().contains("*") || !Pattern.matches(regex = map.getKey().replace("*", ".*"), FTBQuestProgressionConfig.getItemLocation(itemStack).toString())) continue;
            return map.getValue();
        }
        return null;
    }

    private static class_2960 getItemLocation(class_1799 itemStack) {
        return class_7923.field_41178.method_10221((Object)itemStack.method_7909());
    }
}

