/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.afewswords.init;

import net.mcreator.afewswords.potion.SmallEffectMobEffect;
import net.mcreator.afewswords.potion.UraniumEffectMobEffect;
import net.mcreator.afewswords.procedures.UraniumEffectEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class AFewSwordsModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"a_few_swords");
    public static final DeferredHolder<MobEffect, MobEffect> URANIUM_EFFECT = REGISTRY.register("uranium_effect", () -> new UraniumEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SMALL_EFFECT = REGISTRY.register("small_effect", () -> new SmallEffectMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            AFewSwordsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            AFewSwordsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(URANIUM_EFFECT)) {
            UraniumEffectEffectExpiresProcedure.execute((LevelAccessor)entity.level(), entity);
        }
    }
}

