/*
 * Decompiled with CFR 0.152.
 */
package com.example.mobcash;

import com.example.mobcash.MobCashCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class MobCash
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private Random random = new Random();
    private Map<EntityType, MobDropSettings> mobDropSettings = new HashMap<EntityType, MobDropSettings>();
    private Map<String, String> denominationCommands = new HashMap<String, String>();
    private List<String> specialMobs = new ArrayList<String>();
    private boolean debugMode;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.loadConfiguration();
        this.getCommand("mobcash").setExecutor(new MobCashCommand(this));
        this.getLogger().info("MobCash has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("MobCash has been disabled!");
    }

    private void loadConfiguration() {
        this.debugMode = this.config.getBoolean("debug-mode", false);
        ConfigurationSection denomSection = this.config.getConfigurationSection("denominations");
        if (denomSection != null) {
            for (String denom : denomSection.getKeys(false)) {
                String command = denomSection.getString(denom);
                this.denominationCommands.put(denom, command);
                if (!this.debugMode) continue;
                this.getLogger().info("Loaded denomination: " + denom + " with command: " + command);
            }
        }
        this.specialMobs = this.config.getStringList("special-mobs");
        ConfigurationSection mobsSection = this.config.getConfigurationSection("mobs");
        if (mobsSection != null) {
            for (String mobKey : mobsSection.getKeys(false)) {
                try {
                    EntityType entityType = EntityType.valueOf(mobKey.toUpperCase());
                    ConfigurationSection mobSection = mobsSection.getConfigurationSection(mobKey);
                    if (mobSection == null) continue;
                    double dropChance = mobSection.getDouble("drop-chance", 0.0);
                    HashMap<String, Double> denomChances = new HashMap<String, Double>();
                    ConfigurationSection denomChancesSection = mobSection.getConfigurationSection("denomination-chances");
                    if (denomChancesSection != null) {
                        for (String denom : denomChancesSection.getKeys(false)) {
                            double chance = denomChancesSection.getDouble(denom, 0.0);
                            denomChances.put(denom, chance);
                        }
                    }
                    MobDropSettings settings = new MobDropSettings(dropChance, denomChances);
                    this.mobDropSettings.put(entityType, settings);
                    if (!this.debugMode) continue;
                    this.getLogger().info("Loaded settings for " + mobKey + " with drop chance: " + dropChance);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid mob type in config: " + mobKey);
                }
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        EntityType entityType = entity.getType();
        if (this.mobDropSettings.containsKey(entityType)) {
            String commandTemplate;
            Location deathLocation;
            World world;
            String denomination;
            MobDropSettings settings = this.mobDropSettings.get(entityType);
            if (this.random.nextDouble() <= settings.getDropChance() && (denomination = this.getRandomDenomination(settings.getDenomChances())) != null && !denomination.isEmpty() && (world = (deathLocation = entity.getLocation()).getWorld()) != null && (commandTemplate = this.denominationCommands.get(denomination)) != null) {
                boolean isSpecial;
                Object command = commandTemplate.replace("{world}", world.getName()).replace("{x}", String.valueOf(deathLocation.getBlockX())).replace("{y}", String.valueOf(deathLocation.getBlockY())).replace("{z}", String.valueOf(deathLocation.getBlockZ())).replace("{denomination}", denomination);
                boolean bl = isSpecial = this.specialMobs.contains(entityType.name().toLowerCase()) || entity.getCustomName() != null && !entity.getCustomName().isEmpty();
                if (isSpecial) {
                    command = (String)command + " " + this.formatMobName(entity);
                }
                if (this.debugMode) {
                    this.getLogger().info("Executing command: " + (String)command);
                }
                Bukkit.dispatchCommand(Bukkit.getConsoleSender(), (String)command);
                if (this.config.getBoolean("notify-players", true)) {
                    this.notifyNearbyPlayers(entity, denomination);
                }
            }
        }
    }

    private String formatMobName(LivingEntity entity) {
        if (entity.getCustomName() != null && !entity.getCustomName().isEmpty()) {
            return entity.getCustomName();
        }
        if (entity.getType() == EntityType.ENDER_DRAGON) {
            return "Ender Dragon";
        }
        if (entity.getType() == EntityType.WITHER) {
            return "Wither Boss";
        }
        return entity.getType().name().toLowerCase().replace("_", " ");
    }

    private String getRandomDenomination(Map<String, Double> denomChances) {
        double totalWeight = denomChances.values().stream().mapToDouble(Double::doubleValue).sum();
        double randomValue = this.random.nextDouble() * totalWeight;
        double currentWeight = 0.0;
        for (Map.Entry<String, Double> entry : denomChances.entrySet()) {
            if (!(randomValue <= (currentWeight += entry.getValue().doubleValue()))) continue;
            return entry.getKey();
        }
        if (!denomChances.isEmpty()) {
            return denomChances.keySet().iterator().next();
        }
        return null;
    }

    private void notifyNearbyPlayers(LivingEntity entity, String denomination) {
        String message = this.config.getString("drop-message", "&a{mob} &7dropped &6{denomination} &7cash!");
        message = message.replace("{mob}", this.formatMobName(entity)).replace("{denomination}", denomination).replace("&", "\u00a7");
        int radius = this.config.getInt("notification-radius", 30);
        Location loc = entity.getLocation();
        for (Player player : entity.getWorld().getPlayers()) {
            if (!(player.getLocation().distance(loc) <= (double)radius)) continue;
            player.sendMessage(message);
        }
    }

    public void reloadMobCashConfig() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.mobDropSettings.clear();
        this.denominationCommands.clear();
        this.loadConfiguration();
    }

    private static class MobDropSettings {
        private final double dropChance;
        private final Map<String, Double> denomChances;

        public MobDropSettings(double dropChance, Map<String, Double> denomChances) {
            this.dropChance = dropChance;
            this.denomChances = denomChances;
        }

        public double getDropChance() {
            return this.dropChance;
        }

        public Map<String, Double> getDenomChances() {
            return this.denomChances;
        }
    }
}

