/*
 * Decompiled with CFR 0.152.
 */
package com.example.mobcash;

import com.example.mobcash.MobCash;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class MobCashCommand
implements CommandExecutor {
    private final MobCash plugin;

    public MobCashCommand(MobCash plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendInfo(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("mobcash.reload")) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to reload the plugin!");
                    return true;
                }
                this.plugin.reloadMobCashConfig();
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "MobCash configuration reloaded!");
                return true;
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Unknown command. Use /mobcash help for available commands.");
        return true;
    }

    private void sendInfo(CommandSender sender) {
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "========== MobCash ==========");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Mobs now drop cash notes that players can right-click to claim!");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Type " + String.valueOf((Object)ChatColor.WHITE) + "/mobcash help" + String.valueOf((Object)ChatColor.YELLOW) + " for commands.");
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "=============================");
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "========== MobCash Help ==========");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/mobcash " + String.valueOf((Object)ChatColor.WHITE) + "- Shows plugin information");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/mobcash help " + String.valueOf((Object)ChatColor.WHITE) + "- Shows this help menu");
        if (sender.hasPermission("mobcash.reload")) {
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/mobcash reload " + String.valueOf((Object)ChatColor.WHITE) + "- Reloads the configuration");
        }
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "================================");
    }
}

