/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod;

import com.f708.anothergunmod.client.ClientEvents;
import com.f708.anothergunmod.compat.ParcoolHandler;
import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.data.ModDataAttachments;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.entity.ModEntities;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.registry.particle.ModParticleTypes;
import com.f708.anothergunmod.sounds.ModSounds;
import com.f708.anothergunmod.tabs.ModCreativeModeTabs;
import com.f708.anothergunmod.utils.CameraUtils;
import com.f708.anothergunmod.utils.ModTags;
import com.mojang.logging.LogUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="anothergunmod")
public class AnotherGunMod {
    public static final String MOD_ID = "anothergunmod";
    public static final Logger LOGGER = LogUtils.getLogger();

    public AnotherGunMod(IEventBus modEventBus, ModContainer modContainer) {
        if (ModList.get().isLoaded("parcool")) {
            NeoForge.EVENT_BUS.addListener(ParcoolHandler::actionHandler);
        }
        modEventBus.addListener(this::commonSetup);
        ModConfig.load();
        if (FMLEnvironment.dist.isClient()) {
            ClientEvents.registerConfigScreen(modContainer);
        }
        ModItems.register(modEventBus);
        ModDataComponents.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModParticleTypes.PARTICLE_TYPES.register(modEventBus);
        ModDataAttachments.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void anvilShit(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        Item item = left.getItem();
        if (item instanceof AbstractGunItem) {
            AbstractGunItem gunItem = (AbstractGunItem)item;
            if (right.is(ModItems.REPAIRKIT.get()) || right.is(ModTags.Items.REPAIR_KIT)) {
                ItemStack out = left.copy();
                if (left.isDamaged()) {
                    out.setDamageValue(0);
                    event.setCost(3L);
                    event.setOutput(out);
                }
            }
        }
    }

    @SubscribeEvent
    public void blockEvent(LivingIncomingDamageEvent event) {
        boolean meleeAttack;
        LivingEntity target = event.getEntity();
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        Entity attacker = event.getSource().getEntity();
        ItemStack weapon = event.getSource().getWeaponItem();
        boolean bl = meleeAttack = attacker instanceof Monster || weapon != null && weapon.getItem() instanceof Item || attacker instanceof NeutralMob;
        if (!meleeAttack) {
            return;
        }
        if (event.getAmount() <= player.getHealth()) {
            return;
        }
        if (!AbstractGunItem.holdingGunWeapon(player) || !player.isShiftKeyDown()) {
            return;
        }
        ItemStack gun = ItemStack.EMPTY;
        InteractionHand hand = null;
        for (InteractionHand h : InteractionHand.values()) {
            ItemStack inHand = player.getItemInHand(h);
            if (!(inHand.getItem() instanceof AbstractGunItem)) continue;
            gun = inHand;
            hand = h;
            break;
        }
        if (gun.isEmpty()) {
            return;
        }
        if (gun.is(ModItems.REVOLVER.get())) {
            return;
        }
        if (gun.is(ModItems.FLAMETHROWER.get())) {
            return;
        }
        gun.set(ModDataComponents.BLOCKED_ATTACK, (Object)true);
        if (player.level().isClientSide) {
            CameraUtils.triggerCameraShake(5, 5.0f, 5, 5.0f);
        }
        player.getCooldowns().addCooldown(gun.getItem(), 20);
        Vec3 lookDir = player.getLookAngle();
        Vec3 knockback = new Vec3(-lookDir.x, 0.3, -lookDir.z);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.setDeltaMovement(sp.getDeltaMovement().add(knockback));
            sp.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)sp));
        }
        event.setCanceled(true);
    }
}

