/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation;

import com.f708.anothergunmod.client.animation.WeaponAnimator;
import com.f708.anothergunmod.utils.EasingFunctions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;

public class AutoGunAnimator
implements WeaponAnimator {
    private final boolean isFirstPerson;
    private static final float SHOOT_PITCH_MAX_DEG = 5.0f;
    private static final float SHOOT_TWIST_MAX_DEG = 2.0f;
    private static final float SHOOT_IMPULSE_TIME = 0.15f;
    private static final float SHOOT_SETTLE_TIME = 0.85f;

    public AutoGunAnimator(boolean isFirstPerson) {
        this.isFirstPerson = isFirstPerson;
    }

    @Override
    public void animateShoot(PoseStack poseStack, float progress, boolean leftHand) {
        int isLeftHand = leftHand ? -1 : 1;
        progress = EasingFunctions.clamp(progress, 0.0f, 1.0f);
        float t = EasingFunctions.clamp(progress / 0.15f, 0.0f, 1.0f);
        float angleX = EasingFunctions.lerp(0.0f, 5.0f, EasingFunctions.easeOutCubic(t));
        float angleZ = EasingFunctions.lerp(0.0f, 2.0f * (float)(-isLeftHand), EasingFunctions.easeOutCubic(t));
        if (progress > 0.15f) {
            float settleT = EasingFunctions.clamp((progress - 0.15f) / 0.85f, 0.0f, 1.0f);
            angleX = EasingFunctions.lerp(angleX, 0.0f, EasingFunctions.easeInOutSine(settleT));
            angleZ = EasingFunctions.lerp(angleZ, 0.0f, EasingFunctions.easeInOutSine(settleT));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(angleX));
        poseStack.mulPose(Axis.ZP.rotationDegrees(angleZ));
    }

    @Override
    public void animateReload(PoseStack poseStack, float progress, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            poseStack.pushPose();
            float angleX = 0.0f;
            float angleY = 0.0f;
            float angleZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            if (progress < 0.4f) {
                t = progress / 0.4f;
                angleZ = EasingFunctions.lerp(0.0f, 15.0f, EasingFunctions.easeOutQuad(t)) * (float)isLeftHand;
                angleX = EasingFunctions.lerp(0.0f, -8.0f, EasingFunctions.easeOutSine(t));
                offsetY = EasingFunctions.lerp(0.0f, -0.05f, EasingFunctions.easeOutQuad(t));
            } else if (progress < 0.65f) {
                t = (progress - 0.4f) / 0.25f;
                angleZ = EasingFunctions.lerp(15.0f, 18.0f, EasingFunctions.easeInOutSine(t)) * (float)isLeftHand;
                angleX = EasingFunctions.lerp(-5.0f, -20.0f, EasingFunctions.easeInOutQuad(t));
                angleY = EasingFunctions.lerp(0.0f, -15.0f, EasingFunctions.easeOutQuad(t)) * (float)isLeftHand;
                offsetX = EasingFunctions.lerp(0.0f, 0.06f, EasingFunctions.easeOutQuad(t)) * (float)isLeftHand;
                offsetY = EasingFunctions.lerp(-0.05f, 0.1f, EasingFunctions.easeInOutQuad(t));
            } else {
                t = (progress - 0.65f) / 0.35f;
                angleZ = EasingFunctions.lerp(18.0f, 0.0f, EasingFunctions.easeOutCubic(t)) * (float)isLeftHand;
                angleX = EasingFunctions.lerp(-20.0f, 0.0f, EasingFunctions.easeOutQuad(t));
                angleY = EasingFunctions.lerp(-15.0f, 0.0f, EasingFunctions.easeOutQuad(t)) * (float)isLeftHand;
                offsetX = EasingFunctions.lerp(0.06f, 0.0f, EasingFunctions.easeOutQuad(t)) * (float)isLeftHand;
                offsetY = EasingFunctions.lerp(0.1f, 0.0f, EasingFunctions.easeOutQuad(t));
            }
            float barrelLift = 0.0f;
            if (progress < 0.8f) {
                float t = progress / 0.8f;
                barrelLift = EasingFunctions.lerp(0.0f, 12.0f, EasingFunctions.easeOutQuad(t));
            } else {
                float t = (progress - 0.8f) / 0.2f;
                barrelLift = EasingFunctions.lerp(12.0f, 0.0f, EasingFunctions.easeInQuad(t));
            }
            poseStack.translate(offsetX, offsetY, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(angleY));
            poseStack.mulPose(Axis.ZN.rotationDegrees(angleZ));
            poseStack.mulPose(Axis.XN.rotationDegrees(angleX + barrelLift));
        } else {
            poseStack.pushPose();
            poseStack.popPose();
            float fastProgress = Math.min(progress * 1.3f, 1.0f);
            float reload = (float)(Math.sin(Math.PI * (double)fastProgress) * 20.0 * (double)isLeftHand);
            poseStack.translate(Math.sin(Math.PI * (double)fastProgress) * -0.1 * (double)isLeftHand, 0.0, 0.0);
            poseStack.mulPose(Axis.ZN.rotationDegrees(reload));
        }
    }

    @Override
    public void animateHit(PoseStack poseStack, float progress, boolean leftHand) {
        float smoothProgress;
        int side;
        if (!this.isFirstPerson) {
            return;
        }
        int n = side = leftHand ? -1 : 1;
        if (progress < 0.3f) {
            t = progress / 0.3f;
            smoothProgress = EasingFunctions.easeOutCubic(t);
        } else {
            t = (progress - 0.3f) / 0.7f;
            smoothProgress = 1.0f - EasingFunctions.easeInQuad(t);
        }
        float rotationY = 120.0f * smoothProgress * (float)side;
        float rotationZ = 30.0f * smoothProgress;
        float offsetX = -0.2f * smoothProgress * (float)side;
        float offsetZ = -0.5f * smoothProgress;
        poseStack.translate(offsetX, 0.0f, offsetZ);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationY));
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotationZ));
    }

    @Override
    public void applyDefaultPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.translate(0.0f, -0.1f, -0.2f);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(5.0f * (float)isLeftHand));
        } else {
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(135.0f));
            poseStack.translate(0.0f, -0.25f, -0.3f);
        }
    }

    @Override
    public void applyRunningPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.translate(0.1f * (float)isLeftHand, 0.05f, -0.2f);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
        } else {
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(135.0f));
            poseStack.translate(0.0f, -0.25f, -0.3f);
        }
    }

    @Override
    public void applyBlockPose(PoseStack poseStack, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            poseStack.scale(2.0f, 2.0f, 1.0f);
            poseStack.translate(-0.4 * (double)isLeftHand, 0.0, 0.0);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(65.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(35.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(35.0f));
        } else {
            poseStack.scale(2.0f, 2.0f, 1.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XP.rotationDegrees(25.0f));
            poseStack.translate(0.0, (double)-0.35f, (double)-0.3f);
        }
    }

    @Override
    public void applySupportedPose(PoseStack poseStack, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            poseStack.scale(1.4f, 2.0f, 2.0f);
            poseStack.translate(-0.2 * (double)isLeftHand, (double)-0.05f, (double)-0.15f);
            poseStack.pushPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(-15.0f));
        } else {
            poseStack.scale(1.2f, 2.0f, 2.0f);
            poseStack.translate(0.0 * (double)isLeftHand, -0.0, -0.25);
            poseStack.mulPose(Axis.XP.rotationDegrees(35.0f));
        }
    }

    @Override
    public void animateShoot(PoseStack poseStack, float progress, boolean leftHand, boolean tripod) {
        WeaponAnimator.super.animateShoot(poseStack, progress, leftHand, tripod);
    }
}

