/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation;

import com.f708.anothergunmod.client.animation.WeaponAnimator;
import com.f708.anothergunmod.utils.EasingFunctions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;

public class ShotgunAnimation
implements WeaponAnimator {
    private final boolean isFirstPerson;

    public ShotgunAnimation(boolean isFirstPerson) {
        this.isFirstPerson = isFirstPerson;
    }

    @Override
    public void animateShoot(PoseStack poseStack, float progress, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            float angleX = 0.0f;
            float offsetY = 0.0f;
            if (progress < 0.1f) {
                float t = progress / 0.1f;
                angleX = EasingFunctions.lerp(0.0f, -55.0f, EasingFunctions.easeOutCubic(t));
            } else if (progress < 0.55f) {
                float t = (progress - 0.1f) / 0.45f;
                angleX = EasingFunctions.lerp(-55.0f, -40.0f, EasingFunctions.easeInOutSine(t));
            } else if (progress < 0.7f) {
                float t = (progress - 0.55f) / 0.15f;
                float eased = EasingFunctions.easeOutCubic(t);
                angleX = -40.0f;
                offsetY = EasingFunctions.lerp(0.0f, -0.15f, eased);
            } else if (progress < 0.85f) {
                float t = (progress - 0.7f) / 0.15f;
                float eased = EasingFunctions.easeInCubic(t);
                angleX = -40.0f;
                offsetY = EasingFunctions.lerp(-0.15f, 0.0f, eased);
            } else {
                float t = (progress - 0.85f) / 0.15f;
                angleX = EasingFunctions.lerp(-40.0f, 0.0f, EasingFunctions.easeInOutSine(t));
                offsetY = 0.0f;
            }
            poseStack.translate(0.0f, offsetY, 0.0f);
            poseStack.mulPose(Axis.XN.rotationDegrees(angleX));
        } else {
            float fastProgress = Math.min(progress * 3.0f, 1.0f);
            float recoil = (float)(Math.sin(Math.PI * (double)fastProgress) * 10.0);
            poseStack.mulPose(Axis.XP.rotationDegrees(recoil));
        }
    }

    @Override
    public void animateReload(PoseStack poseStack, float progress, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            float angleX = 0.0f;
            float angleZ = 0.0f;
            float moveY = 0.0f;
            float moveX = 0.0f;
            if (progress < 0.2f) {
                float t = progress / 0.2f;
                angleX = EasingFunctions.lerp(0.0f, -15.0f, EasingFunctions.easeOutCubic(t));
                moveY = EasingFunctions.lerp(0.0f, -0.04f, EasingFunctions.easeOutCubic(t));
            } else if (progress < 0.5f) {
                float t = (progress - 0.2f) / 0.3f;
                moveX = EasingFunctions.lerp(0.0f, 0.1f * (float)isLeftHand, EasingFunctions.easeOutBack(t));
                angleZ = EasingFunctions.lerp(0.0f, 35.0f * (float)isLeftHand, EasingFunctions.easeOutBack(t));
                angleX = -15.0f;
                moveY = -0.06f;
            } else if (progress < 0.7f) {
                float t = (progress - 0.5f) / 0.2f;
                moveX = EasingFunctions.lerp(0.1f * (float)isLeftHand, -0.03f * (float)isLeftHand, EasingFunctions.easeInOutSine(t));
                angleZ = EasingFunctions.lerp(25.0f * (float)isLeftHand, -10.0f * (float)isLeftHand, EasingFunctions.easeInOutSine(t));
                angleX = -15.0f;
                moveY = -0.04f;
            } else {
                float t = (progress - 0.7f) / 0.3f;
                moveX = EasingFunctions.lerp(-0.03f * (float)isLeftHand, 0.0f, EasingFunctions.easeInOutSine(t));
                angleZ = EasingFunctions.lerp(-10.0f * (float)isLeftHand, 0.0f, EasingFunctions.easeInOutSine(t));
                angleX = EasingFunctions.lerp(-15.0f, 0.0f, EasingFunctions.easeInOutSine(t));
                moveY = EasingFunctions.lerp(-0.04f, 0.0f, EasingFunctions.easeInOutSine(t));
            }
            poseStack.translate(moveX, moveY, 0.0f);
            poseStack.mulPose(Axis.ZN.rotationDegrees(angleZ));
            poseStack.mulPose(Axis.XP.rotationDegrees(angleX));
        } else {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.pushPose();
            poseStack.popPose();
            float fastProgress = Math.min(progress * 1.3f, 1.0f);
            float reload = (float)(Math.sin(Math.PI * (double)fastProgress) * 20.0 * (double)isLeftHand);
            poseStack.translate(Math.sin(Math.PI * (double)fastProgress) * -0.1 * (double)isLeftHand, 0.0, 0.0);
            poseStack.mulPose(Axis.ZN.rotationDegrees(reload));
        }
    }

    @Override
    public void animateHit(PoseStack poseStack, float progress, boolean leftHand) {
        float smoothProgress;
        int side;
        if (!this.isFirstPerson) {
            return;
        }
        int n = side = leftHand ? -1 : 1;
        if (progress < 0.3f) {
            t = progress / 0.3f;
            smoothProgress = EasingFunctions.easeOutCubic(t);
        } else {
            t = (progress - 0.3f) / 0.7f;
            smoothProgress = 1.0f - EasingFunctions.easeInQuad(t);
        }
        float rotationY = 120.0f * smoothProgress * (float)side;
        float rotationZ = 30.0f * smoothProgress;
        float offsetX = -0.2f * smoothProgress * (float)side;
        float offsetZ = -0.5f * smoothProgress;
        poseStack.translate(offsetX, 0.0f, offsetZ);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationY));
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotationZ));
    }

    @Override
    public void applySupportedPose(PoseStack poseStack, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            poseStack.scale(1.4f, 2.0f, 2.0f);
            poseStack.translate(-0.2 * (double)isLeftHand, (double)-0.05f, 0.0);
            poseStack.pushPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(-15.0f));
        } else {
            poseStack.scale(1.2f, 2.0f, 2.0f);
            poseStack.translate(0.0 * (double)isLeftHand, (double)-0.1f, (double)-0.15f);
            poseStack.mulPose(Axis.XP.rotationDegrees(35.0f));
        }
    }

    @Override
    public void applyDefaultPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.scale(1.2f, 2.0f, 2.0f);
            poseStack.translate(0.0, -0.1, -0.1);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(5.0f * (float)isLeftHand));
        } else {
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(135.0f));
            poseStack.translate(0.0, -0.25, -0.3);
        }
    }

    @Override
    public void applyRunningPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.scale(1.3f, 2.0f, 2.0f);
            poseStack.translate(0.0, -0.1, -0.1);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.translate(leftHand ? -0.1 : 0.1, 0.1, -0.1);
            poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
        } else {
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(135.0f));
            poseStack.translate(0.0, -0.25, -0.3);
        }
    }

    @Override
    public void applyBlockPose(PoseStack poseStack, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            poseStack.scale(2.0f, 2.0f, 1.0f);
            poseStack.translate(-0.32 * (double)isLeftHand, 0.0, 0.0);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(65.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(35.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(35.0f));
        } else {
            poseStack.scale(2.0f, 2.0f, 1.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XP.rotationDegrees(25.0f));
            poseStack.translate(0.0, (double)-0.35f, (double)-0.3f);
        }
    }
}

