/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation;

import com.f708.anothergunmod.client.animation.AutoGunAnimator;
import com.f708.anothergunmod.client.animation.DefaultWeaponAnimator;
import com.f708.anothergunmod.client.animation.FlameThrowerAnimator;
import com.f708.anothergunmod.client.animation.MachineGunAnimator;
import com.f708.anothergunmod.client.animation.RevolverAnimator;
import com.f708.anothergunmod.client.animation.RifleAnimator;
import com.f708.anothergunmod.client.animation.RifleSpyglassAnimator;
import com.f708.anothergunmod.client.animation.ShotgunAnimation;
import com.f708.anothergunmod.client.animation.WeaponAnimator;
import com.f708.anothergunmod.core.enums.WeaponType;
import java.util.HashMap;
import java.util.Map;

public class WeaponAnimatorFactory {
    private static final Map<String, WeaponAnimator> FIRST_PERSON_ANIMATORS = new HashMap<String, WeaponAnimator>();
    private static final Map<String, WeaponAnimator> THIRD_PERSON_ANIMATORS = new HashMap<String, WeaponAnimator>();

    public static WeaponAnimator getAnimator(WeaponType type, boolean firstPerson) {
        Map<String, WeaponAnimator> animators = firstPerson ? FIRST_PERSON_ANIMATORS : THIRD_PERSON_ANIMATORS;
        return animators.getOrDefault(type.name(), new DefaultWeaponAnimator(firstPerson));
    }

    static {
        FIRST_PERSON_ANIMATORS.put("REVOLVER", new RevolverAnimator(true));
        FIRST_PERSON_ANIMATORS.put("RIFLE", new RifleAnimator(true));
        FIRST_PERSON_ANIMATORS.put("RIFLE_SPYGLASS", new RifleSpyglassAnimator(true));
        FIRST_PERSON_ANIMATORS.put("SHOTGUN", new ShotgunAnimation(true));
        FIRST_PERSON_ANIMATORS.put("AUTOGUN", new AutoGunAnimator(true));
        FIRST_PERSON_ANIMATORS.put("MACHINEGUN", new MachineGunAnimator(true));
        FIRST_PERSON_ANIMATORS.put("FLAMETHROWER", new FlameThrowerAnimator(true));
        THIRD_PERSON_ANIMATORS.put("REVOLVER", new RevolverAnimator(false));
        THIRD_PERSON_ANIMATORS.put("RIFLE", new RifleAnimator(false));
        THIRD_PERSON_ANIMATORS.put("RIFLE_SPYGLASS", new RifleSpyglassAnimator(false));
        THIRD_PERSON_ANIMATORS.put("SHOTGUN", new ShotgunAnimation(false));
        THIRD_PERSON_ANIMATORS.put("AUTOGUN", new AutoGunAnimator(false));
        THIRD_PERSON_ANIMATORS.put("MACHINEGUN", new MachineGunAnimator(false));
        THIRD_PERSON_ANIMATORS.put("FLAMETHROWER", new FlameThrowerAnimator(false));
    }
}

