/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation;

import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;

public class WeaponRenderContext {
    private final Player player;
    private final AbstractGunItem gunItem;
    private final ItemDisplayContext displayContext;
    private final boolean leftHand;
    private final boolean isFirstPerson;
    private final boolean isThirdPerson;
    private final InteractionHand hand;

    public WeaponRenderContext(Player player, AbstractGunItem gunItem, ItemDisplayContext displayContext, boolean leftHand) {
        this.player = player;
        this.gunItem = gunItem;
        this.displayContext = displayContext;
        this.leftHand = leftHand;
        this.isFirstPerson = displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        this.isThirdPerson = displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        this.hand = leftHand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public boolean shouldAnimate() {
        return this.isFirstPerson || this.isThirdPerson;
    }

    public Player getPlayer() {
        return this.player;
    }

    public AbstractGunItem getGunItem() {
        return this.gunItem;
    }

    public boolean isLeftHand() {
        return this.leftHand;
    }

    public boolean isFirstPerson() {
        return this.isFirstPerson;
    }

    public boolean isThirdPerson() {
        return this.isThirdPerson;
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

