/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation.body;

import com.f708.anothergunmod.client.animation.body.BodyAnimationContext;
import com.f708.anothergunmod.client.animation.body.BodyAnimator;
import com.f708.anothergunmod.client.animation.body.BodyAnimatorFactory;
import com.f708.anothergunmod.core.WeaponAnimationManager;
import com.f708.anothergunmod.core.interfaces.IMeleeGun;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BodyAnimationHandler {
    public static void handle(BodyAnimationContext context) {
        if (!context.hasAnyWeapon()) {
            return;
        }
        BodyAnimationHandler.animateHand(context, InteractionHand.MAIN_HAND);
        BodyAnimationHandler.animateHand(context, InteractionHand.OFF_HAND);
    }

    private static void animateHand(BodyAnimationContext context, InteractionHand hand) {
        if (!context.hasWeapon(hand)) {
            return;
        }
        AbstractGunItem gun = context.getGun(hand);
        BodyAnimator animator = BodyAnimatorFactory.getAnimator(gun.weaponType());
        BodyAnimator.BodyParts parts = new BodyAnimator.BodyParts(context.getModel(), hand == InteractionHand.MAIN_HAND);
        BodyAnimationHandler.applyPose(context, hand, animator, parts);
        BodyAnimationHandler.applyAnimation(context, hand, animator, parts);
    }

    private static void applyPose(BodyAnimationContext context, InteractionHand hand, BodyAnimator animator, BodyAnimator.BodyParts parts) {
        Player player = context.getPlayer();
        ItemStack item = context.getItem(hand);
        if (context.getItem(InteractionHand.MAIN_HAND).is(ModItems.REVOLVER.get()) && context.getItem(InteractionHand.OFF_HAND).is(ModItems.REVOLVER.get())) {
            animator.applyHoldingPose(parts);
            return;
        }
        if (AbstractGunItem.holdingInnaporatedItem(player)) {
            return;
        }
        boolean isRunning = player.isSprinting() && !player.isShiftKeyDown() || player.isSwimming() && player.isSprinting();
        boolean isBlocking = (Boolean)item.getOrDefault(ModDataComponents.BLOCKED_ATTACK, (Object)false);
        boolean isSupported = (Boolean)item.getOrDefault(ModDataComponents.IS_SUPPORTED, (Object)false);
        boolean isRifleSpyglass = item.is(ModItems.RIFLEWITHSPYGLASS.get());
        if (isBlocking) {
            animator.applyBlockingPose(parts);
        } else if (isSupported && context.getItem(hand).getItem() instanceof IMeleeGun || isRifleSpyglass && player.isShiftKeyDown()) {
            animator.applySupportedPose(parts);
        } else {
            animator.applyHoldingPose(parts);
        }
    }

    private static void applyAnimation(BodyAnimationContext context, InteractionHand hand, BodyAnimator animator, BodyAnimator.BodyParts parts) {
        WeaponAnimationManager.WeaponAnimationData animData = WeaponAnimationManager.getAnimation(context.getPlayer(), hand);
        if (animData == null) {
            return;
        }
        AbstractGunItem gun = context.getGun(hand);
        if (animData.weaponType != gun.weaponType()) {
            return;
        }
        float progress = animData.getProgress();
        switch (animData.animationType) {
            case SHOOT: {
                animator.animateShoot(parts, progress);
                break;
            }
            case RELOAD: {
                animator.animateReload(parts, progress);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected animation type: " + String.valueOf((Object)animData.animationType));
            }
        }
    }
}

