/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.config;

import com.f708.anothergunmod.AnotherGunMod;
import com.f708.anothergunmod.config.ConfigSyncPacket;
import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.registry.item.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    private final Screen parent;
    private ModConfig.ConfigData tempData;
    private final Map<EditBox, Integer> originalValues = new HashMap<EditBox, Integer>();
    private final List<WeaponRow> weaponRows = new ArrayList<WeaponRow>();
    private EditBox magazineReload;
    private EditBox soundRange;
    private Button attractMobsToggle;
    private final List<FallingBullet> bullets = new ArrayList<FallingBullet>();
    private int tableX;
    private int tableY;
    private int tableWidth;
    private int tableHeight;
    private int overlayX;
    private int overlayY;
    private int overlayWidth;
    private int overlayHeight;

    public ConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"Gun Mod Config"));
        this.parent = parent;
        this.tempData = this.cloneConfig(ModConfig.getData());
    }

    private ModConfig.ConfigData cloneConfig(ModConfig.ConfigData original) {
        ModConfig.ConfigData clone = new ModConfig.ConfigData();
        clone.revolver = this.cloneWeapon(original.revolver);
        clone.rifle = this.cloneWeapon(original.rifle);
        clone.rifleSpyglass = this.cloneWeapon(original.rifleSpyglass);
        clone.shotgun = this.cloneWeapon(original.shotgun);
        clone.autogun = this.cloneWeapon(original.autogun);
        clone.machinegun = this.cloneWeapon(original.machinegun);
        clone.misc.gunsAttractMobs = original.misc.gunsAttractMobs;
        clone.misc.magazineReloadTime = original.misc.magazineReloadTime;
        clone.misc.distantSoundRange = original.misc.distantSoundRange;
        return clone;
    }

    private ModConfig.WeaponStats cloneWeapon(ModConfig.WeaponStats original) {
        return new ModConfig.WeaponStats(original.damage, original.reloadTime, original.recoil, original.fireRate, original.pelletCount);
    }

    protected void init() {
        if (this.minecraft != null && this.minecraft.player != null && !this.minecraft.player.hasPermissions(2)) {
            this.minecraft.player.displayClientMessage((Component)Component.literal((String)"You don't have permission"), false);
            this.minecraft.setScreen(this.parent);
            return;
        }
        this.clearWidgets();
        this.weaponRows.clear();
        this.originalValues.clear();
        this.bullets.clear();
        this.initBullets();
        int centerX = this.width / 2;
        int iconWidth = 16;
        int iconPadding = 5;
        int fieldWidth = 40;
        int fieldHeight = 18;
        int fieldGap = 10;
        int rowGap = 3;
        this.tableWidth = iconWidth + iconPadding + 5 * (fieldWidth + fieldGap) - fieldGap;
        this.tableX = centerX - this.tableWidth / 2;
        this.tableY = 60;
        int y = this.tableY + 20;
        this.addWeaponRow(y, new ItemStack((ItemLike)ModItems.REVOLVER.get()), "Revolver", this.tempData.revolver, true, true, true, true, false);
        this.addWeaponRow(y += fieldHeight + rowGap, new ItemStack((ItemLike)ModItems.RIFLE.get()), "Rifle", this.tempData.rifle, true, true, true, true, false);
        this.addWeaponRow(y += fieldHeight + rowGap, new ItemStack((ItemLike)ModItems.RIFLEWITHSPYGLASS.get()), "Rifle Spyglass", this.tempData.rifleSpyglass, true, true, true, true, false);
        this.addWeaponRow(y += fieldHeight + rowGap, new ItemStack((ItemLike)ModItems.SHOTGUN.get()), "Shotgun", this.tempData.shotgun, true, true, true, true, true);
        this.addWeaponRow(y += fieldHeight + rowGap, new ItemStack((ItemLike)ModItems.AUTOGUN.get()), "Autogun", this.tempData.autogun, true, true, true, true, false);
        this.addWeaponRow(y += fieldHeight + rowGap, new ItemStack((ItemLike)ModItems.MACHINEGUN.get()), "Machinegun", this.tempData.machinegun, true, true, true, true, false);
        y += fieldHeight + rowGap;
        this.magazineReload = this.createField(centerX - 120, y += 20, "Mag Reload", this.tempData.misc.magazineReloadTime);
        this.soundRange = this.createField(centerX - 20, y, "Sound Range", this.tempData.misc.distantSoundRange);
        this.attractMobsToggle = Button.builder((Component)Component.literal((String)(this.tempData.misc.gunsAttractMobs ? "ON" : "OFF")), btn -> {
            this.tempData.misc.gunsAttractMobs = !this.tempData.misc.gunsAttractMobs;
            btn.setMessage((Component)Component.literal((String)(this.tempData.misc.gunsAttractMobs ? "ON" : "OFF")));
        }).bounds(centerX + 60, y - 2, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.attractMobsToggle);
        this.tableHeight = (y += 30) - this.tableY;
        this.overlayX = this.tableX - 10;
        this.overlayY = this.tableY - 10;
        this.overlayWidth = this.tableWidth + 20;
        this.overlayHeight = this.tableHeight + 40;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save"), btn -> this.save()).bounds(centerX - 160, y, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), btn -> this.minecraft.setScreen(this.parent)).bounds(centerX - 50, y, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reset"), btn -> this.reset()).bounds(centerX + 60, y, 100, 20).build());
    }

    private void addWeaponRow(int y, ItemStack icon, String name, Object stats, boolean hasDamage, boolean hasReload, boolean hasRecoil, boolean hasFireRate, boolean hasPellets) {
        WeaponRow row = new WeaponRow();
        row.icon = icon;
        row.name = name;
        int iconWidth = 16;
        int iconPadding = 5;
        int fieldWidth = 40;
        int fieldGap = 10;
        int colDamage = this.tableX + iconWidth + iconPadding;
        int colReload = colDamage + fieldWidth + fieldGap;
        int colRecoil = colReload + fieldWidth + fieldGap;
        int colFireRate = colRecoil + fieldWidth + fieldGap;
        int colPellets = colFireRate + fieldWidth + fieldGap;
        if (stats instanceof ModConfig.WeaponStats) {
            ModConfig.WeaponStats ws = (ModConfig.WeaponStats)stats;
            if (hasDamage) {
                row.damage = this.createField(colDamage, y, "DMG", ws.damage);
            }
            if (hasReload) {
                row.reload = this.createField(colReload, y, "RLD", ws.reloadTime);
            }
            if (hasRecoil) {
                row.recoil = this.createField(colRecoil, y, "REC", ws.recoil);
            }
            if (hasFireRate) {
                row.fireRate = this.createField(colFireRate, y, "FR", ws.fireRate);
            }
            if (hasPellets) {
                row.pellets = this.createField(colPellets, y, "PEL", ws.pelletCount);
            }
        } else if (stats instanceof ModConfig.FlamethrowerStats) {
            ModConfig.FlamethrowerStats fs = (ModConfig.FlamethrowerStats)stats;
            if (hasDamage) {
                row.damage = this.createField(colDamage, y, "DMG", fs.damage);
            }
            if (hasReload) {
                row.reload = this.createField(colReload, y, "RLD", fs.reloadTime);
            }
        }
        this.weaponRows.add(row);
    }

    private EditBox createField(int x, int y, String label, int value) {
        EditBox field = new EditBox(this.font, x, y, 40, 18, (Component)Component.literal((String)label));
        field.setValue(String.valueOf(value));
        field.setFilter(s -> s.matches("\\d*"));
        field.setMaxLength(4);
        field.setTextColor(0xFFFFFF);
        this.addRenderableWidget((GuiEventListener)field);
        this.originalValues.put(field, value);
        return field;
    }

    private void initBullets() {
        ItemStack[] bulletTypes = new ItemStack[]{new ItemStack((ItemLike)ModItems.SMALLBULLET.get()), new ItemStack((ItemLike)ModItems.BIGBULLET.get()), new ItemStack((ItemLike)ModItems.SHELL.get())};
        int[] layerCounts = new int[]{25, 15, 10};
        int bulletIndex = 0;
        for (int layer = 0; layer < 3; ++layer) {
            for (int i = 0; i < layerCounts[layer]; ++i) {
                FallingBullet bullet = new FallingBullet();
                bullet.stack = bulletTypes[bulletIndex % 3];
                bullet.x = (float)(Math.random() * (double)this.width);
                bullet.y = (float)(Math.random() * (double)this.height);
                bullet.layer = layer;
                bullet.rotation = (float)(Math.random() * 360.0);
                bullet.rotationSpeed = (float)(0.25 + Math.random() * 0.25) * (float)(Math.random() < 0.5 ? 1 : -1);
                switch (layer) {
                    case 0: {
                        bullet.size = 100;
                        bullet.speed = 0.04f;
                        bullet.brightness = 0.3f;
                        break;
                    }
                    case 1: {
                        bullet.size = 200;
                        bullet.speed = 0.06f;
                        bullet.brightness = 0.4f;
                        break;
                    }
                    case 2: {
                        bullet.size = 300;
                        bullet.speed = 0.08f;
                        bullet.brightness = 0.5f;
                    }
                }
                this.bullets.add(bullet);
                ++bulletIndex;
            }
        }
    }

    private void updateBullets(float partialTick) {
        for (FallingBullet bullet : this.bullets) {
            bullet.y += bullet.speed;
            bullet.rotation += bullet.rotationSpeed;
            if (!(bullet.y > (float)(this.height + 50))) continue;
            bullet.y = -50.0f;
            bullet.x = (float)(Math.random() * (double)this.width);
        }
    }

    private void renderBullets(GuiGraphics graphics) {
        PoseStack poseStack = graphics.pose();
        for (int layer = 0; layer < 3; ++layer) {
            for (FallingBullet bullet : this.bullets) {
                if (bullet.layer != layer) continue;
                poseStack.pushPose();
                poseStack.translate(bullet.x, bullet.y, (float)(100 + layer * 50));
                float scale = (float)bullet.size / 16.0f;
                poseStack.scale(scale, scale, scale);
                poseStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(bullet.rotation)));
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                int lightColor = LightTexture.pack((int)((int)(15.0f * bullet.brightness)), (int)((int)(15.0f * bullet.brightness)));
                this.minecraft.getItemRenderer().renderStatic(bullet.stack, ItemDisplayContext.FIXED, lightColor, OverlayTexture.NO_OVERLAY, poseStack, (MultiBufferSource)graphics.bufferSource(), (Level)this.minecraft.level, 0);
                poseStack.popPose();
            }
        }
    }

    private void save() {
        try {
            for (WeaponRow row : this.weaponRows) {
                switch (row.name) {
                    case "Revolver": {
                        if (row.damage != null) {
                            this.tempData.revolver.damage = this.parseField(row.damage);
                        }
                        if (row.reload != null) {
                            this.tempData.revolver.reloadTime = this.parseField(row.reload);
                        }
                        if (row.recoil != null) {
                            this.tempData.revolver.recoil = this.parseField(row.recoil);
                        }
                        if (row.fireRate == null) break;
                        this.tempData.revolver.fireRate = this.parseField(row.fireRate);
                        break;
                    }
                    case "Rifle": {
                        if (row.damage != null) {
                            this.tempData.rifle.damage = this.parseField(row.damage);
                        }
                        if (row.reload != null) {
                            this.tempData.rifle.reloadTime = this.parseField(row.reload);
                        }
                        if (row.recoil != null) {
                            this.tempData.rifle.recoil = this.parseField(row.recoil);
                        }
                        if (row.fireRate == null) break;
                        this.tempData.rifle.fireRate = this.parseField(row.fireRate);
                        break;
                    }
                    case "Rifle Spyglass": {
                        if (row.damage != null) {
                            this.tempData.rifleSpyglass.damage = this.parseField(row.damage);
                        }
                        if (row.reload != null) {
                            this.tempData.rifleSpyglass.reloadTime = this.parseField(row.reload);
                        }
                        if (row.recoil != null) {
                            this.tempData.rifleSpyglass.recoil = this.parseField(row.recoil);
                        }
                        if (row.fireRate == null) break;
                        this.tempData.rifleSpyglass.fireRate = this.parseField(row.fireRate);
                        break;
                    }
                    case "Shotgun": {
                        if (row.damage != null) {
                            this.tempData.shotgun.damage = this.parseField(row.damage);
                        }
                        if (row.reload != null) {
                            this.tempData.shotgun.reloadTime = this.parseField(row.reload);
                        }
                        if (row.recoil != null) {
                            this.tempData.shotgun.recoil = this.parseField(row.recoil);
                        }
                        if (row.fireRate != null) {
                            this.tempData.shotgun.fireRate = this.parseField(row.fireRate);
                        }
                        if (row.pellets == null) break;
                        this.tempData.shotgun.pelletCount = this.parseField(row.pellets);
                        break;
                    }
                    case "Autogun": {
                        if (row.damage != null) {
                            this.tempData.autogun.damage = this.parseField(row.damage);
                        }
                        if (row.reload != null) {
                            this.tempData.autogun.reloadTime = this.parseField(row.reload);
                        }
                        if (row.recoil != null) {
                            this.tempData.autogun.recoil = this.parseField(row.recoil);
                        }
                        if (row.fireRate == null) break;
                        this.tempData.autogun.fireRate = this.parseField(row.fireRate);
                        break;
                    }
                    case "Machinegun": {
                        if (row.damage != null) {
                            this.tempData.machinegun.damage = this.parseField(row.damage);
                        }
                        if (row.reload != null) {
                            this.tempData.machinegun.reloadTime = this.parseField(row.reload);
                        }
                        if (row.recoil != null) {
                            this.tempData.machinegun.recoil = this.parseField(row.recoil);
                        }
                        if (row.fireRate == null) break;
                        this.tempData.machinegun.fireRate = this.parseField(row.fireRate);
                    }
                }
            }
            this.tempData.misc.magazineReloadTime = this.parseField(this.magazineReload);
            this.tempData.misc.distantSoundRange = this.parseField(this.soundRange);
            ModConfig.setData(this.tempData);
            if (this.minecraft.getConnection() != null) {
                this.minecraft.getConnection().send((CustomPacketPayload)new ConfigSyncPacket(this.tempData));
            }
            AnotherGunMod.LOGGER.info("Config saved successfully");
            this.minecraft.setScreen(this.parent);
        }
        catch (NumberFormatException e) {
            AnotherGunMod.LOGGER.error("Failed to parse config values", (Throwable)e);
        }
    }

    private int parseField(EditBox field) throws NumberFormatException {
        String value = field.getValue();
        if (value.isEmpty()) {
            return 0;
        }
        int parsed = Integer.parseInt(value);
        return Mth.clamp((int)parsed, (int)0, (int)1000);
    }

    private void reset() {
        ModConfig.setData(new ModConfig.ConfigData());
        this.tempData = this.cloneConfig(ModConfig.getData());
        this.init();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ConfigScreen.renderMenuBackgroundTexture((GuiGraphics)graphics, (ResourceLocation)Screen.MENU_BACKGROUND, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height);
        graphics.fill(this.overlayX, this.overlayY, this.overlayX + this.overlayWidth, this.overlayY + this.overlayHeight, Integer.MIN_VALUE);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        int iconWidth = 16;
        int iconPadding = 5;
        int fieldWidth = 40;
        int fieldGap = 10;
        int colDamage = this.tableX + iconWidth + iconPadding;
        int colReload = colDamage + fieldWidth + fieldGap;
        int colRecoil = colReload + fieldWidth + fieldGap;
        int colFireRate = colRecoil + fieldWidth + fieldGap;
        int colPellets = colFireRate + fieldWidth + fieldGap;
        int headerY = this.tableY;
        graphics.drawString(this.font, "Damage", colDamage + fieldWidth / 2 - this.font.width("Damage") / 2, headerY, 0xFFFFFF, false);
        graphics.drawString(this.font, "Reload", colReload + fieldWidth / 2 - this.font.width("Reload") / 2, headerY, 0xFFFFFF, false);
        graphics.drawString(this.font, "Recoil", colRecoil + fieldWidth / 2 - this.font.width("Recoil") / 2, headerY, 0xFFFFFF, false);
        graphics.drawString(this.font, "FireRate", colFireRate + fieldWidth / 2 - this.font.width("FireRate") / 2, headerY, 0xFFFFFF, false);
        graphics.drawString(this.font, "Pellets", colPellets + fieldWidth / 2 - this.font.width("Pellets") / 2, headerY, 0xFFFFFF, false);
        int y = headerY + 20;
        int rowGap = 3;
        int fieldHeight = 18;
        for (WeaponRow row : this.weaponRows) {
            graphics.renderItem(row.icon, this.tableX, y + 1);
            y += fieldHeight + rowGap;
        }
        for (EditBox field : this.originalValues.keySet()) {
            try {
                int current = Integer.parseInt(field.getValue().isEmpty() ? "0" : field.getValue());
                int original = this.originalValues.get(field);
                if (current != original) {
                    field.setTextColor(0xFFFF00);
                    continue;
                }
                field.setTextColor(0xFFFFFF);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int miscY = this.tableY + this.tableHeight - 43;
        int centerX = this.width / 2;
        graphics.drawString(this.font, "Mag Reload:", centerX - 120 + 20 - this.font.width("Mag Reload:") / 2, miscY - 5, 0xFFFFFF, false);
        graphics.drawString(this.font, "Sound Range:", centerX - 20 + 20 - this.font.width("Sound Range:") / 2, miscY - 5, 0xFFFFFF, false);
        graphics.drawString(this.font, "Attract Mobs:", centerX + 60 + 30 - this.font.width("Attract Mobs:") / 2, miscY - 5, 0xFFFFFF, false);
        this.updateBullets(partialTick);
        this.renderBullets(graphics);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static class WeaponRow {
        ItemStack icon;
        String name;
        EditBox damage;
        EditBox reload;
        EditBox recoil;
        EditBox fireRate;
        EditBox pellets;

        private WeaponRow() {
        }
    }

    private static class FallingBullet {
        ItemStack stack;
        float x;
        float y;
        int layer;
        float rotation;
        float rotationSpeed;
        int size;
        float speed;
        float brightness;

        private FallingBullet() {
        }
    }
}

