/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.config;

import com.f708.anothergunmod.AnotherGunMod;
import com.f708.anothergunmod.config.ModConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ConfigSyncPacket(ModConfig.ConfigData data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ConfigSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"config_sync"));
    public static final StreamCodec<ByteBuf, ConfigSyncPacket> STREAM_CODEC = new StreamCodec<ByteBuf, ConfigSyncPacket>(){

        public ConfigSyncPacket decode(ByteBuf buf) {
            ModConfig.ConfigData data = new ModConfig.ConfigData();
            data.revolver.damage = buf.readInt();
            data.revolver.reloadTime = buf.readInt();
            data.revolver.recoil = buf.readInt();
            data.revolver.fireRate = buf.readInt();
            data.rifle.damage = buf.readInt();
            data.rifle.reloadTime = buf.readInt();
            data.rifle.recoil = buf.readInt();
            data.rifle.fireRate = buf.readInt();
            data.rifleSpyglass.damage = buf.readInt();
            data.rifleSpyglass.reloadTime = buf.readInt();
            data.rifleSpyglass.recoil = buf.readInt();
            data.rifleSpyglass.fireRate = buf.readInt();
            data.shotgun.damage = buf.readInt();
            data.shotgun.reloadTime = buf.readInt();
            data.shotgun.recoil = buf.readInt();
            data.shotgun.fireRate = buf.readInt();
            data.shotgun.pelletCount = buf.readInt();
            data.autogun.damage = buf.readInt();
            data.autogun.reloadTime = buf.readInt();
            data.autogun.recoil = buf.readInt();
            data.autogun.fireRate = buf.readInt();
            data.machinegun.damage = buf.readInt();
            data.machinegun.reloadTime = buf.readInt();
            data.machinegun.recoil = buf.readInt();
            data.machinegun.fireRate = buf.readInt();
            data.misc.gunsAttractMobs = buf.readBoolean();
            data.misc.magazineReloadTime = buf.readInt();
            data.misc.distantSoundRange = buf.readInt();
            return new ConfigSyncPacket(data);
        }

        public void encode(ByteBuf buf, ConfigSyncPacket packet) {
            ModConfig.ConfigData data = packet.data;
            buf.writeInt(data.revolver.damage);
            buf.writeInt(data.revolver.reloadTime);
            buf.writeInt(data.revolver.recoil);
            buf.writeInt(data.revolver.fireRate);
            buf.writeInt(data.rifle.damage);
            buf.writeInt(data.rifle.reloadTime);
            buf.writeInt(data.rifle.recoil);
            buf.writeInt(data.rifle.fireRate);
            buf.writeInt(data.rifleSpyglass.damage);
            buf.writeInt(data.rifleSpyglass.reloadTime);
            buf.writeInt(data.rifleSpyglass.recoil);
            buf.writeInt(data.rifleSpyglass.fireRate);
            buf.writeInt(data.shotgun.damage);
            buf.writeInt(data.shotgun.reloadTime);
            buf.writeInt(data.shotgun.recoil);
            buf.writeInt(data.shotgun.fireRate);
            buf.writeInt(data.shotgun.pelletCount);
            buf.writeInt(data.autogun.damage);
            buf.writeInt(data.autogun.reloadTime);
            buf.writeInt(data.autogun.recoil);
            buf.writeInt(data.autogun.fireRate);
            buf.writeInt(data.machinegun.damage);
            buf.writeInt(data.machinegun.reloadTime);
            buf.writeInt(data.machinegun.recoil);
            buf.writeInt(data.machinegun.fireRate);
            buf.writeBoolean(data.misc.gunsAttractMobs);
            buf.writeInt(data.misc.magazineReloadTime);
            buf.writeInt(data.misc.distantSoundRange);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ConfigSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ModConfig.setData(packet.data);
            AnotherGunMod.LOGGER.info("Config synchronized from operator");
        });
    }
}

