/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.mixin;

import com.f708.anothergunmod.core.AmmoContainer;
import com.f708.anothergunmod.core.AmmoContainerRecord;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.registry.item.custom.MachineGun;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Unique
    private static final ThreadLocal<ItemDisplayContext> CURRENT_DISPLAY_CONTEXT = ThreadLocal.withInitial(() -> ItemDisplayContext.NONE);

    @Shadow
    public abstract BakedModel getModel(ItemStack var1, @Nullable Level var2, @Nullable LivingEntity var3, int var4);

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void captureDisplayContext(ItemStack itemStack, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, BakedModel p_model, CallbackInfo ci) {
        CURRENT_DISPLAY_CONTEXT.set(displayContext);
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/BakedModel;getRenderPasses(Lnet/minecraft/world/item/ItemStack;Z)Ljava/util/List;")})
    private List<BakedModel> modifyGunModels(BakedModel instance, ItemStack itemStack, boolean fabulous, Operation<List<BakedModel>> original) {
        boolean isGuiContext;
        ArrayList<BakedModel> list = (ArrayList<BakedModel>)original.call(new Object[]{instance, itemStack, fabulous});
        if (!(itemStack.getItem() instanceof AbstractGunItem)) {
            return list;
        }
        if (itemStack.is(ModItems.REVOLVER.get())) {
            return list;
        }
        ItemDisplayContext context = CURRENT_DISPLAY_CONTEXT.get();
        list = new ArrayList<BakedModel>(list);
        boolean bl = isGuiContext = context == ItemDisplayContext.GUI || context == ItemDisplayContext.HEAD || context == ItemDisplayContext.GROUND || context == ItemDisplayContext.FIXED;
        if (itemStack.is(ModItems.RIFLE.get())) {
            if (isGuiContext) {
                list.clear();
                list.add(this.getModelByName("rifle_gui"));
            }
            return list;
        }
        if (itemStack.is(ModItems.RIFLEWITHSPYGLASS.get())) {
            if (isGuiContext) {
                list.clear();
                list.add(this.getModelByName("rifle_spyglass_gui"));
            }
        } else {
            if (itemStack.is(ModItems.SHOTGUN.get())) {
                if (isGuiContext) {
                    list.clear();
                    list.add(this.getModelByName("shotgun_gui"));
                }
                return list;
            }
            if (itemStack.is(ModItems.AUTOGUN.get())) {
                if (isGuiContext) {
                    list.clear();
                    if (((Boolean)itemStack.getOrDefault(ModDataComponents.MAGAZINEATTACHED, (Object)false)).booleanValue()) {
                        list.add(this.getModelByName("auto_gun_with_magazine_gui"));
                    } else {
                        list.add(this.getModelByName("auto_gun_gui"));
                    }
                }
                return list;
            }
            if (itemStack.is(ModItems.MACHINEGUN.get())) {
                MachineGun machineGun = (MachineGun)itemStack.getItem();
                list.clear();
                if (isGuiContext) {
                    list.add(this.getModelByName("machine_gun_gui"));
                    if (machineGun.magazineAttached(itemStack) && !machineGun.bigMagazineAttached(itemStack)) {
                        list.add(this.getModelByName("machine_gun_small_magazine_gui"));
                    } else if (((Boolean)itemStack.getOrDefault(ModDataComponents.BIGMAGAZINEATTACHED, (Object)false)).booleanValue()) {
                        list.add(this.getModelByName("machine_gun_big_magazine_gui"));
                    }
                } else {
                    list.add(this.getModelByName("machine_gun"));
                    if (machineGun.magazineAttached(itemStack) && !machineGun.bigMagazineAttached(itemStack)) {
                        list.add(this.getModelByName("machine_gun_small_magazine"));
                    } else if (((Boolean)itemStack.getOrDefault(ModDataComponents.BIGMAGAZINEATTACHED, (Object)false)).booleanValue()) {
                        list.add(this.getModelByName("machine_gun_big_magazine"));
                    }
                }
                return list;
            }
            if (itemStack.is(ModItems.FLAMETHROWER.get())) {
                AmmoContainerRecord container = new AmmoContainerRecord(new AmmoContainer(100));
                Item item = itemStack.getItem();
                if (item instanceof AbstractGunItem) {
                    AbstractGunItem abstractGunItem = (AbstractGunItem)item;
                    container = abstractGunItem.getAmmoContainer(itemStack);
                }
                int ammo = container.size();
                if (isGuiContext) {
                    list.clear();
                    list.add(this.getModelByName("flame_thrower_gui"));
                    if (ammo < 30) {
                        list.add(this.getModelByName("indicator_gui0"));
                    } else if (ammo < 60) {
                        list.add(this.getModelByName("indicator_gui1"));
                    } else if (ammo <= 100) {
                        list.add(this.getModelByName("indicator_gui2"));
                    }
                    if (!((Boolean)itemStack.getOrDefault(ModDataComponents.MAGAZINEATTACHED, (Object)false)).booleanValue()) {
                        list.add(this.getModelByName("gui_activated"));
                    }
                } else {
                    if (ammo < 33) {
                        list.add(this.getModelByName("indicator0"));
                    } else if (ammo < 66) {
                        list.add(this.getModelByName("indicator1"));
                    } else if (ammo <= 100) {
                        list.add(this.getModelByName("indicator2"));
                    }
                    if (!((Boolean)itemStack.getOrDefault(ModDataComponents.MAGAZINEATTACHED, (Object)false)).booleanValue()) {
                        list.add(this.getModelByName("activated"));
                    }
                }
            }
        }
        return list;
    }

    @Unique
    private BakedModel getModelByName(String modelName) {
        return Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)("item/" + modelName))));
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void clearDisplayContext(ItemStack itemStack, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, BakedModel p_model, CallbackInfo ci) {
        CURRENT_DISPLAY_CONTEXT.remove();
    }
}

