/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.nami.MamiFormation;
import com.f708.anothergunmod.nami.MamiRifleItem;
import com.f708.anothergunmod.nami.MamiRifleLimit;
import com.f708.anothergunmod.nami.MamiRifleManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record C2S_MamiConfigPacket(MamiFormation formation, MamiRifleLimit limit) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<C2S_MamiConfigPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"mami_config"));
    public static final StreamCodec<ByteBuf, C2S_MamiConfigPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, packet -> packet.formation.name(), (StreamCodec)ByteBufCodecs.STRING_UTF8, packet -> packet.limit.name(), (formationName, limitName) -> new C2S_MamiConfigPacket(MamiFormation.valueOf(formationName), MamiRifleLimit.valueOf(limitName)));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(C2S_MamiConfigPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            ItemStack stack = player.getMainHandItem();
            if (stack.getItem() instanceof MamiRifleItem) {
                String oldLimitStr = (String)stack.getOrDefault(ModDataComponents.MAMI_LIMIT, (Object)"TEN");
                int oldLimit = MamiRifleLimit.valueOf(oldLimitStr).getCount();
                int newLimit = packet.limit.getCount();
                stack.set(ModDataComponents.MAMI_FORMATION, (Object)packet.formation.name());
                stack.set(ModDataComponents.MAMI_LIMIT, (Object)packet.limit.name());
                if (oldLimit != newLimit) {
                    MamiRifleManager.adjustToLimit(player);
                }
            }
        });
    }
}

