/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.nami.MamiFormation;
import java.util.Random;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class FormationStrategy {
    private static final double ORBIT_RADIUS = 3.5;
    private static final int[] GOB_LAYER_COUNTS = new int[]{6, 10, 14, 12, 8};
    private static final double[] GOB_LAYER_HEIGHTS = new double[]{0.5, 1.2, 1.8, 2.5, 3.2};
    private static final double[] GOB_LAYER_RADII = new double[]{2.5, 3.0, 3.5, 4.0, 3.8};
    private static final double[] GOB_ANGLE_RANGES = new double[]{150.0, 170.0, 180.0, 170.0, 140.0};
    private static final double[] GOB_DEPTH_VAR = new double[]{0.2, 0.3, 0.4, 0.3, 0.2};
    private static final int GOB_BASE_TOTAL = 50;
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final double TWO_PI = Math.PI * 2;
    private static final DirectionCache dirCache = new DirectionCache();

    public static Vec3 getPosition(MamiFormation formation, Player player, int index, int total) {
        if (total <= 0) {
            total = 1;
        }
        index = Math.max(0, Math.min(index, total - 1));
        Vec3 center = player.position().add(0.0, (double)player.getBbHeight() * 0.7, 0.0);
        dirCache.update(player, player.tickCount);
        Vec3 basePos = switch (formation) {
            default -> throw new MatchException(null, null);
            case MamiFormation.CIRCLE -> FormationStrategy.circle(center, player, index, total);
            case MamiFormation.LINE_BACK -> FormationStrategy.lineBack(center, player, index, total);
            case MamiFormation.SIDES -> FormationStrategy.sides(center, player, index, total);
            case MamiFormation.GATE_OF_BABYLON -> FormationStrategy.gateOfBabylon(center, player, index, total);
        };
        int swayHash = player.tickCount / 20 + index;
        double sway = ((double)(swayHash & 0x1F) / 31.0 - 0.5) * 0.3;
        double floatY = ((double)(swayHash >> 5 & 0x1F) / 31.0 - 0.5) * 0.2;
        return basePos.add(sway, floatY, sway * 0.5);
    }

    private static Vec3 circle(Vec3 center, Player player, int index, int total) {
        int layer = index / 10;
        int indexInLayer = index % 10;
        int totalInLayer = Math.min(10, total - layer * 10);
        if (totalInLayer <= 0) {
            totalInLayer = 1;
        }
        float angleBase = (float)((double)indexInLayer * (Math.PI * 2) / (double)totalInLayer);
        float angleTick = (float)player.tickCount * 0.02f;
        float angle = angleBase + angleTick;
        double layerRadius = 3.5 + (double)layer * 0.5;
        double yOffset = (double)layer * 1.2 - 1.0;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return new Vec3(center.x + cos * layerRadius, center.y + yOffset, center.z + sin * layerRadius);
    }

    private static Vec3 sides(Vec3 center, Player player, int index, int total) {
        int startIndex;
        double radius;
        int riflesInRow;
        int row;
        int totalOnSide;
        double scaleFactor = total > 100 ? 1.0 + (double)(total - 100) / 200.0 : 1.0;
        int halfTotal = (total + 1) / 2;
        boolean isLeft = index < halfTotal;
        int side = isLeft ? -1 : 1;
        int sideIndex = isLeft ? index : index - halfTotal;
        int n = totalOnSide = isLeft ? halfTotal : total - halfTotal;
        if (totalOnSide <= 4) {
            row = 0;
            riflesInRow = totalOnSide;
            radius = 2.5;
            startIndex = 0;
        } else if (totalOnSide <= 10) {
            if (sideIndex < 4) {
                row = 0;
                riflesInRow = 4;
                radius = 2.5;
                startIndex = 0;
            } else {
                row = 1;
                riflesInRow = totalOnSide - 4;
                radius = 4.0;
                startIndex = 4;
            }
        } else if (sideIndex < 4) {
            row = 0;
            riflesInRow = 4;
            radius = 2.5;
            startIndex = 0;
        } else if (sideIndex < 10) {
            row = 1;
            riflesInRow = 6;
            radius = 4.0;
            startIndex = 4;
        } else {
            row = 2;
            riflesInRow = totalOnSide - 10;
            radius = 6.0;
            startIndex = 10;
        }
        radius *= scaleFactor;
        int indexInRow = sideIndex - startIndex;
        double angleStep = Math.PI / (double)Math.max(riflesInRow - 1, 1);
        double baseAngle = (double)indexInRow * angleStep;
        int hash = index * 9999;
        double angleOffset = ((double)(hash & 0xFF) / 255.0 - 0.5) * 0.175;
        double rowOffset = row % 2 == 0 ? 0.0 : angleStep * 0.5;
        double angle = baseAngle + angleOffset + rowOffset;
        double cosA = Math.cos(angle);
        double sinA = Math.sin(angle);
        double height = (double)(hash >> 8 & 0xFF) / 85.0 * scaleFactor;
        double sideComponent = (double)side * cosA * radius;
        double forwardComponent = (1.0 - sinA) * radius;
        return new Vec3(center.x + FormationStrategy.dirCache.right.x * sideComponent + FormationStrategy.dirCache.back.x * forwardComponent, center.y + height, center.z + FormationStrategy.dirCache.right.z * sideComponent + FormationStrategy.dirCache.back.z * forwardComponent);
    }

    private static Vec3 lineBack(Vec3 center, Player player, int index, int total) {
        int startIndex;
        double radius;
        int riflesInRow;
        int row;
        double scaleFactor = total <= 50 ? 1.0 : (total <= 100 ? 1.0 + (double)(total - 50) / 100.0 : 1.5 + (double)(total - 100) / 200.0);
        if (total <= 7) {
            row = 0;
            riflesInRow = total;
            radius = 2.0;
            startIndex = 0;
        } else if (total <= 19) {
            if (index < 7) {
                row = 0;
                riflesInRow = 7;
                radius = 2.0;
                startIndex = 0;
            } else {
                row = 1;
                riflesInRow = total - 7;
                radius = 3.5;
                startIndex = 7;
            }
        } else if (index < 7) {
            row = 0;
            riflesInRow = 7;
            radius = 2.0;
            startIndex = 0;
        } else if (index < 19) {
            row = 1;
            riflesInRow = 12;
            radius = 3.5;
            startIndex = 7;
        } else {
            row = 2;
            riflesInRow = total - 19;
            radius = 5.0;
            startIndex = 19;
        }
        radius *= scaleFactor;
        int indexInRow = index - startIndex;
        double maxAngle = total > 100 ? 3.7699111843077517 : Math.PI;
        double angleStep = maxAngle / (double)Math.max(riflesInRow - 1, 1);
        double baseAngle = -maxAngle * 0.5 + (double)indexInRow * angleStep;
        int hash = index * 7777;
        double angleOffset = ((double)(hash & 0xFF) / 255.0 - 0.5) * 0.175;
        double rowOffset = row % 2 == 0 ? 0.0 : angleStep * 0.5;
        double angle = baseAngle + angleOffset + rowOffset;
        double deadZoneAngle = Math.toRadians(20.0);
        if (Math.abs(angle) < deadZoneAngle) {
            angle = angle >= 0.0 ? deadZoneAngle : -deadZoneAngle;
        }
        double height = (double)(hash >> 8 & 0xFF) / 127.5 * scaleFactor;
        double cosA = Math.cos(angle);
        double sinA = Math.sin(angle);
        double backComponent = cosA * radius;
        double sideComponent = sinA * radius;
        return new Vec3(center.x + FormationStrategy.dirCache.back.x * backComponent + FormationStrategy.dirCache.right.x * sideComponent, center.y + height, center.z + FormationStrategy.dirCache.back.z * backComponent + FormationStrategy.dirCache.right.z * sideComponent);
    }

    private static Vec3 gateOfBabylon(Vec3 center, Player player, int index, int total) {
        double radius;
        int riflesInRow;
        int row;
        if (total <= 0) {
            total = 1;
        }
        Vec3 look = player.getLookAngle();
        Vec3 right = look.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        double scaleFactor = total > 100 ? 1.0 + (double)(total - 100) / 100.0 : 1.0;
        int startIndex = 0;
        if (total <= 7) {
            row = 0;
            riflesInRow = total;
            radius = 2.0 * scaleFactor;
        } else if (total <= 19) {
            if (index < 7) {
                row = 0;
                riflesInRow = 7;
                radius = 2.0 * scaleFactor;
                startIndex = 0;
            } else {
                row = 1;
                riflesInRow = total - 7;
                radius = 3.5 * scaleFactor;
                startIndex = 7;
            }
        } else if (index < 7) {
            row = 0;
            riflesInRow = 7;
            radius = 2.0 * scaleFactor;
            startIndex = 0;
        } else if (index < 19) {
            row = 1;
            riflesInRow = 12;
            radius = 3.5 * scaleFactor;
            startIndex = 7;
        } else {
            row = 2;
            riflesInRow = total - 19;
            radius = 5.0 * scaleFactor;
            startIndex = 19;
        }
        int indexInRow = index - startIndex;
        double maxAngle = total > 100 ? 3.7699111843077517 : Math.PI;
        double angleStep = maxAngle / (double)Math.max(riflesInRow - 1, 1);
        double baseAngle = -maxAngle / 2.0 + (double)indexInRow * angleStep;
        Random rand = new Random((long)index * 7777L);
        double angleOffset = (rand.nextDouble() - 0.5) * Math.toRadians(10.0);
        double angle = baseAngle + angleOffset;
        double rowOffset = row % 2 == 0 ? 0.0 : angleStep * 0.5;
        double backX = -Math.sin(Math.toRadians(player.getYRot()));
        double backZ = Math.cos(Math.toRadians(player.getYRot()));
        Vec3 backDir = new Vec3(backX, 0.0, backZ).normalize();
        Vec3 offset = backDir.scale(Math.cos(angle += rowOffset) * radius).add(right.scale(Math.sin(angle) * radius));
        double height = rand.nextDouble() * 2.0;
        return center.add(offset).add(0.0, height, 0.0);
    }

    private static class DirectionCache {
        Vec3 back;
        Vec3 right;
        double yaw;
        long lastUpdate = -1L;

        private DirectionCache() {
        }

        void update(Player player, long tick) {
            if (this.lastUpdate == tick) {
                return;
            }
            this.lastUpdate = tick;
            Vec3 look = player.getLookAngle();
            this.back = new Vec3(-look.x, 0.0, -look.z).normalize();
            this.right = this.back.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
            this.yaw = Math.atan2(look.z, look.x);
        }
    }
}

