/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class MamiRifleData
implements INBTSerializable<CompoundTag> {
    public final Map<Integer, Integer> riflesByIndex = new HashMap<Integer, Integer>();
    public int summonCooldown = 0;
    public float rotationSpeed = 0.02f;
    public boolean limitReached = false;
    public boolean wasReleased = true;
    public int clientShotCounter = 0;
    public float shootAccumulator = 0.0f;
    public int currentShootIndex = 0;

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        int[] indices = this.riflesByIndex.keySet().stream().mapToInt(i -> i).toArray();
        int[] entityIds = this.riflesByIndex.values().stream().mapToInt(i -> i).toArray();
        tag.putIntArray("Indices", indices);
        tag.putIntArray("EntityIds", entityIds);
        tag.putInt("SummonCD", this.summonCooldown);
        tag.putFloat("RotSpeed", this.rotationSpeed);
        tag.putBoolean("LimitReached", this.limitReached);
        tag.putBoolean("WasReleased", this.wasReleased);
        tag.putFloat("ShootAccum", this.shootAccumulator);
        tag.putInt("ShootIndex", this.currentShootIndex);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.riflesByIndex.clear();
        int[] indices = tag.getIntArray("Indices");
        int[] entityIds = tag.getIntArray("EntityIds");
        for (int i = 0; i < Math.min(indices.length, entityIds.length); ++i) {
            this.riflesByIndex.put(indices[i], entityIds[i]);
        }
        this.summonCooldown = tag.getInt("SummonCD");
        this.rotationSpeed = tag.getFloat("RotSpeed");
        this.limitReached = tag.getBoolean("LimitReached");
        this.wasReleased = tag.getBoolean("WasReleased");
        this.shootAccumulator = tag.getFloat("ShootAccum");
        this.currentShootIndex = tag.getInt("ShootIndex");
    }
}

