/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.nami.MamiRifleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MamiRifleRenderer
extends EntityRenderer<MamiRifleEntity> {
    private final BakedModel rifleModel = this.getModelByName("rifle");

    public MamiRifleRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(MamiRifleEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        float spawnProgress = entity.getSpawnProgress(partialTick);
        if (spawnProgress <= 0.0f) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        float scale = 1.8f * spawnProgress;
        poseStack.scale(scale, scale, scale);
        float recoil = entity.getRecoilTicks() > 0 ? (float)entity.getRecoilTicks() * 0.3f : 0.0f;
        poseStack.mulPose(Axis.XP.rotationDegrees(recoil));
        float yaw = entity.getYRot();
        float pitch = entity.getXRot();
        Player owner = entity.getOwnerPlayer();
        if (owner != null) {
            ItemStack stack = owner.getMainHandItem();
            String formation = (String)stack.getOrDefault(ModDataComponents.MAMI_FORMATION, (Object)"CIRCLE");
            if (formation.equals("CIRCLE")) {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f - yaw));
                poseStack.mulPose(Axis.ZP.rotationDegrees(-45.0f));
            } else {
                poseStack.mulPose(Axis.YP.rotationDegrees(-yaw));
                poseStack.mulPose(Axis.XP.rotationDegrees(45.0f + pitch));
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        VertexConsumer consumer = buffer.getBuffer(RenderType.cutout());
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), consumer, null, this.rifleModel, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    private void renderWithSpawnEffect(PoseStack poseStack, MultiBufferSource buffer, BakedModel model, int packedLight, float progress) {
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((MamiRifleEntity)null)));
        float r = 1.0f;
        float g = 1.0f;
        float b = progress;
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), consumer, null, model, r, g, b, packedLight, OverlayTexture.NO_OVERLAY);
    }

    public ResourceLocation getTextureLocation(MamiRifleEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"textures/item/rifle.png");
    }

    private BakedModel getModelByName(String modelName) {
        ModelResourceLocation mrl = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)("item/" + modelName)));
        return Minecraft.getInstance().getModelManager().getModel(mrl);
    }
}

