/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.nami;

import com.f708.anothergunmod.core.events.core.ClientEventHandler;
import com.f708.anothergunmod.nami.MamiRifleEntity;
import com.f708.anothergunmod.nami.MamiRifleShootEvent;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record S2C_MamiRifleShootPacket(long ownerUUIDMost, long ownerUUIDLeast, int rifleEntityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2C_MamiRifleShootPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"mami_rifle_shoot"));
    public static final StreamCodec<ByteBuf, S2C_MamiRifleShootPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, S2C_MamiRifleShootPacket::ownerUUIDMost, (StreamCodec)ByteBufCodecs.VAR_LONG, S2C_MamiRifleShootPacket::ownerUUIDLeast, (StreamCodec)ByteBufCodecs.VAR_INT, S2C_MamiRifleShootPacket::rifleEntityId, S2C_MamiRifleShootPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(S2C_MamiRifleShootPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            UUID ownerUUID = new UUID(packet.ownerUUIDMost, packet.ownerUUIDLeast);
            Player owner = mc.level.getPlayerByUUID(ownerUUID);
            Entity entity = mc.level.getEntity(packet.rifleEntityId);
            if (owner != null && entity instanceof MamiRifleEntity) {
                MamiRifleEntity rifle = (MamiRifleEntity)entity;
                MamiRifleShootEvent event = new MamiRifleShootEvent(owner, rifle);
                ClientEventHandler.onMamiRifleShoot(event);
            }
        });
    }
}

