/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.entity.bullet;

import com.f708.anothergunmod.core.ModDamageTypes;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.registry.particle.ModParticleTypes;
import com.f708.anothergunmod.sounds.ModSounds;
import com.f708.anothergunmod.utils.GunUtils;
import com.f708.anothergunmod.utils.ModTags;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class BulletEntity
extends AbstractArrow {
    private int maxLifetime = 100;
    private int currentLifetime = 0;
    private float bulletSpeed = 3.0f;
    private Vec3 spread = Vec3.ZERO;
    private ParticleOptions particleType = (ParticleOptions)ModParticleTypes.AIR_RING.get();
    private final ParticleOptions particleTrailType = (ParticleOptions)ModParticleTypes.BULLET_TRAIL.get();
    private SoundEvent hitBlockSound = ModSounds.BULLET_HIT_SOUND.get();
    private SoundEvent flybySound = ModSounds.BULLET_FLY.get();
    private final Set<UUID> playersHeardFlyby = new HashSet<UUID>();
    private Vec3 lastTrailPos;
    private Vec3 prevPosThisTick = null;
    private int blockImmunityTicks = 0;
    private int hitTargets = 0;
    private boolean blockHit = false;
    private ItemStack firedWeapon;

    public BulletEntity(EntityType<? extends BulletEntity> entityType, Level level) {
        super(entityType, level);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public BulletEntity(EntityType<? extends BulletEntity> entityType, Level level, LivingEntity shooter, float speed, int lifetime, Vec3 spread, float damage, ItemStack gun) {
        super(entityType, level);
        this.setSilent(true);
        this.setOwner((Entity)shooter);
        this.setBaseDamage(damage);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        this.bulletSpeed = speed;
        this.maxLifetime = lifetime;
        this.spread = spread;
        this.firedWeapon = gun;
        Random bulletRandom = new Random();
        Vec3 look = shooter.getLookAngle();
        Vec3 vel = look.add(bulletRandom.nextGaussian() * spread.x, bulletRandom.nextGaussian() * spread.y, bulletRandom.nextGaussian() * spread.z).normalize().scale((double)this.bulletSpeed);
        this.setDeltaMovement(vel);
        Vec3 startPos = null;
        startPos = shooter.isSprinting() ? shooter.getEyePosition().add(look.scale(0.8)) : shooter.getEyePosition().add(look.scale(0.6));
        this.setPos(startPos.x, startPos.y, startPos.z);
        this.lastTrailPos = this.position();
        this.hitBlockSound = ModSounds.BULLET_HIT_SOUND.get();
        this.flybySound = ModSounds.BULLET_FLY.get();
    }

    public BulletEntity(EntityType<? extends BulletEntity> entityType, Level level, LivingEntity owner, Vec3 startPos, Vec3 direction, float speed, int lifetime, Vec3 spread, float damage, ItemStack gun) {
        super(entityType, level);
        this.setSilent(true);
        this.setOwner((Entity)owner);
        this.setBaseDamage(damage);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        this.bulletSpeed = speed;
        this.maxLifetime = lifetime;
        this.spread = spread;
        this.firedWeapon = gun;
        Random bulletRandom = new Random();
        Vec3 vel = direction.add(bulletRandom.nextGaussian() * spread.x, bulletRandom.nextGaussian() * spread.y, bulletRandom.nextGaussian() * spread.z).normalize().scale((double)this.bulletSpeed);
        this.setDeltaMovement(vel);
        this.setPos(startPos.x, startPos.y, startPos.z);
        this.lastTrailPos = this.position();
        this.hitBlockSound = ModSounds.BULLET_HIT_SOUND.get();
        this.flybySound = ModSounds.BULLET_FLY.get();
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)0.3f, (float)0.3f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void tick() {
        ++this.currentLifetime;
        if (this.currentLifetime >= this.maxLifetime) {
            this.discard();
            return;
        }
        float speed = (float)this.getDeltaMovement().length();
        if (this.isInWater()) {
            speed /= 2.0f;
            ++this.currentLifetime;
        }
        if ((double)speed < 2.0 || this.getBlockStateOn().isSuffocating((BlockGetter)this.level(), this.getOnPos())) {
            this.discard();
            return;
        }
        this.prevPosThisTick = this.position();
        Vec3 from = this.lastTrailPos != null ? this.lastTrailPos : this.position();
        super.tick();
        if (this.blockImmunityTicks > 0) {
            --this.blockImmunityTicks;
        }
        if (this.level().isClientSide && this.currentLifetime > 1 && !this.blockHit && !this.isInWater()) {
            this.spawnTrail(from, this.position());
        }
        if (this.level().isClientSide && this.currentLifetime % 5 == 0 && !this.blockHit) {
            this.level().addParticle(this.particleType, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        this.lastTrailPos = this.position();
        if (!this.level().isClientSide) {
            this.checkFlybySound();
        }
    }

    private void checkFlybySound() {
        AABB largeBoundingBox = this.getBoundingBox().inflate(2.0);
        List nearbyPlayers = this.level().getEntitiesOfClass(Player.class, largeBoundingBox);
        for (Player player : nearbyPlayers) {
            if (player == this.getOwner() || this.playersHeardFlyby.contains(player.getUUID()) || !this.random.nextBoolean()) continue;
            player.playNotifySound(this.flybySound, SoundSource.HOSTILE, 0.5f, 1.0f);
            this.playersHeardFlyby.add(player.getUUID());
        }
    }

    protected void doKnockback(LivingEntity entity, DamageSource damageSource) {
    }

    protected void onHitEntity(EntityHitResult result) {
        Player player;
        if (this.level().isClientSide) {
            return;
        }
        Entity entity = result.getEntity();
        Entity owner = this.getOwner();
        if (owner == null) {
            entity.invulnerableTime = 0;
            float damage = (float)this.getBaseDamage();
            entity.hurt(entity.damageSources().generic(), damage);
            ++this.hitTargets;
            if (this.hitTargets >= 6) {
                this.discard();
            }
            return;
        }
        DamageSource src = ModDamageTypes.bullet(this.level(), result.getEntity(), owner, this.getWeaponItem());
        entity.invulnerableTime = 0;
        float base = (float)this.getBaseDamage();
        int divider = Math.min(this.hitTargets + 1, 5);
        float damage = base / (float)divider;
        boolean wasAlive = entity.isAlive();
        if (entity instanceof Player && (player = (Player)entity).isBlocking()) {
            ItemStack shield = player.getUseItem();
            shield.hurtAndBreak(5, (LivingEntity)player, player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            entity.hurt(src, damage / 2.0f);
        } else {
            entity.hurt(src, damage);
        }
        if (wasAlive && !entity.isAlive() && entity instanceof LivingEntity) {
            this.incrementKillCounter();
        }
        ++this.hitTargets;
        if (this.hitTargets >= 6) {
            this.discard();
        }
    }

    private void incrementKillCounter() {
        Entity owner = this.getOwner();
        if (!(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        ItemStack weapon = this.getWeaponItem();
        if (weapon == null || weapon.isEmpty()) {
            return;
        }
        if (!(weapon.getItem() instanceof AbstractGunItem)) {
            return;
        }
        int currentKills = (Integer)weapon.getOrDefault(ModDataComponents.KILL_COUNTER, (Object)0);
        GunUtils.setOwner(player, weapon);
        weapon.set(ModDataComponents.KILL_COUNTER, (Object)(currentKills + 1));
    }

    protected void onHitBlock(BlockHitResult result) {
        this.blockHit = true;
        if (this.blockImmunityTicks > 0) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            boolean fragile;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState hitBlock = serverLevel.getBlockState(result.getBlockPos());
            Vec3 hitPos = result.getLocation();
            boolean bl = fragile = hitBlock.is(Tags.Blocks.GLASS_BLOCKS) || hitBlock.is(Tags.Blocks.GLASS_PANES) || hitBlock.is(ModTags.Blocks.BREAKABLE_WITH_BULLET);
            if (fragile) {
                serverLevel.destroyBlock(result.getBlockPos(), false, (Entity)this);
                Vec3 vel = this.getDeltaMovement();
                if (this.prevPosThisTick != null) {
                    this.setPos(this.prevPosThisTick.x, this.prevPosThisTick.y, this.prevPosThisTick.z);
                    this.lastTrailPos = this.prevPosThisTick;
                } else {
                    Vec3 back = vel.lengthSqr() > 1.0E-6 ? vel.normalize().scale(-0.05) : Vec3.ZERO;
                    this.setPos(this.getX() + back.x, this.getY() + back.y, this.getZ() + back.z);
                }
                this.blockHit = true;
                this.setDeltaMovement(vel);
                this.blockImmunityTicks = 1;
                return;
            }
            this.spawnBlockParticles(serverLevel, hitBlock, hitPos, result.getDirection());
            SoundEvent hitSound = this.getBlockHitSound(hitBlock);
            serverLevel.playSound(null, result.getBlockPos(), hitSound, SoundSource.BLOCKS, 1.0f, 0.8f + serverLevel.random.nextFloat() * 0.4f);
            this.blockHit = true;
            this.discard();
            return;
        }
        super.onHitBlock(result);
    }

    private void spawnTrail(Vec3 from, Vec3 to) {
        double dist = from.distanceTo(to);
        if (dist < 1.0E-4) {
            return;
        }
        double step = 0.15;
        int points = Mth.clamp((int)Mth.ceil((double)(dist / step)), (int)1, (int)64);
        for (int i = 1; i <= points; ++i) {
            double t = (double)i / (double)points;
            double x = Mth.lerp((double)t, (double)from.x, (double)to.x);
            double y = Mth.lerp((double)t, (double)from.y, (double)to.y);
            double z = Mth.lerp((double)t, (double)from.z, (double)to.z);
            double jitter = 0.02;
            double ox = (this.random.nextDouble() - 0.5) * jitter;
            double oy = (this.random.nextDouble() - 0.5) * jitter;
            double oz = (this.random.nextDouble() - 0.5) * jitter;
            this.level().addParticle((ParticleOptions)ModParticleTypes.BULLET_TRAIL.get(), x + ox, y + oy, z + oz, 0.0, 0.0, 0.0);
        }
    }

    private void spawnBlockParticles(ServerLevel level, BlockState blockState, Vec3 hitPos, Direction hitSide) {
        BlockParticleOption blockParticle = new BlockParticleOption(ParticleTypes.BLOCK, blockState);
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)hitSide.getNormal());
        for (int i = 0; i < 8; ++i) {
            double offsetX = (level.random.nextDouble() - 0.5) * 0.3;
            double offsetY = (level.random.nextDouble() - 0.5) * 0.3;
            double offsetZ = (level.random.nextDouble() - 0.5) * 0.3;
            double velocityX = normal.x * 0.1 + (level.random.nextDouble() - 0.5) * 0.1;
            double velocityY = normal.y * 0.1 + (level.random.nextDouble() - 0.5) * 0.1;
            double velocityZ = normal.z * 0.1 + (level.random.nextDouble() - 0.5) * 0.1;
            level.sendParticles((ParticleOptions)blockParticle, hitPos.x + offsetX, hitPos.y + offsetY, hitPos.z + offsetZ, 1, velocityX, velocityY, velocityZ, 0.1);
        }
    }

    private SoundEvent getBlockHitSound(BlockState blockState) {
        SoundType soundType = blockState.getSoundType();
        return soundType.getBreakSound();
    }

    public ItemStack getWeaponItem() {
        return this.firedWeapon;
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public boolean tryPickup(Player player) {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    protected float getWaterInertia() {
        return 1.0f;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return this.hitBlockSound;
    }

    public boolean isNoPhysics() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 4096.0;
    }

    public void setParticleType(ParticleOptions particleType) {
        this.particleType = particleType;
    }

    public void setHitBlockSound(SoundEvent sound) {
        this.hitBlockSound = sound;
    }

    public void setFlybySound(SoundEvent sound) {
        this.flybySound = sound;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.maxLifetime = compound.getInt("MaxLifetime");
        this.currentLifetime = compound.getInt("CurrentLifetime");
        this.bulletSpeed = compound.getFloat("BulletSpeed");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("MaxLifetime", this.maxLifetime);
        compound.putInt("CurrentLifetime", this.currentLifetime);
        compound.putFloat("BulletSpeed", this.bulletSpeed);
    }
}

