/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.item.custom;

import com.f708.anothergunmod.core.AmmoContainer;
import com.f708.anothergunmod.core.AmmoContainerRecord;
import com.f708.anothergunmod.core.enums.AmmoType;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.events.game.WeaponReloadEvent;
import com.f708.anothergunmod.core.events.game.WeaponShootEvent;
import com.f708.anothergunmod.core.interfaces.IGun;
import com.f708.anothergunmod.data.ModDataAttachments;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.network.packets.S2C_ScopingDataPacket;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.magazine.BigMagazine;
import com.f708.anothergunmod.registry.item.custom.magazine.SmallMagazine;
import com.f708.anothergunmod.registry.item.custom.mechanics.DualWieldRevolverState;
import com.f708.anothergunmod.utils.AdvUtils;
import com.f708.anothergunmod.utils.GunUtils;
import com.f708.anothergunmod.utils.Utils;
import com.f708.anothergunmod.utils.WeaponEventSynchronizer;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractGunItem
extends Item {
    public AbstractGunItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public abstract int rangedDamage(ItemStack var1);

    public abstract int bulletAmountPerShot(ItemStack var1);

    public abstract int maxAmmo(ItemStack var1);

    public abstract int recoil(ItemStack var1);

    public abstract int fireRate(ItemStack var1);

    public abstract int reloadTime(ItemStack var1);

    public abstract WeaponType weaponType();

    public abstract AmmoType ammoType();

    public abstract boolean magazineAttached(ItemStack var1);

    public abstract boolean isAmmoEmpty(ItemStack var1);

    public abstract boolean canShoot(ItemStack var1, Player var2);

    public abstract boolean isMaxAmmo(ItemStack var1);

    public abstract void descreaseAmmo(ItemStack var1);

    public abstract int getAmmo(ItemStack var1);

    public AmmoContainerRecord getAmmoContainer(ItemStack gun) {
        return (AmmoContainerRecord)gun.getOrDefault(ModDataComponents.AMMO_CONTAINER, (Object)new AmmoContainerRecord(new AmmoContainer(this.maxAmmo(gun))));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player.level().isClientSide && this.canShoot(player.getItemInHand(usedHand), player)) {
            GunUtils.forceFirstPerson(player, player.getItemInHand(usedHand));
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack usedStack = player.getItemInHand(usedHand);
            if (!AbstractGunItem.canFireState(player, usedHand, this.weaponType()) || player.isSprinting()) {
                return InteractionResultHolder.pass((Object)usedStack);
            }
            if (this.weaponType() == WeaponType.REVOLVER) {
                ItemStack fireStack;
                ItemStack main = player.getMainHandItem();
                ItemStack off = player.getOffhandItem();
                boolean bothRevolvers = AbstractGunItem.isRevolver(main) && AbstractGunItem.isRevolver(off);
                InteractionHand fireHand = usedHand;
                if (bothRevolvers) {
                    fireHand = DualWieldRevolverState.pickHandToFire(player, main, off);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        AdvUtils.grant(serverPlayer, ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"macedonian_shooting"));
                    }
                }
                if (this.canShoot(fireStack = player.getItemInHand(fireHand), player)) {
                    this.shoot(player, fireStack, (Level)serverLevel, fireHand);
                    player.startUsingItem(usedHand);
                    if (bothRevolvers) {
                        DualWieldRevolverState.toggleAfterShot(player);
                    }
                    return InteractionResultHolder.sidedSuccess((Object)usedStack, (boolean)level.isClientSide());
                }
                return InteractionResultHolder.pass((Object)usedStack);
            }
            if (this.canShoot(usedStack, player)) {
                this.shoot(player, usedStack, (Level)serverLevel, usedHand);
                player.startUsingItem(usedHand);
                return InteractionResultHolder.sidedSuccess((Object)usedStack, (boolean)level.isClientSide());
            }
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResultHolder<ItemStack> res = this.use(context.getLevel(), context.getPlayer(), context.getHand());
        return res.getResult();
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (InteractionHand hand : InteractionHand.values()) {
                if (player.getItemInHand(hand) != stack) continue;
                this.use(level, player, hand);
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.stopUsingItem();
        }
    }

    public void shoot(Player player, ItemStack stack, Level level, InteractionHand hand) {
        if (!player.level().isClientSide) {
            if (player.getCooldowns().isOnCooldown((Item)this) || !this.canShoot(stack, player)) {
                return;
            }
            if (player.isUnderWater() && !stack.is(ModItems.FLAMETHROWER.get())) {
                return;
            }
            if (GunUtils.hasGunOnCooldown(player)) {
                return;
            }
            IGun gun = (IGun)stack.getItem();
            gun.shoot(player, stack);
            stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            player.getCooldowns().addCooldown(Items.SHIELD, 35);
            WeaponShootEvent shootEvent = new WeaponShootEvent(player, this.weaponType(), hand);
            WeaponEventSynchronizer.syncShootEvent(shootEvent, 64.0);
            WeaponShootEvent.messageMobs(shootEvent);
        }
    }

    public void reload(Player player, ItemStack stack, InteractionHand hand) {
        Item item;
        if (!player.level().isClientSide && (item = stack.getItem()) instanceof AbstractGunItem) {
            AbstractGunItem gunItem = (AbstractGunItem)item;
            if (gunItem.isReloading(stack) || player.getCooldowns().isOnCooldown(stack.getItem())) {
                return;
            }
            IGun gun = (IGun)stack.getItem();
            gun.reload(player, stack);
            WeaponReloadEvent reloadEvent = new WeaponReloadEvent(player, this.weaponType(), hand);
            WeaponEventSynchronizer.syncReloadEvent(reloadEvent, 32.0);
            player.getInventory().setChanged();
        }
    }

    public Component getName(ItemStack stack) {
        int kills = (Integer)stack.getOrDefault(ModDataComponents.KILL_COUNTER, (Object)0);
        Component baseName = super.getName(stack);
        if (kills >= 1000) {
            return baseName.copy().withStyle(ChatFormatting.GOLD);
        }
        if (kills >= 500) {
            return baseName.copy().withStyle(ChatFormatting.BLUE);
        }
        if (kills >= 100) {
            return baseName.copy().withStyle(ChatFormatting.GREEN);
        }
        if (kills >= 50) {
            return baseName.copy().withStyle(ChatFormatting.WHITE);
        }
        if (kills >= 10) {
            return baseName.copy().withStyle(ChatFormatting.WHITE);
        }
        return baseName;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        String owner;
        Component stars;
        int kills = (Integer)stack.getOrDefault(ModDataComponents.KILL_COUNTER, (Object)0);
        if (kills >= 10 && (stars = this.getStarsComponent(kills)) != null) {
            tooltipComponents.add(stars);
        }
        if (!(owner = (String)stack.getOrDefault(ModDataComponents.OWNER, (Object)"")).isEmpty() || kills > 0) {
            tooltipComponents.add((Component)Component.empty());
            if (kills > 0) {
                ChatFormatting color = this.getKillCountColor(kills);
                tooltipComponents.add((Component)Component.literal((String)"").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"tooltip.anothergunmod.kills").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(kills)).withStyle(new ChatFormatting[]{color, ChatFormatting.BOLD})));
            }
            if (!owner.isEmpty()) {
                tooltipComponents.add((Component)Component.literal((String)"").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"tooltip.anothergunmod.owner").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)owner).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})));
            }
            tooltipComponents.add((Component)Component.empty());
        }
        tooltipComponents.add((Component)Component.translatable((String)"item.modifiers.mainhand").withStyle(ChatFormatting.GRAY));
        try {
            float damage = this.rangedDamage(stack);
            tooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.anothergunmod.damage").withStyle(ChatFormatting.DARK_GREEN)).append(" ").append((Component)Component.literal((String)String.valueOf(damage)).withStyle(ChatFormatting.DARK_GREEN)));
        }
        catch (Exception e) {
            tooltipComponents.add((Component)Component.literal((String)" Error: damage").withStyle(ChatFormatting.RED));
        }
        try {
            int fireRate = this.fireRate(stack);
            tooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.anothergunmod.firerate").withStyle(ChatFormatting.DARK_GREEN)).append(" ").append((Component)Component.literal((String)String.valueOf(fireRate)).withStyle(ChatFormatting.DARK_GREEN)));
        }
        catch (Exception e) {
            tooltipComponents.add((Component)Component.literal((String)" Error: firerate").withStyle(ChatFormatting.RED));
        }
        try {
            float recoilValue = this.recoil(stack);
            tooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.anothergunmod.recoil").withStyle(ChatFormatting.DARK_GREEN)).append(" ").append((Component)Component.literal((String)String.valueOf(recoilValue)).withStyle(ChatFormatting.DARK_GREEN)));
        }
        catch (Exception e) {
            tooltipComponents.add((Component)Component.literal((String)" Error: recoil").withStyle(ChatFormatting.RED));
        }
    }

    private Component getStarsComponent(int kills) {
        if (kills >= 1000) {
            return Component.literal((String)"\u2605\u2605\u2605\u2605\u2605").withStyle(ChatFormatting.GOLD);
        }
        if (kills >= 500) {
            return Component.literal((String)"\u2605\u2605\u2605\u2605").withStyle(ChatFormatting.BLUE);
        }
        if (kills >= 100) {
            return Component.literal((String)"\u2605\u2605\u2605").withStyle(ChatFormatting.GREEN);
        }
        if (kills >= 50) {
            return Component.literal((String)"\u2605\u2605").withStyle(ChatFormatting.WHITE);
        }
        if (kills >= 10) {
            return Component.literal((String)"\u2605").withStyle(ChatFormatting.WHITE);
        }
        return null;
    }

    private ChatFormatting getKillCountColor(int kills) {
        if (kills >= 1000) {
            return ChatFormatting.GOLD;
        }
        if (kills >= 500) {
            return ChatFormatting.BLUE;
        }
        if (kills >= 100) {
            return ChatFormatting.GREEN;
        }
        if (kills >= 50) {
            return ChatFormatting.WHITE;
        }
        if (kills >= 10) {
            return ChatFormatting.WHITE;
        }
        return ChatFormatting.GRAY;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            boolean isHeldInHand;
            Player player = (Player)entity;
            if (this.isReloading(stack)) {
                boolean bl = isHeldInHand = player.getMainHandItem() == stack || player.getOffhandItem() == stack;
                if (!isHeldInHand) {
                    this.removeReloading(stack);
                    player.getCooldowns().removeCooldown(stack.getItem());
                } else if (!player.getCooldowns().isOnCooldown(stack.getItem())) {
                    this.performReload(stack, player);
                    this.removeReloading(stack);
                }
            }
            if (this.isBlocking(stack)) {
                float cooldown = player.getCooldowns().getCooldownPercent(stack.getItem(), 1.0f);
                if ((double)cooldown < 0.1) {
                    stack.set(ModDataComponents.BLOCKED_ATTACK, (Object)false);
                    stack.hurtAndBreak(this.getMaxDamage(stack) / 2, (LivingEntity)player, EquipmentSlot.MAINHAND);
                } else if ((double)cooldown > 0.9 && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ItemParticleOption itemParticleOption = new ItemParticleOption(ParticleTypes.ITEM, stack);
                    serverLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, SoundSource.PLAYERS, 1.0f, 1.0f);
                    serverLevel.sendParticles((ParticleOptions)itemParticleOption, player.getX(), player.getY(), player.getZ(), 60, 0.5, 0.1, 0.1, 0.2);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, player.getX(), player.getY() + 1.0, player.getZ(), 1, 0.5, 0.1, 0.1, 0.2);
                }
            }
            GunUtils.handleSupportedPose(stack, level, entity, slotId, isSelected);
            if (!stack.is(ModItems.REVOLVER.get())) {
                boolean bl = isHeldInHand = player.getMainHandItem() == stack || player.getOffhandItem() == stack;
                if (isHeldInHand) {
                    player.setYBodyRot(player.getYHeadRot());
                }
            }
            if (stack.is(ModItems.RIFLEWITHSPYGLASS.get())) {
                this.rifleZoomBehaviour(stack, level, player);
            }
            if (stack.is(ModItems.FLAMETHROWER.get()) && this.isAmmoEmpty(stack)) {
                stack.set(ModDataComponents.MAGAZINEATTACHED, (Object)true);
            }
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!(attacker instanceof Player)) {
            return super.hurtEnemy(stack, target, attacker);
        }
        Player player = (Player)attacker;
        Random random = new Random();
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof AbstractGunItem) {
            AbstractGunItem abstractGunItem = (AbstractGunItem)item;
            player.getCooldowns().addCooldown((Item)abstractGunItem, 5);
            stack.hurtAndBreak(random.nextInt(5), attacker, EquipmentSlot.MAINHAND);
            return true;
        }
        return false;
    }

    private void performReload(ItemStack stack, Player player) {
        switch (this.weaponType()) {
            case REVOLVER: {
                if (!GunUtils.containItem(player, ModItems.SMALLBULLET.get())) break;
                ItemStack bullet = player.getInventory().getItem(GunUtils.getItemSlot(player, ModItems.SMALLBULLET.get()));
                bullet.shrink(1);
                Item item = stack.getItem();
                if (!(item instanceof AbstractGunItem)) break;
                AbstractGunItem gunItem = (AbstractGunItem)item;
                AmmoContainerRecord container = gunItem.getAmmoContainer(stack);
                stack.set(ModDataComponents.AMMO_CONTAINER, (Object)container.addNewBullet(bullet));
                break;
            }
            case RIFLE: 
            case RIFLE_SPYGLASS: {
                if (!GunUtils.containItem(player, ModItems.BIGBULLET.get())) break;
                ItemStack bullet = player.getInventory().getItem(GunUtils.getItemSlot(player, ModItems.BIGBULLET.get()));
                bullet.shrink(1);
                Object container = stack.getItem();
                if (!(container instanceof AbstractGunItem)) break;
                AbstractGunItem gunItem = (AbstractGunItem)((Object)container);
                container = this.getAmmoContainer(stack);
                stack.set(ModDataComponents.AMMO_CONTAINER, (Object)((AmmoContainerRecord)container).addNewBullet(bullet));
                break;
            }
            case SHOTGUN: {
                if (!GunUtils.containItem(player, ModItems.SHELL.get())) break;
                ItemStack shell = player.getInventory().getItem(GunUtils.getItemSlot(player, ModItems.SHELL.get()));
                shell.shrink(1);
                Object container = stack.getItem();
                if (!(container instanceof AbstractGunItem)) break;
                AbstractGunItem gunItem = (AbstractGunItem)((Object)container);
                container = this.getAmmoContainer(stack);
                stack.set(ModDataComponents.AMMO_CONTAINER, (Object)((AmmoContainerRecord)container).addNewBullet(shell));
                break;
            }
            case AUTOGUN: {
                ItemStack magazine;
                Item gunItem = stack.getItem();
                if (!(gunItem instanceof AbstractGunItem)) break;
                AbstractGunItem abstractGunItem = (AbstractGunItem)gunItem;
                if (this.magazineAttached(stack)) {
                    AmmoContainerRecord ammoContainer = abstractGunItem.getAmmoContainer(stack);
                    ItemStack magazine2 = new ItemStack((ItemLike)ModItems.SMALL_MAGAZINE.get());
                    magazine2.set(ModDataComponents.AMMO_CONTAINER, (Object)ammoContainer);
                    stack.set(ModDataComponents.AMMO_CONTAINER, (Object)ammoContainer.clear());
                    stack.set(ModDataComponents.MAGAZINEATTACHED, (Object)false);
                    Utils.safeAdd(magazine2, player);
                    break;
                }
                if (!GunUtils.containItem(player, ModItems.SMALL_MAGAZINE.get()) || (magazine = GunUtils.findBestSmallMagazine(player)).isEmpty()) break;
                GunUtils.attachMagazine(stack, magazine);
                magazine.shrink(1);
                break;
            }
            case MACHINEGUN: {
                SmallMagazine smallMagazineItem;
                BigMagazine bigMagazineItem;
                Item item;
                Item magazine = stack.getItem();
                if (!(magazine instanceof AbstractGunItem)) break;
                AbstractGunItem abstractGunItem = (AbstractGunItem)magazine;
                if (this.magazineAttached(stack)) {
                    AmmoContainerRecord ammoContainer = abstractGunItem.getAmmoContainer(stack);
                    boolean isBigMagazine = (Boolean)stack.getOrDefault(ModDataComponents.BIGMAGAZINEATTACHED, (Object)false);
                    ItemStack magazine3 = new ItemStack(isBigMagazine ? (ItemLike)ModItems.BIG_MAGAZINE.get() : (ItemLike)ModItems.SMALL_MAGAZINE.get());
                    magazine3.set(ModDataComponents.AMMO_CONTAINER, (Object)ammoContainer);
                    stack.set(ModDataComponents.MAGAZINEATTACHED, (Object)false);
                    stack.set(ModDataComponents.BIGMAGAZINEATTACHED, (Object)false);
                    stack.set(ModDataComponents.AMMO_CONTAINER, (Object)ammoContainer.clear());
                    Utils.safeAdd(magazine3, player);
                    break;
                }
                if (!GunUtils.containItem(player, ModItems.BIG_MAGAZINE.get()) && !GunUtils.containItem(player, ModItems.SMALL_MAGAZINE.get())) break;
                ItemStack bigMagazine = GunUtils.findBestBigMagazine(player);
                ItemStack smallMagazine = GunUtils.findBestSmallMagazine(player);
                boolean attached = false;
                if (!bigMagazine.isEmpty() && (item = bigMagazine.getItem()) instanceof BigMagazine && !(bigMagazineItem = (BigMagazine)item).isEmpty(bigMagazine)) {
                    GunUtils.attachMagazine(stack, bigMagazine);
                    stack.set(ModDataComponents.MAGAZINEATTACHED, (Object)true);
                    stack.set(ModDataComponents.BIGMAGAZINEATTACHED, (Object)true);
                    bigMagazine.shrink(1);
                    attached = true;
                }
                if (attached || smallMagazine.isEmpty() || !((item = smallMagazine.getItem()) instanceof SmallMagazine) || (smallMagazineItem = (SmallMagazine)item).isEmpty(smallMagazine)) break;
                GunUtils.attachMagazine(stack, smallMagazine);
                stack.set(ModDataComponents.MAGAZINEATTACHED, (Object)true);
                stack.set(ModDataComponents.BIGMAGAZINEATTACHED, (Object)false);
                smallMagazine.shrink(1);
                break;
            }
            case FLAMETHROWER: {
                AbstractGunItem gunItem;
                AmmoContainerRecord ammoContainer;
                Item smallMagazine;
                if (!GunUtils.containItem(player, Items.BLAZE_ROD)) break;
                ItemStack rod = player.getInventory().getItem(GunUtils.getItemSlot(player, Items.BLAZE_ROD));
                if (!this.magazineAttached(stack) || !((smallMagazine = stack.getItem()) instanceof AbstractGunItem) || (ammoContainer = (gunItem = (AbstractGunItem)smallMagazine).getAmmoContainer(stack)).size() > 75) break;
                stack.set(ModDataComponents.AMMO_CONTAINER, (Object)ammoContainer.addNewBullet(rod, 25));
                rod.shrink(1);
            }
        }
    }

    private void rifleZoomBehaviour(ItemStack stack, Level level, Player player) {
        if (stack == null || level == null || player == null) {
            return;
        }
        try {
            boolean shouldScope;
            boolean inHand = false;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack handItem = player.getItemInHand(hand);
                if (handItem.isEmpty() || handItem.getItem() != ModItems.RIFLEWITHSPYGLASS.get()) continue;
                inHand = true;
                break;
            }
            if (!inHand) {
                if (((Boolean)player.getData(ModDataAttachments.SCOPING.get())).booleanValue()) {
                    player.setData(ModDataAttachments.SCOPING.get(), (Object)false);
                    if (!level.isClientSide && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new S2C_ScopingDataPacket(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
                return;
            }
            boolean currentlyScoping = (Boolean)player.getData(ModDataAttachments.SCOPING.get());
            boolean bl = shouldScope = player.isShiftKeyDown() && !this.isReloading(stack) && !AbstractGunItem.holdingInnaporatedItem(player) && !player.getCooldowns().isOnCooldown(stack.getItem());
            if (currentlyScoping != shouldScope) {
                player.setData(ModDataAttachments.SCOPING.get(), (Object)shouldScope);
                if (!level.isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new S2C_ScopingDataPacket(shouldScope), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (level.isClientSide) {
                    player.playSound(shouldScope ? SoundEvents.SPYGLASS_USE : SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setReloading(ItemStack gun) {
        gun.set(ModDataComponents.RELOADING, (Object)true);
    }

    public void removeReloading(ItemStack gun) {
        gun.set(ModDataComponents.RELOADING, (Object)false);
    }

    public boolean isReloading(ItemStack gun) {
        return (Boolean)gun.getOrDefault(ModDataComponents.RELOADING, (Object)false);
    }

    public boolean isBlocking(ItemStack gun) {
        return (Boolean)gun.getOrDefault(ModDataComponents.BLOCKED_ATTACK, (Object)false);
    }

    public static boolean holdingGunWeapon(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            if (!(player.getItemInHand(hand).getItem() instanceof AbstractGunItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean holdingGunButNotRevolverWeapon(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            AbstractGunItem abstractGunItem;
            Item item = player.getItemInHand(hand).getItem();
            if (!(item instanceof AbstractGunItem) || (abstractGunItem = (AbstractGunItem)item).weaponType() == WeaponType.REVOLVER) continue;
            return true;
        }
        return false;
    }

    public static boolean holdingInnaporatedItem(Player player) {
        if (player.getMainHandItem().is(ModItems.REVOLVER.get()) && player.getOffhandItem().is(ModItems.REVOLVER.get()) || player.getMainHandItem().is(ModItems.REVOLVER.get()) && player.getOffhandItem().is(Items.TOTEM_OF_UNDYING) || player.getMainHandItem().is(Items.TOTEM_OF_UNDYING) && player.getOffhandItem().is(ModItems.REVOLVER.get())) {
            return false;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            if (!player.getItemInHand(hand).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isGun(ItemStack s) {
        return s.getItem() instanceof AbstractGunItem;
    }

    private static boolean isRevolver(ItemStack s) {
        AbstractGunItem g;
        Item item = s.getItem();
        return item instanceof AbstractGunItem && (g = (AbstractGunItem)item).weaponType() == WeaponType.REVOLVER;
    }

    private static InteractionHand other(InteractionHand h) {
        return h == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    private static boolean canFireState(Player player, InteractionHand firingHand, WeaponType weaponType) {
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        boolean mainGun = AbstractGunItem.isGun(main);
        boolean offGun = AbstractGunItem.isGun(off);
        if (mainGun && offGun) {
            return AbstractGunItem.isRevolver(main) && AbstractGunItem.isRevolver(off);
        }
        if (mainGun ^ offGun) {
            InteractionHand otherHand = AbstractGunItem.other(firingHand);
            ItemStack otherStack = player.getItemInHand(otherHand);
            if (weaponType == WeaponType.REVOLVER) {
                return otherStack.isEmpty() || otherStack.is(Items.TOTEM_OF_UNDYING);
            }
            return otherStack.isEmpty();
        }
        return false;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return false;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack;
    }

    public boolean canGrindstoneRepair(ItemStack stack) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(ModItems.REPAIRKIT.get());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

