/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.item.custom;

import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.core.AmmoContainerRecord;
import com.f708.anothergunmod.core.enums.AmmoType;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.interfaces.IMeleeGun;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.utils.GunUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MachineGun
extends AbstractGunItem
implements IMeleeGun {
    public MachineGun(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int rangedDamage(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.DAMAGE, (Object)ModConfig.getMachinegunDamage());
    }

    @Override
    public int bulletAmountPerShot(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.BULLETS_PER_SHOT, (Object)1);
    }

    @Override
    public int maxAmmo(ItemStack gun) {
        return (Boolean)gun.getOrDefault(ModDataComponents.BIGMAGAZINEATTACHED, (Object)false) != false ? 64 : 32;
    }

    @Override
    public int recoil(ItemStack gun) {
        int tripod = (Boolean)gun.getOrDefault(ModDataComponents.IS_SUPPORTED, (Object)false) != false ? 4 : 1;
        return (Integer)gun.getOrDefault(ModDataComponents.RECOIL, (Object)ModConfig.getMachinegunRecoil()) / tripod;
    }

    @Override
    public int fireRate(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.FIRE_RATE, (Object)ModConfig.getMachinegunFireRate());
    }

    @Override
    public int reloadTime(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.RELOAD_TIME, (Object)ModConfig.getMachinegunReloadTime());
    }

    @Override
    public WeaponType weaponType() {
        return WeaponType.MACHINEGUN;
    }

    @Override
    public AmmoType ammoType() {
        return AmmoType.BULLET;
    }

    @Override
    public boolean magazineAttached(ItemStack gun) {
        return (Boolean)gun.getOrDefault(ModDataComponents.MAGAZINEATTACHED, (Object)false) != false || (Boolean)gun.getOrDefault(ModDataComponents.BIGMAGAZINEATTACHED, (Object)false) != false;
    }

    public boolean bigMagazineAttached(ItemStack gun) {
        return (Boolean)gun.getOrDefault(ModDataComponents.BIGMAGAZINEATTACHED, (Object)false);
    }

    @Override
    public boolean isAmmoEmpty(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return ammoContainer.isEmpty();
    }

    @Override
    public boolean canShoot(ItemStack gun, Player player) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return !ammoContainer.isEmpty() && this.magazineAttached(gun) || player.isCreative();
    }

    @Override
    public boolean isMaxAmmo(ItemStack gun) {
        return this.getAmmoContainer(gun).isFull();
    }

    @Override
    public void descreaseAmmo(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        if (!this.isAmmoEmpty(gun)) {
            AmmoContainerRecord.setContainerToComponent(gun, ammoContainer.removeBullet());
        }
    }

    @Override
    public int getAmmo(ItemStack gun) {
        if (((Boolean)gun.getOrDefault(ModDataComponents.MAGAZINEATTACHED, (Object)false)).booleanValue()) {
            AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
            return ammoContainer.size();
        }
        return 0;
    }

    @Override
    public void shoot(Player player, ItemStack stack) {
        GunUtils.performBulletSpawn(player, player.level(), stack);
        GunUtils.triggerRecoil(player, stack);
    }

    @Override
    public void reload(Player player, ItemStack stack) {
        AbstractGunItem abstractGunItem = (AbstractGunItem)stack.getItem();
        player.getCooldowns().addCooldown(stack.getItem(), abstractGunItem.reloadTime(stack));
        abstractGunItem.setReloading(stack);
    }
}

