/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.item.custom;

import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.core.AmmoContainerRecord;
import com.f708.anothergunmod.core.enums.AmmoType;
import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.core.interfaces.IGun;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.utils.GunUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class Revolver
extends AbstractGunItem
implements IGun {
    public Revolver(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int rangedDamage(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.DAMAGE, (Object)ModConfig.getRevolverDamage());
    }

    @Override
    public int reloadTime(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.RELOAD_TIME, (Object)ModConfig.getRevolverReloadTime());
    }

    @Override
    public int bulletAmountPerShot(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.BULLETS_PER_SHOT, (Object)1);
    }

    @Override
    public int maxAmmo(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.MAX_AMMO, (Object)6);
    }

    @Override
    public int recoil(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.RECOIL, (Object)ModConfig.getRevolverRecoil());
    }

    @Override
    public int fireRate(ItemStack gun) {
        return (Integer)gun.getOrDefault(ModDataComponents.FIRE_RATE, (Object)ModConfig.getRevolverFireRate());
    }

    @Override
    public int getAmmo(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        return ammoContainer.size();
    }

    @Override
    public WeaponType weaponType() {
        return WeaponType.REVOLVER;
    }

    @Override
    public AmmoType ammoType() {
        return AmmoType.BULLET;
    }

    @Override
    public boolean magazineAttached(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isAmmoEmpty(ItemStack stack) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(stack);
        return ammoContainer.isEmpty();
    }

    @Override
    public boolean canShoot(ItemStack stack, Player player) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(stack);
        return !ammoContainer.isEmpty() || player.isCreative();
    }

    @Override
    public boolean isMaxAmmo(ItemStack gun) {
        return this.getAmmoContainer(gun).isFull();
    }

    @Override
    public void descreaseAmmo(ItemStack gun) {
        AmmoContainerRecord ammoContainer = this.getAmmoContainer(gun);
        if (!this.isAmmoEmpty(gun)) {
            AmmoContainerRecord.setContainerToComponent(gun, ammoContainer.removeBullet());
        }
    }

    public void reloadAmmo(ItemStack stack) {
        int cur = (Integer)stack.getOrDefault(ModDataComponents.EMPTY_AMMO, (Object)0);
        if (cur < this.maxAmmo(stack) + 1) {
            stack.set(ModDataComponents.EMPTY_AMMO, (Object)(cur + 1));
        }
    }

    public boolean gotEmptyAmmo(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.EMPTY_AMMO, (Object)0) < this.maxAmmo(stack);
    }

    @Override
    public void shoot(Player player, ItemStack stack) {
        GunUtils.performBulletSpawn(player, player.level(), stack);
        GunUtils.triggerRecoil(player, stack);
    }

    @Override
    public void reload(Player player, ItemStack stack) {
        AbstractGunItem abstractGunItem = (AbstractGunItem)stack.getItem();
        if (!abstractGunItem.isMaxAmmo(stack) && GunUtils.containItem(player, ModItems.SMALLBULLET.get())) {
            player.getCooldowns().addCooldown(stack.getItem(), abstractGunItem.reloadTime(stack));
            abstractGunItem.setReloading(stack);
        }
    }

    @Override
    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }
}

