/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.item.custom.magazine;

import com.f708.anothergunmod.config.ModConfig;
import com.f708.anothergunmod.core.AmmoContainerRecord;
import com.f708.anothergunmod.data.ModDataComponents;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.magazine.AbstractMagazine;
import com.f708.anothergunmod.sounds.ModSounds;
import com.f708.anothergunmod.utils.GunUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BigMagazine
extends AbstractMagazine {
    public BigMagazine(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getAmmo(ItemStack magazine) {
        AmmoContainerRecord container = AmmoContainerRecord.getBigContainerFromComponent(magazine);
        return container.size();
    }

    public boolean isFull(ItemStack magazine) {
        return AmmoContainerRecord.getBigContainerFromComponent(magazine).isFull();
    }

    @Override
    public int getMaxAmmo() {
        return 64;
    }

    @Override
    public boolean isEmpty(ItemStack magazine) {
        AmmoContainerRecord container = AmmoContainerRecord.getBigContainerFromComponent(magazine);
        return container.isEmpty();
    }

    @Override
    public void reload(Player player, ItemStack magazine) {
        int bulletsMag = this.getAmmo(magazine);
        if (GunUtils.containItem(player, ModItems.SMALLBULLET.get())) {
            int slot;
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return;
            }
            if (bulletsMag < this.getMaxAmmo() && (slot = GunUtils.getItemSlot(player, ModItems.SMALLBULLET.get())) != -1) {
                ItemStack bulletStack = player.getInventory().getItem(slot);
                bulletStack.shrink(1);
                AmmoContainerRecord container = AmmoContainerRecord.getBigContainerFromComponent(magazine);
                magazine.set(ModDataComponents.AMMO_CONTAINER, (Object)container.addNewBullet(bulletStack));
                player.getCooldowns().addCooldown((Item)this, ModConfig.getMagazineReloadTime());
                player.level().playSound(null, new BlockPos(player.getBlockX(), player.getBlockY() + 1, player.getBlockZ()), ModSounds.MAGAZINE_INSERT.get(), SoundSource.MASTER, 0.2f, 1.0f);
            }
        }
    }
}

