/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.item.custom.mechanics;

import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.registry.item.ModItems;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.utils.GunUtils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class DualWieldRevolverState {
    private static final ConcurrentHashMap<UUID, InteractionHand> NEXT_SHOT = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, InteractionHand> NEXT_RELOAD = new ConcurrentHashMap();

    private DualWieldRevolverState() {
    }

    public static InteractionHand getNextShotHand(Player p) {
        return NEXT_SHOT.getOrDefault(p.getUUID(), InteractionHand.MAIN_HAND);
    }

    public static void toggleAfterShot(Player p) {
        InteractionHand cur = DualWieldRevolverState.getNextShotHand(p);
        NEXT_SHOT.put(p.getUUID(), cur == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
    }

    public static InteractionHand pickHandToFire(Player p, ItemStack main, ItemStack off) {
        InteractionHand other;
        InteractionHand pref = DualWieldRevolverState.getNextShotHand(p);
        if (DualWieldRevolverState.isUsableRevolver(p, DualWieldRevolverState.stackBy(p, pref))) {
            return pref;
        }
        InteractionHand interactionHand = other = pref == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (DualWieldRevolverState.isUsableRevolver(p, DualWieldRevolverState.stackBy(p, other))) {
            return other;
        }
        return pref;
    }

    public static InteractionHand getNextReloadHand(Player p) {
        return NEXT_RELOAD.getOrDefault(p.getUUID(), InteractionHand.MAIN_HAND);
    }

    public static void toggleAfterReload(Player p) {
        InteractionHand cur = DualWieldRevolverState.getNextReloadHand(p);
        NEXT_RELOAD.put(p.getUUID(), cur == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
    }

    public static InteractionHand pickHandToReload(Player p, ItemStack main, ItemStack off) {
        InteractionHand other;
        InteractionHand pref = DualWieldRevolverState.getNextReloadHand(p);
        if (DualWieldRevolverState.isReloadableRevolver(p, DualWieldRevolverState.stackBy(p, pref))) {
            return pref;
        }
        InteractionHand interactionHand = other = pref == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (DualWieldRevolverState.isReloadableRevolver(p, DualWieldRevolverState.stackBy(p, other))) {
            return other;
        }
        return null;
    }

    private static ItemStack stackBy(Player p, InteractionHand h) {
        return p.getItemInHand(h);
    }

    private static boolean isUsableRevolver(Player p, ItemStack s) {
        Item item = s.getItem();
        if (!(item instanceof AbstractGunItem)) {
            return false;
        }
        AbstractGunItem g = (AbstractGunItem)item;
        if (g.weaponType() != WeaponType.REVOLVER) {
            return false;
        }
        return g.canShoot(s, p) && !g.isReloading(s);
    }

    private static boolean isReloadableRevolver(Player p, ItemStack s) {
        Item item = s.getItem();
        if (!(item instanceof AbstractGunItem)) {
            return false;
        }
        AbstractGunItem g = (AbstractGunItem)item;
        if (g.weaponType() != WeaponType.REVOLVER) {
            return false;
        }
        return !g.isMaxAmmo(s) && GunUtils.containItem(p, ModItems.SMALLBULLET.get()) && !p.getCooldowns().isOnCooldown(s.getItem());
    }
}

