/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.particle.ammo;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class AmmoParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public AmmoParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(level, x, y, z, vx, vy, vz);
        this.spriteSet = spriteSet;
        this.gravity = 1.0f;
        this.friction = 1.0f;
        this.hasPhysics = true;
        this.lifetime = 100 + this.random.nextInt(10);
        this.setSize(0.1f, 0.1f);
        this.quadSize = 0.1f;
        this.setAlpha(1.0f);
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        super.tick();
        if (!this.onGround) {
            this.oRoll = this.roll;
            this.roll += 0.3f;
        } else {
            this.oRoll = this.roll;
        }
        float fadeStart = 0.7f;
        if ((float)this.age > (float)this.lifetime * fadeStart) {
            float fadeProgress = ((float)this.age - (float)this.lifetime * fadeStart) / ((float)this.lifetime * (1.0f - fadeStart));
            this.setAlpha(1.0f - fadeProgress);
        }
        this.setSpriteFromAge(this.spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }
}

