/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.particle.ammo;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class AmmoParticleBuilder {
    private AmmoParticleBuilder() {
    }

    public static void spawn(Player player, InteractionHand hand, double speed, ParticleOptions modParticleTypes) {
        ParticleEngine engine = Minecraft.getInstance().particleEngine;
        HumanoidArm mainArm = player.getMainArm();
        boolean isRightHand = hand == InteractionHand.MAIN_HAND && mainArm == HumanoidArm.RIGHT || hand == InteractionHand.OFF_HAND && mainArm == HumanoidArm.LEFT;
        double yaw = Math.toRadians(player.getYRot());
        Vec3 forward = new Vec3(-Math.sin(yaw), 0.0, Math.cos(yaw));
        Vec3 right = new Vec3(forward.z, 0.0, -forward.x);
        Vec3 sideDir = right.scale(isRightHand ? -1.0 : 1.0);
        Vec3 basePos = player.getEyePosition().add(0.0, -0.2, 0.0);
        Vec3 pos = basePos.add(sideDir.scale(0.5));
        pos = pos.add(forward.normalize().scale(0.3));
        Vec3 velocity = sideDir.normalize().scale(speed).add(0.0, 0.15, 0.0);
        engine.createParticle(modParticleTypes, pos.x, pos.y, pos.z, velocity.x, velocity.y, velocity.z);
    }

    public static void spawnFromEntity(Entity shooter, Vec3 velocity, ParticleOptions particleType) {
        ParticleEngine engine = Minecraft.getInstance().particleEngine;
        Vec3 pos = shooter.position().add(0.0, (double)shooter.getBbHeight() * 0.5, 0.0);
        Vec3 right = new Vec3(-velocity.z, 0.0, velocity.x).normalize();
        Vec3 spawnPos = pos.add(right.scale(0.3));
        Vec3 particleVel = right.scale(0.8).add(0.0, 0.15, 0.0);
        engine.createParticle(particleType, spawnPos.x, spawnPos.y, spawnPos.z, particleVel.x, particleVel.y, particleVel.z);
    }
}

