/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.particle.flame;

import com.f708.anothergunmod.registry.particle.flame.FlameJetParams;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.FluidState;

public class FlamePuffParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final double dirX;
    private final double dirY;
    private final double dirZ;
    private final float baseSpeed;
    private final float startAngularVel;
    private float angularVel;
    private final float rotationDir;
    private boolean hasSmokeSpawned = false;

    protected FlamePuffParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.sprites = sprites;
        this.lifetime = FlameJetParams.PARTICLE_LIFETIME;
        this.hasPhysics = true;
        this.gravity = FlameJetParams.PARTICLE_GRAVITY;
        this.friction = 1.0f;
        double len = Math.sqrt(vx * vx + vy * vy + vz * vz);
        if (len > 1.0E-6) {
            this.dirX = vx / len;
            this.dirY = vy / len;
            this.dirZ = vz / len;
            this.baseSpeed = (float)len;
        } else {
            this.dirX = 0.0;
            this.dirY = 0.0;
            this.dirZ = 0.0;
            this.baseSpeed = 0.0f;
        }
        this.alpha = 0.0f;
        this.quadSize = FlameJetParams.PARTICLE_SIZE_START;
        this.setColor(1.0f, 0.9f, 0.9f);
        Random r = new Random();
        this.rotationDir = r.nextBoolean() ? 1.0f : -1.0f;
        this.angularVel = this.startAngularVel = 20.0f + r.nextFloat() * 10.0f;
        this.setSpriteFromAge(sprites);
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.oRoll = this.roll;
        this.roll += this.rotationDir * this.angularVel * 0.004363323f;
        BlockPos currentPos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        FluidState fluidState = this.level.getFluidState(currentPos);
        if (fluidState.is(FluidTags.WATER)) {
            this.level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.x, this.y, this.z, this.xd * 0.1, Math.abs(this.yd) * 0.5 + 0.1, this.zd * 0.1);
            this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.3f, 1.0f + (this.level.random.nextFloat() - 0.5f) * 0.4f, false);
            this.remove();
            return;
        }
        float t = (float)this.age / (float)this.lifetime;
        if (!this.hasSmokeSpawned && t >= 0.6f) {
            this.spawnSmokeParticle();
            this.hasSmokeSpawned = true;
        }
        float f = FlameJetParams.speedFactor(t);
        double vx = this.dirX * (double)(this.baseSpeed * f);
        double vy = this.dirY * (double)(this.baseSpeed * f);
        double vz = this.dirZ * (double)(this.baseSpeed * f);
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.yd += (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.quadSize = Mth.lerp((float)t, (float)FlameJetParams.PARTICLE_SIZE_START, (float)FlameJetParams.PARTICLE_SIZE_END);
        if (this.age <= 1) {
            this.alpha = 0.0f;
        } else if (t <= FlameJetParams.PARTICLE_OPACITY_FULL_UNTIL) {
            this.alpha = 0.7f;
        } else {
            float k = (t - FlameJetParams.PARTICLE_OPACITY_FULL_UNTIL) / (1.0f - FlameJetParams.PARTICLE_OPACITY_FULL_UNTIL);
            this.alpha = 0.7f * (1.0f - Mth.clamp((float)k, (float)0.0f, (float)1.0f));
        }
        this.setSpriteFromAge(this.sprites);
    }

    private void spawnSmokeParticle() {
        Random r = new Random();
        double offsetX = (r.nextDouble() - 0.5) * 0.05;
        double offsetY = (r.nextDouble() - 0.5) * 0.05;
        double offsetZ = (r.nextDouble() - 0.5) * 0.05;
        double velX = (r.nextDouble() - 0.5) * 0.01;
        double velY = 0.02 + r.nextDouble() * 0.01;
        double velZ = (r.nextDouble() - 0.5) * 0.01;
        this.level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.x + offsetX, this.y + offsetY, this.z + offsetZ, velX, velY, velZ);
        this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.x + offsetX, this.y + offsetY, this.z + offsetZ, velX, velY, velZ);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            return new FlamePuffParticle(level, x, y, z, vx, vy, vz, this.sprites);
        }
    }
}

