/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.particle.smoke;

import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.f708.anothergunmod.registry.particle.smoke.MuzzleSmokeParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class MuzzleSmokeEmitter {
    private MuzzleSmokeEmitter() {
    }

    public static void spawnBurst(Player player, ParticleOptions type, double baseSpeed, double fromEyesDist, InteractionHand hand) {
        Particle c;
        Particle b;
        Vec3 base;
        if (player == null) {
            return;
        }
        ParticleEngine engine = Minecraft.getInstance().particleEngine;
        if (engine == null) {
            return;
        }
        boolean isRightSide = player.getMainArm() == HumanoidArm.RIGHT && hand == InteractionHand.MAIN_HAND || player.getMainArm() == HumanoidArm.LEFT && hand == InteractionHand.OFF_HAND;
        double sideSign = isRightSide ? 1.0 : -1.0;
        Vec3 look = player.getLookAngle().normalize();
        Vec3 right = MuzzleSmokeEmitter.computeRightVector(player);
        double lateralOffset = 0.22;
        double yOffset = -0.3;
        double step = 0.0625;
        Vec3 p0 = base = player.getEyePosition(0.0f).add(look.scale(fromEyesDist)).add(0.0, yOffset, 0.0).add(right.scale(sideSign * lateralOffset));
        Vec3 p1 = p0.add(look.scale(step));
        Vec3 p2 = p1.add(look.scale(step));
        Vec3 v0 = look.scale(baseSpeed * 1.3);
        Vec3 v1 = look.scale(baseSpeed);
        Vec3 v2 = look.scale(baseSpeed * 0.8);
        Particle a = engine.createParticle(type, p0.x, p0.y, p0.z, v0.x, v0.y, v0.z);
        if (a instanceof MuzzleSmokeParticle) {
            MuzzleSmokeParticle s = (MuzzleSmokeParticle)a;
            s.withSizeMultiplier(1.4f);
        }
        if ((b = engine.createParticle(type, p1.x, p1.y, p1.z, v1.x, v1.y, v1.z)) instanceof MuzzleSmokeParticle) {
            MuzzleSmokeParticle s = (MuzzleSmokeParticle)b;
            s.withSizeMultiplier(1.0f);
        }
        if ((c = engine.createParticle(type, p2.x, p2.y, p2.z, v2.x, v2.y, v2.z)) instanceof MuzzleSmokeParticle) {
            MuzzleSmokeParticle s = (MuzzleSmokeParticle)c;
            s.withSizeMultiplier(0.6f);
        }
    }

    private static Vec3 computeRightVector(Player player) {
        Vec3 up;
        Vec3 view = player.getViewVector(0.0f).normalize();
        Vec3 right = view.cross(up = new Vec3(0.0, 1.0, 0.0));
        double len = right.length();
        if (len < 1.0E-4) {
            double yawRad = Math.toRadians(player.getYRot());
            right = new Vec3(-Math.cos(yawRad), 0.0, -Math.sin(yawRad));
        } else {
            right = right.scale(1.0 / len);
        }
        return right;
    }

    private static InteractionHand guessGunHand(Player player) {
        for (InteractionHand h : InteractionHand.values()) {
            if (!(player.getItemInHand(h).getItem() instanceof AbstractGunItem)) continue;
            return h;
        }
        return null;
    }
}

