/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.registry.particle.smoke;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class MuzzleSmokeParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final int totalFrames = 4;
    private int currentFrame = 0;
    private int frameTimer = 0;
    private final float baseSize = 0.5f;
    private float sizeMul = 1.0f;
    private float startAlpha = 0.7f;
    private final float fadeStart = 0.7f;

    public MuzzleSmokeParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.spriteSet = spriteSet;
        this.gravity = 0.0f;
        this.lifetime = 20;
        this.setSprite(spriteSet.get(0, 3));
        this.startAlpha = 0.5f;
        this.setAlpha(this.startAlpha);
        this.quadSize = 0.5f;
        this.setSize(0.5f, 0.5f);
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
    }

    public MuzzleSmokeParticle withSizeMultiplier(float mul) {
        this.sizeMul = mul;
        this.quadSize = 0.5f * mul;
        this.setSize(this.quadSize, this.quadSize);
        return this;
    }

    public MuzzleSmokeParticle withLifetime(int lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.updateFrame();
        float lifeFrac = (float)this.age / (float)this.lifetime;
        this.quadSize = 0.5f * this.sizeMul * (1.0f + 0.25f * lifeFrac);
        if (lifeFrac >= 0.7f) {
            float t = (lifeFrac - 0.7f) / 0.3f;
            this.setAlpha(Mth.clamp((float)(this.startAlpha * (1.0f - t)), (float)0.0f, (float)1.0f));
        }
        this.xd *= (double)0.94f;
        this.yd *= (double)0.96f;
        this.zd *= (double)0.94f;
        this.move(this.xd, this.yd, this.zd);
    }

    private void updateFrame() {
        ++this.frameTimer;
        int ticksPerFrame = Math.max(1, this.lifetime / 4);
        if (this.frameTimer >= ticksPerFrame) {
            this.frameTimer = 0;
            this.currentFrame = Math.min(this.currentFrame + 1, 3);
            this.setSprite(this.spriteSet.get(this.currentFrame, 3));
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new MuzzleSmokeParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

