/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.sounds;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;

public final class SoundUtil {
    private static final RandomSource RAND = RandomSource.create();

    private SoundUtil() {
    }

    public static void playFirstPerson(SoundEvent sound, float volume, float pitch) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        mc.getSoundManager().play((SoundInstance)new SimpleSoundInstance(sound.getLocation(), SoundSource.PLAYERS, volume, pitch, RAND, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
    }

    public static void playAtPlayer3D(Minecraft mc, Player p, SoundEvent sound, float volume, float pitch) {
        mc.level.playLocalSound(p.getX(), p.getY(), p.getZ(), sound, SoundSource.PLAYERS, volume, pitch, false);
    }

    public static float randPitch(float min, float max) {
        return min + RAND.nextFloat() * (max - min);
    }

    public static float fadeByDistanceSqr(double d2, double min2, double max2) {
        if (d2 <= min2) {
            return 1.0f;
        }
        if (d2 >= max2) {
            return 0.0f;
        }
        return (float)(1.0 - (d2 - min2) / (max2 - min2));
    }
}

