/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.utils;

import com.f708.anothergunmod.utils.ModTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ArmorUtils {
    private ArmorUtils() {
    }

    public static int getTotalArmor(Player player) {
        return player.getArmorValue();
    }

    public static int getTotalArmorExcludingIgnored(Player player) {
        int sum = 0;
        sum += ArmorUtils.armorFromSlot(player, EquipmentSlot.HEAD);
        sum += ArmorUtils.armorFromSlot(player, EquipmentSlot.CHEST);
        sum += ArmorUtils.armorFromSlot(player, EquipmentSlot.LEGS);
        return sum += ArmorUtils.armorFromSlot(player, EquipmentSlot.FEET);
    }

    private static int armorFromSlot(Player player, EquipmentSlot slot) {
        ArmorItem armor;
        ItemStack stack = player.getItemBySlot(slot);
        if (stack.isEmpty() || stack.is(ModTags.Items.IGNORED_ARMOUR)) {
            return 0;
        }
        Item item = stack.getItem();
        if (item instanceof ArmorItem && (armor = (ArmorItem)item).getEquipmentSlot() == slot) {
            return armor.getDefense();
        }
        return 0;
    }

    public static float getRecoilMultiplierFromArmor(Player player) {
        return ArmorUtils.mapArmorExp(player, 1.0f, 1.5f, 1.5f);
    }

    public static float getSpreadYawMultiplierFromArmor(Player player) {
        return ArmorUtils.mapArmorExp(player, 1.0f, 3.0f, 2.2f);
    }

    public static float shotgunKnockbackMultiplier(Player player) {
        return ArmorUtils.mapArmorExp(player, 1.0f, 0.1f, 2.5f);
    }

    private static float curveExp01(float t, float k) {
        if (k == 0.0f) {
            return t;
        }
        return (float)(Math.expm1(k * t) / Math.expm1(k));
    }

    private static float mapArmorExp(int armor, float atZeroArmor, float atMaxArmor, float k) {
        float t = Mth.clamp((float)((float)armor / 20.0f), (float)0.0f, (float)1.0f);
        float u = ArmorUtils.curveExp01(t, k);
        return Mth.lerp((float)u, (float)atZeroArmor, (float)atMaxArmor);
    }

    private static float mapArmorExp(Player player, float atZeroArmor, float atMaxArmor, float k) {
        return ArmorUtils.mapArmorExp(ArmorUtils.getTotalArmorExcludingIgnored(player), atZeroArmor, atMaxArmor, k);
    }
}

