/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.utils;

import com.f708.anothergunmod.core.enums.WeaponType;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="anothergunmod", value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class CameraUtils {
    private static int elapsedTicks = 0;
    private static int shakeDuration = 0;
    private static float shakeIntensity = 0.0f;
    private static int waveCount = 3;
    private static final boolean RH = false;
    private static float decayRate = 0.5f;
    private static final Random random = new Random();
    private static int reloadSwayTicks = 0;
    private static int reloadSwayDuration = 0;
    private static float reloadSwayIntensity = 0.0f;
    private static String reloadSwayPattern = "default";
    private static final Map<UUID, RecoilData> playerRecoilMap = new HashMap<UUID, RecoilData>();
    private static float recoilProgress = 0.0f;
    private static float lastRecoilProgress = 0.0f;

    public static void triggerReloadSway(WeaponType weaponType, int duration) {
        reloadSwayDuration = duration;
        reloadSwayTicks = 0;
        switch (weaponType) {
            case REVOLVER: {
                reloadSwayIntensity = 1.0f;
                reloadSwayPattern = "spin";
                break;
            }
            case RIFLE: {
                reloadSwayIntensity = 0.8f;
                reloadSwayPattern = "tactical";
                break;
            }
            case SHOTGUN: {
                reloadSwayIntensity = 1.2f;
                reloadSwayPattern = "pump";
                break;
            }
            case AUTOGUN: 
            case MACHINEGUN: {
                reloadSwayIntensity = 0.6f;
                reloadSwayPattern = "magazine";
                break;
            }
            case FLAMETHROWER: {
                reloadSwayIntensity = 0.9f;
                reloadSwayPattern = "heavy";
                break;
            }
            default: {
                reloadSwayIntensity = 0.7f;
                reloadSwayPattern = "default";
            }
        }
    }

    public static void triggerCameraShake(int duration, float intensity, int waves, float decay) {
        decayRate = decay;
        shakeIntensity = intensity;
        waveCount = waves;
        int fps = Minecraft.getInstance().getFps();
        float scalingFactor = (float)fps / 60.0f;
        shakeDuration = (int)((float)duration * scalingFactor);
        elapsedTicks = 0;
    }

    @SubscribeEvent
    public static void computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        if (elapsedTicks < shakeDuration) {
            float t = (float)elapsedTicks / (float)shakeDuration;
            float frequency = (float)waveCount * 2.0f;
            float amplitude = (float)((double)shakeIntensity * Math.exp(-decayRate * t));
            float wave = (float)Math.sin((double)t * Math.PI * (double)frequency);
            float pitchOffset = wave * amplitude * (float)(random.nextBoolean() ? 1 : -1);
            float yawOffset = -wave * amplitude * (float)(random.nextBoolean() ? 1 : -1);
            float rollOffset = -wave * amplitude * (float)(random.nextBoolean() ? 1 : -1);
            event.setPitch(event.getPitch() + pitchOffset);
            event.setYaw(event.getYaw() + yawOffset);
            event.setRoll(event.getRoll() + rollOffset);
            ++elapsedTicks;
        }
        CameraUtils.applyReloadSway(event, (float)event.getPartialTick());
    }

    private static void applyReloadSway(ViewportEvent.ComputeCameraAngles event, float partialTick) {
        if (reloadSwayTicks >= reloadSwayDuration) {
            return;
        }
        float t = ((float)reloadSwayTicks + partialTick) / (float)reloadSwayDuration;
        float intensity = reloadSwayIntensity;
        float pitchOffset = 0.0f;
        float yawOffset = 0.0f;
        float rollOffset = 0.0f;
        switch (reloadSwayPattern) {
            case "spin": {
                float spinWave = (float)Math.sin((double)t * Math.PI * 2.0);
                pitchOffset = spinWave * intensity * 0.4f;
                yawOffset = (float)Math.sin((double)t * Math.PI * 3.0) * intensity * 0.8f;
                rollOffset = spinWave * intensity * 0.3f;
                break;
            }
            case "tactical": {
                float tacticalSway = (float)Math.sin((double)t * Math.PI * 1.5);
                pitchOffset = (float)Math.sin((double)t * Math.PI) * intensity * 0.3f;
                yawOffset = tacticalSway * intensity * 0.6f;
                rollOffset = tacticalSway * intensity * 0.2f;
                break;
            }
            case "pump": {
                if (t < 0.3f) {
                    pitchOffset = (float)Math.sin((double)(t / 0.3f) * Math.PI) * intensity * 0.5f;
                    break;
                }
                if (!(t > 0.6f) || !(t < 0.8f)) break;
                float pumpT = (t - 0.6f) / 0.2f;
                pitchOffset = (float)Math.sin((double)pumpT * Math.PI) * intensity * -0.8f;
                rollOffset = (float)Math.sin((double)pumpT * Math.PI) * intensity * 0.4f;
                break;
            }
            case "magazine": {
                float magWave = (float)Math.sin((double)t * Math.PI * 2.5);
                pitchOffset = magWave * intensity * 0.3f;
                yawOffset = (float)Math.sin((double)t * Math.PI * 2.0) * intensity * 0.4f;
                rollOffset = magWave * intensity * 0.25f;
                break;
            }
            case "heavy": {
                float heavySway = (float)Math.sin((double)t * Math.PI * (double)1.2f);
                pitchOffset = (float)Math.sin((double)t * Math.PI * (double)0.8f) * intensity * 0.6f;
                yawOffset = heavySway * intensity * 0.5f;
                rollOffset = heavySway * intensity * 0.4f;
                break;
            }
            default: {
                float defaultWave = (float)Math.sin((double)t * Math.PI * 2.0);
                pitchOffset = (float)Math.sin((double)t * Math.PI) * intensity * 0.3f;
                yawOffset = defaultWave * intensity * 0.5f;
                rollOffset = defaultWave * intensity * 0.2f;
            }
        }
        float fadeOut = 1.0f - t * t;
        event.setPitch(event.getPitch() + pitchOffset * fadeOut);
        event.setYaw(event.getYaw() + yawOffset * fadeOut);
        event.setRoll(event.getRoll() + rollOffset * fadeOut);
    }

    public static void triggerRecoil(Player player, int duration, float pitchAngle, float maxYawAngle) {
        if (player.level().isClientSide) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && mc.player.getUUID().equals(player.getUUID())) {
                UUID playerId = player.getUUID();
                float isCrouching = player.isCrouching() ? 0.7f : 1.0f;
                float randomYaw = maxYawAngle * (float)(player.level().random.nextBoolean() ? 1 : -1);
                playerRecoilMap.put(playerId, new RecoilData(duration, pitchAngle * isCrouching, randomYaw *= 0.7f + player.level().random.nextFloat() * 0.3f));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player;
        if (event.getEntity().level().isClientSide && (player = event.getEntity()) instanceof Player) {
            Player player2 = player;
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && mc.player.getUUID().equals(player2.getUUID())) {
                UUID playerId = player2.getUUID();
                lastRecoilProgress = recoilProgress;
                if (playerRecoilMap.containsKey(playerId)) {
                    RecoilData recoilData = playerRecoilMap.get(playerId);
                    if (recoilData.elapsedTime < recoilData.totalDuration) {
                        recoilData.elapsedTime += 1.0f;
                        recoilProgress = recoilData.elapsedTime / recoilData.totalDuration;
                    } else {
                        playerRecoilMap.remove(playerId);
                        recoilProgress = 0.0f;
                        lastRecoilProgress = 0.0f;
                    }
                }
            }
            if (reloadSwayTicks < reloadSwayDuration) {
                ++reloadSwayTicks;
            }
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        UUID playerId = mc.player.getUUID();
        if (!playerRecoilMap.containsKey(playerId)) {
            return;
        }
        RecoilData recoilData = playerRecoilMap.get(playerId);
        float partialTicks = (float)event.getPartialTick();
        float interpolatedProgress = Mth.lerp((float)partialTicks, (float)lastRecoilProgress, (float)recoilProgress);
        float smoothProgress = CameraUtils.easeInOutQuad(interpolatedProgress);
        float currentPitch = recoilData.totalPitchAngle * smoothProgress;
        float currentYaw = recoilData.totalYawAngle * smoothProgress;
        float deltaPitch = currentPitch - recoilData.lastAppliedPitch;
        float deltaYaw = currentYaw - recoilData.lastAppliedYaw;
        if (Math.abs(deltaPitch) > 0.001f || Math.abs(deltaYaw) > 0.001f) {
            mc.player.setXRot(mc.player.getXRot() - deltaPitch);
            mc.player.setYRot(mc.player.getYRot() + deltaYaw);
            recoilData.lastAppliedPitch = currentPitch;
            recoilData.lastAppliedYaw = currentYaw;
        }
    }

    private static float easeInOutQuad(float x) {
        return x < 0.5f ? 2.0f * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0f;
    }

    private static class RecoilData {
        public final float totalDuration;
        public float elapsedTime;
        public final float totalPitchAngle;
        public final float totalYawAngle;
        public float lastAppliedPitch = 0.0f;
        public float lastAppliedYaw = 0.0f;

        public RecoilData(int duration, float pitchAngle, float yawAngle) {
            this.totalDuration = duration;
            this.totalPitchAngle = pitchAngle;
            this.totalYawAngle = yawAngle;
            this.elapsedTime = 0.0f;
        }
    }
}

