/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.utils;

import java.util.function.Function;

public class EasingFunctions {
    private static final float BACK_CONSTANT = 1.70158f;

    public static float linear(float t) {
        return t;
    }

    public static float lerp(float a, float b, float t) {
        return a + (b - a) * EasingFunctions.clamp(t, 0.0f, 1.0f);
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static float easeInQuad(float t) {
        return t * t;
    }

    public static float easeOutQuad(float t) {
        return 1.0f - (1.0f - t) * (1.0f - t);
    }

    public static float easeInOutQuad(float t) {
        return t < 0.5f ? 2.0f * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 2.0) / 2.0f;
    }

    public static float easeInCubic(float t) {
        return t * t * t;
    }

    public static float easeOutCubic(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 3.0);
    }

    public static float easeInOutCubic(float t) {
        return t < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
    }

    public static float easeInQuart(float t) {
        return t * t * t * t;
    }

    public static float easeOutQuart(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 4.0);
    }

    public static float easeInOutQuart(float t) {
        return t < 0.5f ? 8.0f * t * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 4.0) / 2.0f;
    }

    public static float easeInQuint(float t) {
        return t * t * t * t * t;
    }

    public static float easeOutQuint(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 5.0);
    }

    public static float easeInOutQuint(float t) {
        return t < 0.5f ? 16.0f * t * t * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 5.0) / 2.0f;
    }

    public static float easeInSine(float t) {
        return 1.0f - (float)Math.cos((double)t * Math.PI / 2.0);
    }

    public static float easeOutSine(float t) {
        return (float)Math.sin((double)t * Math.PI / 2.0);
    }

    public static float easeInOutSine(float t) {
        return -((float)(Math.cos(Math.PI * (double)t) - 1.0)) / 2.0f;
    }

    public static float easeInExpo(float t) {
        return t == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * t - 10.0f);
    }

    public static float easeOutExpo(float t) {
        return t == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * t);
    }

    public static float easeInOutExpo(float t) {
        if (t == 0.0f) {
            return 0.0f;
        }
        if (t == 1.0f) {
            return 1.0f;
        }
        return t < 0.5f ? (float)Math.pow(2.0, 20.0f * t - 10.0f) / 2.0f : (2.0f - (float)Math.pow(2.0, -20.0f * t + 10.0f)) / 2.0f;
    }

    public static float easeInCirc(float t) {
        return 1.0f - (float)Math.sqrt(1.0 - Math.pow(t, 2.0));
    }

    public static float easeOutCirc(float t) {
        return (float)Math.sqrt(1.0 - Math.pow(t - 1.0f, 2.0));
    }

    public static float easeInOutCirc(float t) {
        return t < 0.5f ? (1.0f - (float)Math.sqrt(1.0 - Math.pow(2.0f * t, 2.0))) / 2.0f : ((float)Math.sqrt(1.0 - Math.pow(-2.0f * t + 2.0f, 2.0)) + 1.0f) / 2.0f;
    }

    public static float easeInBack(float t) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return c3 * t * t * t - c1 * t * t;
    }

    public static float easeOutBack(float t) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return 1.0f + c3 * (float)Math.pow(t - 1.0f, 3.0) + c1 * (float)Math.pow(t - 1.0f, 2.0);
    }

    public static float easeInOutBack(float t) {
        float c1 = 1.70158f;
        float c2 = c1 * 1.525f;
        return t < 0.5f ? (float)Math.pow(2.0f * t, 2.0) * ((c2 + 1.0f) * 2.0f * t - c2) / 2.0f : ((float)Math.pow(2.0f * t - 2.0f, 2.0) * ((c2 + 1.0f) * (t * 2.0f - 2.0f) + c2) + 2.0f) / 2.0f;
    }

    public static float easeInElastic(float t) {
        float c4 = 2.0943952f;
        if (t == 0.0f) {
            return 0.0f;
        }
        if (t == 1.0f) {
            return 1.0f;
        }
        return -((float)Math.pow(2.0, 10.0f * t - 10.0f)) * (float)Math.sin((t * 10.0f - 10.75f) * c4);
    }

    public static float easeOutElastic(float t) {
        float c4 = 2.0943952f;
        if (t == 0.0f) {
            return 0.0f;
        }
        if (t == 1.0f) {
            return 1.0f;
        }
        return (float)Math.pow(2.0, -10.0f * t) * (float)Math.sin((t * 10.0f - 0.75f) * c4) + 1.0f;
    }

    public static float easeInOutElastic(float t) {
        float c5 = 1.3962635f;
        if (t == 0.0f) {
            return 0.0f;
        }
        if (t == 1.0f) {
            return 1.0f;
        }
        return t < 0.5f ? -((float)Math.pow(2.0, 20.0f * t - 10.0f) * (float)Math.sin((20.0f * t - 11.125f) * c5)) / 2.0f : (float)Math.pow(2.0, -20.0f * t + 10.0f) * (float)Math.sin((20.0f * t - 11.125f) * c5) / 2.0f + 1.0f;
    }

    public static float easeInBounce(float t) {
        return 1.0f - EasingFunctions.easeOutBounce(1.0f - t);
    }

    public static float easeOutBounce(float t) {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (t < 1.0f / d1) {
            return n1 * t * t;
        }
        if (t < 2.0f / d1) {
            return n1 * (t -= 1.5f / d1) * t + 0.75f;
        }
        if (t < 2.5f / d1) {
            return n1 * (t -= 2.25f / d1) * t + 0.9375f;
        }
        return n1 * (t -= 2.625f / d1) * t + 0.984375f;
    }

    public static float easeInOutBounce(float t) {
        return t < 0.5f ? (1.0f - EasingFunctions.easeOutBounce(1.0f - 2.0f * t)) / 2.0f : (1.0f + EasingFunctions.easeOutBounce(2.0f * t - 1.0f)) / 2.0f;
    }

    public static float smoothstep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static float smootherstep(float t) {
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    public static float parabolic(float t) {
        return 4.0f * t * (1.0f - t);
    }

    public static float wave(float t) {
        return (float)Math.sin((double)t * Math.PI);
    }

    public static float impulse(float t, float k) {
        float h = k * t;
        return h * (float)Math.exp(1.0f - h);
    }

    public static float cubicPulse(float t, float center, float width) {
        if ((t = Math.abs(t - center)) > width) {
            return 0.0f;
        }
        return 1.0f - (t /= width) * t * (3.0f - 2.0f * t);
    }

    public static float apply(float a, float b, float t, Function<Float, Float> easingFunction) {
        return EasingFunctions.lerp(a, b, easingFunction.apply(Float.valueOf(t)).floatValue());
    }
}

