/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.utils;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="anothergunmod")
public class TickScheduler {
    private static final Queue<ScheduledTask> SERVER_QUEUE = new ConcurrentLinkedQueue<ScheduledTask>();
    private static final Queue<ScheduledTask> CLIENT_QUEUE = new ConcurrentLinkedQueue<ScheduledTask>();

    public static void schedule(Runnable action, int ticks) {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        ScheduledTask task = new ScheduledTask(action, ticks);
        if (tg == SidedThreadGroups.SERVER) {
            SERVER_QUEUE.add(task);
        } else {
            CLIENT_QUEUE.add(task);
        }
    }

    public static void scheduleServer(Runnable action, int ticks) {
        SERVER_QUEUE.add(new ScheduledTask(action, ticks));
    }

    public static void scheduleClient(Runnable action, int ticks) {
        CLIENT_QUEUE.add(new ScheduledTask(action, ticks));
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        TickScheduler.drain(SERVER_QUEUE);
    }

    private static void drain(Queue<ScheduledTask> queue) {
        ScheduledTask task;
        int n = queue.size();
        for (int i = 0; i < n && (task = queue.poll()) != null; ++i) {
            --task.ticksRemaining;
            if (task.ticksRemaining <= 0) {
                try {
                    task.action.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                continue;
            }
            queue.offer(task);
        }
    }

    private static class ScheduledTask {
        final Runnable action;
        int ticksRemaining;

        ScheduledTask(Runnable action, int ticks) {
            this.action = action;
            this.ticksRemaining = ticks;
        }
    }

    @EventBusSubscriber(modid="anothergunmod", value={Dist.CLIENT})
    public static class ClientSide {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            TickScheduler.drain(CLIENT_QUEUE);
        }
    }
}

