/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client;

import com.f708.anothergunmod.core.enums.WeaponType;
import com.f708.anothergunmod.registry.item.custom.AbstractGunItem;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="anothergunmod", value={Dist.CLIENT})
public class CustomCrosshairRenderer {
    private static final ResourceLocation PISTOL_CROSSHAIR = ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"textures/gui/revolver_crosshair.png");
    private static final ResourceLocation RIFLE_CROSSHAIR = ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"textures/gui/sniper_crosshair.png");
    private static final ResourceLocation SHOTGUN_CROSSHAIR = ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"textures/gui/shotgun_crosshair.png");
    private static final ResourceLocation AUTOGUN_CROSSHAIR = ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"textures/gui/autogun_crosshair.png");
    private static final ResourceLocation HNSAUTOGUN_CROSSHAIR = ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"textures/gui/hns_autogun_crosshair.png");
    private static final ResourceLocation EMPTY = ResourceLocation.fromNamespaceAndPath((String)"anothergunmod", (String)"textures/gui/empty.png");

    @SubscribeEvent
    public static void onRenderCrosshair(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            Item item;
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player == null || mc.options.hideGui) {
                return;
            }
            ItemStack heldItem = player.getMainHandItem();
            if (heldItem.isEmpty()) {
                heldItem = player.getOffhandItem();
            }
            if ((item = heldItem.getItem()) instanceof AbstractGunItem) {
                AbstractGunItem gunItem = (AbstractGunItem)item;
                event.setCanceled(true);
                CustomCrosshairRenderer.renderCustomCrosshair(event.getGuiGraphics(), event.getPartialTick(), heldItem, (Player)player);
            }
        }
    }

    private static void renderCustomCrosshair(GuiGraphics guiGraphics, DeltaTracker deltaTracker, ItemStack stack, Player player) {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        AbstractGunItem gunItem = (AbstractGunItem)stack.getItem();
        ResourceLocation crosshairTexture = CustomCrosshairRenderer.getCrosshairTexture(gunItem);
        int size = 16;
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        int x = centerX - size / 2;
        int y = centerY - size / 2;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        guiGraphics.blit(crosshairTexture, x, y, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private static ResourceLocation getCrosshairTexture(AbstractGunItem gunItem) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            if (ModList.get().isLoaded("hackersandslashers")) {
                if (player.isShiftKeyDown()) {
                    return switch (gunItem.weaponType()) {
                        default -> throw new MatchException(null, null);
                        case WeaponType.REVOLVER -> RIFLE_CROSSHAIR;
                        case WeaponType.RIFLE, WeaponType.RIFLE_SPYGLASS -> EMPTY;
                        case WeaponType.SHOTGUN -> EMPTY;
                        case WeaponType.AUTOGUN, WeaponType.MACHINEGUN, WeaponType.FLAMETHROWER -> HNSAUTOGUN_CROSSHAIR;
                    };
                }
                return switch (gunItem.weaponType()) {
                    default -> throw new MatchException(null, null);
                    case WeaponType.REVOLVER -> PISTOL_CROSSHAIR;
                    case WeaponType.RIFLE -> RIFLE_CROSSHAIR;
                    case WeaponType.RIFLE_SPYGLASS -> EMPTY;
                    case WeaponType.SHOTGUN -> SHOTGUN_CROSSHAIR;
                    case WeaponType.AUTOGUN, WeaponType.MACHINEGUN, WeaponType.FLAMETHROWER -> AUTOGUN_CROSSHAIR;
                };
            }
            return switch (gunItem.weaponType()) {
                default -> throw new MatchException(null, null);
                case WeaponType.REVOLVER -> PISTOL_CROSSHAIR;
                case WeaponType.RIFLE -> RIFLE_CROSSHAIR;
                case WeaponType.RIFLE_SPYGLASS -> {
                    if (player.isShiftKeyDown()) {
                        yield RIFLE_CROSSHAIR;
                    }
                    yield EMPTY;
                }
                case WeaponType.SHOTGUN -> SHOTGUN_CROSSHAIR;
                case WeaponType.AUTOGUN, WeaponType.MACHINEGUN, WeaponType.FLAMETHROWER -> AUTOGUN_CROSSHAIR;
            };
        }
        return EMPTY;
    }
}

