/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation;

import com.f708.anothergunmod.client.animation.WeaponAnimator;
import com.f708.anothergunmod.utils.EasingFunctions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;

public class FlameThrowerAnimator
implements WeaponAnimator {
    private final boolean isFirstPerson;

    public FlameThrowerAnimator(boolean isFirstPerson) {
        this.isFirstPerson = isFirstPerson;
    }

    @Override
    public void animateShoot(PoseStack poseStack, float progress, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(15.0f * (float)isLeftHand));
            float frequency = 160.0f;
            float amplitude = 0.3f;
            float shakeX = (float)Math.sin((double)progress * Math.PI * (double)frequency) * amplitude;
            float shakeY = (float)Math.sin((double)progress * Math.PI * (double)frequency * 1.3) * amplitude;
            float shakeZ = (float)Math.sin((double)progress * Math.PI * (double)frequency * 0.7) * amplitude * (float)isLeftHand;
            poseStack.translate((double)shakeX * 0.02, (double)shakeY * 0.015, 0.0);
            poseStack.mulPose(Axis.XP.rotationDegrees(shakeX));
            poseStack.mulPose(Axis.ZP.rotationDegrees(shakeZ));
        } else {
            float shake = (float)Math.sin((double)progress * Math.PI * 20.0) * 3.0f;
            poseStack.mulPose(Axis.XP.rotationDegrees(shake));
        }
    }

    @Override
    public void animateReload(PoseStack poseStack, float progress, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            float angleX = 0.0f;
            float angleZ = 0.0f;
            if (progress < 0.25f) {
                t = progress / 0.25f;
                angleZ = EasingFunctions.lerp(0.0f, 35.0f, EasingFunctions.easeOutCubic(t)) * (float)isLeftHand;
            } else if (progress < 0.5f) {
                t = (progress - 0.25f) / 0.25f;
                angleZ = EasingFunctions.lerp(35.0f, 0.0f, EasingFunctions.easeInOutSine(t)) * (float)isLeftHand;
            } else if (progress < 0.75f) {
                t = (progress - 0.5f) / 0.25f;
                angleZ = EasingFunctions.lerp(0.0f, -35.0f, EasingFunctions.easeOutCubic(t)) * (float)isLeftHand;
            } else {
                t = (progress - 0.75f) / 0.25f;
                angleZ = EasingFunctions.lerp(-35.0f, 0.0f, EasingFunctions.easeInOutSine(t)) * (float)isLeftHand;
            }
            if (progress < 0.5f) {
                tX = progress / 0.5f;
                angleX = EasingFunctions.lerp(0.0f, 25.0f, EasingFunctions.easeOutCubic(tX));
            } else {
                tX = (progress - 0.5f) / 0.5f;
                angleX = EasingFunctions.lerp(25.0f, 0.0f, EasingFunctions.easeInOutSine(tX));
            }
            poseStack.mulPose(Axis.ZN.rotationDegrees(angleZ));
            poseStack.mulPose(Axis.XP.rotationDegrees(angleX));
        } else {
            poseStack.pushPose();
            poseStack.popPose();
            float fastProgress = Math.min(progress * 3.0f, 1.0f);
            float recoil = (float)(Math.sin(Math.PI * (double)fastProgress) * 10.0);
            poseStack.mulPose(Axis.XP.rotationDegrees(recoil));
        }
    }

    @Override
    public void applyDefaultPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.scale(1.5f, 2.0f, 2.0f);
            poseStack.translate(0.0f, -0.1f, -0.1f);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(5.0f * (float)isLeftHand));
        } else {
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(135.0f));
            poseStack.translate(0.0f, -0.25f, -0.3f);
        }
    }

    @Override
    public void applyRunningPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.scale(1.3f, 2.0f, 2.0f);
            poseStack.translate(0.25 * (double)isLeftHand, (double)-0.1f, -0.25);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
        } else {
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(135.0f));
            poseStack.translate(0.0f, -0.25f, -0.3f);
        }
    }

    @Override
    public void applyBlockPose(PoseStack poseStack, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            poseStack.scale(2.0f, 2.0f, 1.0f);
            poseStack.translate(-0.35 * (double)isLeftHand, 0.0, 0.0);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(65.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(35.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(35.0f));
        } else {
            poseStack.scale(2.0f, 2.0f, 1.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XP.rotationDegrees(25.0f));
            poseStack.translate(0.0, (double)-0.35f, (double)-0.3f);
        }
    }
}

