/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation;

import com.f708.anothergunmod.client.animation.WeaponAnimator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.util.Mth;

public class RevolverAnimator
implements WeaponAnimator {
    private final boolean isFirstPerson;

    public RevolverAnimator(boolean isFirstPerson) {
        this.isFirstPerson = isFirstPerson;
    }

    @Override
    public void animateShoot(PoseStack poseStack, float progress, boolean leftHand) {
        float side;
        float f = side = leftHand ? -1.0f : 1.0f;
        if (this.isFirstPerson) {
            poseStack.mulPose(Axis.ZN.rotationDegrees(60.0f * side));
            poseStack.mulPose(Axis.YP.rotationDegrees(10.0f * side));
            poseStack.translate(-0.3 * (double)side, 0.1, -0.1);
            poseStack.pushPose();
            poseStack.popPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)progress, (float)0.0f, (float)720.0f)));
        } else {
            poseStack.translate(leftHand ? 0.1 : -0.1, 0.0, 0.1);
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)progress, (float)0.0f, (float)720.0f)));
        }
    }

    @Override
    public void animateReload(PoseStack poseStack, float progress, boolean leftHand) {
        float side;
        float f = side = leftHand ? -1.0f : 1.0f;
        if (this.isFirstPerson) {
            poseStack.mulPose(Axis.ZN.rotationDegrees(80.0f * side));
            poseStack.mulPose(Axis.YP.rotationDegrees(10.0f * side));
            poseStack.translate(0.3 * (double)side, 0.1, -0.1);
            float s = Mth.sin((float)((float)(Math.PI * (double)progress)));
            float xSway = leftHand ? s : -s * 0.9f;
            poseStack.translate((double)xSway, 0.1, -0.1);
            poseStack.pushPose();
            poseStack.popPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)progress, (float)0.0f, (float)720.0f)));
        } else {
            poseStack.translate(-0.25 * (double)side, 0.1, 0.0);
            poseStack.mulPose(Axis.ZN.rotationDegrees(40.0f * side));
            poseStack.mulPose(Axis.YP.rotationDegrees(10.0f * side));
            poseStack.pushPose();
            poseStack.popPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)progress, (float)0.0f, (float)720.0f)));
        }
    }

    @Override
    public void applyDefaultPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            poseStack.translate(leftHand ? -0.1 : 0.1, 0.0, -0.1);
            poseStack.mulPose(Axis.XN.rotationDegrees(10.0f));
        } else {
            poseStack.translate(0.0, -0.2, -0.2);
            poseStack.scale(0.9f, 0.9f, 0.9f);
        }
    }

    @Override
    public void applyRunningPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            poseStack.translate(leftHand ? -0.1 : 0.1, 0.1, -0.2);
            poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
        } else {
            poseStack.translate(0.0, -0.2, -0.2);
            poseStack.scale(0.9f, 0.9f, 0.9f);
        }
    }

    @Override
    public void applyBlockPose(PoseStack poseStack, boolean leftHand) {
    }
}

