/*
 * Decompiled with CFR 0.152.
 */
package com.f708.anothergunmod.client.animation;

import com.f708.anothergunmod.client.animation.WeaponAnimator;
import com.f708.anothergunmod.utils.EasingFunctions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;

public class RifleSpyglassAnimator
implements WeaponAnimator {
    private final boolean isFirstPerson;

    public RifleSpyglassAnimator(boolean isFirstPerson) {
        this.isFirstPerson = isFirstPerson;
    }

    @Override
    public void animateShoot(PoseStack poseStack, float progress, boolean leftHand) {
        if (this.isFirstPerson) {
            float t;
            int isLeftHand = leftHand ? -1 : 1;
            float angleX = 0.0f;
            float angleZ = 0.0f;
            float moveZ = 0.0f;
            if (progress < 0.1f) {
                t = progress / 0.1f;
                angleX = EasingFunctions.lerp(0.0f, 45.0f, EasingFunctions.easeOutCubic(t));
            } else if (progress < 0.4f) {
                t = (progress - 0.1f) / 0.3f;
                angleX = EasingFunctions.lerp(45.0f, 0.0f, EasingFunctions.easeInOutSine(t));
            }
            if (progress >= 0.4f && progress < 0.5f) {
                t = (progress - 0.4f) / 0.1f;
                angleZ = EasingFunctions.lerp(0.0f, 20.0f, EasingFunctions.easeOutBack(t)) * (float)(-isLeftHand);
            } else if (progress >= 0.5f && progress < 0.8f) {
                angleZ = 20.0f * (float)(-isLeftHand);
            } else if (progress >= 0.8f) {
                t = (progress - 0.8f) / 0.2f;
                angleZ = EasingFunctions.lerp(20.0f, 0.0f, EasingFunctions.easeInOutSine(t)) * (float)(-isLeftHand);
            }
            if (progress >= 0.5f && progress < 0.8f) {
                t = (progress - 0.5f) / 0.3f;
                moveZ = t < 0.5f ? EasingFunctions.lerp(0.0f, 0.1f, EasingFunctions.easeOutCubic(t * 2.0f)) : EasingFunctions.lerp(0.1f, 0.0f, EasingFunctions.easeInOutSine((t - 0.5f) * 2.0f));
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(angleX));
            poseStack.mulPose(Axis.ZN.rotationDegrees(angleZ));
            poseStack.translate(0.0f, 0.0f, moveZ);
        } else {
            poseStack.pushPose();
            poseStack.popPose();
            float fastProgress = Math.min(progress * 3.0f, 1.0f);
            float recoil = (float)(Math.sin(Math.PI * (double)fastProgress) * 10.0);
            poseStack.mulPose(Axis.XP.rotationDegrees(recoil));
        }
    }

    @Override
    public void animateReload(PoseStack poseStack, float progress, boolean leftHand) {
        if (this.isFirstPerson) {
            float t;
            int isLeftHand = leftHand ? -1 : 1;
            float angleX = 0.0f;
            float angleZ = 0.0f;
            if (progress < 0.25f) {
                t = progress / 0.25f;
                angleZ = EasingFunctions.lerp(0.0f, 35.0f, EasingFunctions.easeOutBack(t)) * (float)isLeftHand;
            } else if (progress < 0.5f) {
                t = (progress - 0.25f) / 0.25f;
                angleZ = EasingFunctions.lerp(35.0f, 0.0f, EasingFunctions.easeInOutSine(t)) * (float)isLeftHand;
            }
            if (progress >= 0.5f && progress < 0.7f) {
                t = (progress - 0.5f) / 0.2f;
                angleX = EasingFunctions.lerp(0.0f, 25.0f, EasingFunctions.easeOutCubic(t));
            } else if (progress >= 0.7f && progress < 0.85f) {
                t = (progress - 0.7f) / 0.15f;
                angleX = EasingFunctions.lerp(25.0f, -10.0f, EasingFunctions.easeOutBack(t));
            } else if (progress >= 0.85f) {
                t = (progress - 0.85f) / 0.15f;
                angleX = EasingFunctions.lerp(-10.0f, 0.0f, EasingFunctions.easeInOutSine(t));
            }
            poseStack.mulPose(Axis.ZN.rotationDegrees(angleZ));
            poseStack.mulPose(Axis.XP.rotationDegrees(angleX));
        } else {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.pushPose();
            poseStack.popPose();
            float fastProgress = Math.min(progress * 1.3f, 1.0f);
            float reload = (float)(Math.sin(Math.PI * (double)fastProgress) * 20.0 * (double)isLeftHand);
            poseStack.translate(Math.sin(Math.PI * (double)fastProgress) * -0.1 * (double)isLeftHand, 0.0, 0.0);
            poseStack.mulPose(Axis.ZN.rotationDegrees(reload));
        }
    }

    @Override
    public void animateHit(PoseStack poseStack, float progress, boolean leftHand) {
        float smoothProgress;
        int side;
        if (!this.isFirstPerson) {
            return;
        }
        int n = side = leftHand ? -1 : 1;
        if (progress < 0.3f) {
            t = progress / 0.3f;
            smoothProgress = EasingFunctions.easeOutCubic(t);
        } else {
            t = (progress - 0.3f) / 0.7f;
            smoothProgress = 1.0f - EasingFunctions.easeInQuad(t);
        }
        float rotationY = 120.0f * smoothProgress * (float)side;
        float rotationZ = 30.0f * smoothProgress;
        float offsetX = -0.2f * smoothProgress * (float)side;
        float offsetZ = -0.5f * smoothProgress;
        poseStack.translate(offsetX, 0.0f, offsetZ);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationY));
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotationZ));
    }

    @Override
    public void applySupportedPose(PoseStack poseStack, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            poseStack.scale(1.2f, 2.0f, 2.0f);
            poseStack.translate(0.0, -0.1, -0.1);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(5.0f * (float)isLeftHand));
        } else {
            poseStack.scale(1.2f, 2.0f, 2.0f);
            poseStack.translate(-0.05 * (double)isLeftHand, -0.25, (double)-0.1f);
            poseStack.mulPose(Axis.XP.rotationDegrees(10.0f));
        }
    }

    @Override
    public void applyDefaultPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.scale(1.2f, 2.0f, 2.0f);
            poseStack.translate(0.0, -0.1, -0.1);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(5.0f * (float)isLeftHand));
        } else {
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(135.0f));
            poseStack.translate(0.0, -0.25, -0.3);
        }
    }

    @Override
    public void applyRunningPose(PoseStack poseStack, boolean leftHand) {
        if (this.isFirstPerson) {
            int isLeftHand = leftHand ? -1 : 1;
            poseStack.scale(1.3f, 2.0f, 2.0f);
            poseStack.translate(0.0, -0.0, -0.2);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
        } else {
            poseStack.scale(1.0f, 2.0f, 2.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(135.0f));
            poseStack.translate(0.0, -0.25, -0.3);
        }
    }

    @Override
    public void applyBlockPose(PoseStack poseStack, boolean leftHand) {
        int isLeftHand;
        int n = isLeftHand = leftHand ? -1 : 1;
        if (this.isFirstPerson) {
            poseStack.scale(2.0f, 2.0f, 1.0f);
            poseStack.translate(-0.42 * (double)isLeftHand, 0.0, 0.0);
            poseStack.mulPose(Axis.XN.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(65.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.ZP.rotationDegrees(35.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(35.0f));
        } else {
            poseStack.scale(2.0f, 2.0f, 1.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(5.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f * (float)isLeftHand));
            poseStack.mulPose(Axis.XP.rotationDegrees(25.0f));
            poseStack.translate(0.0, (double)-0.35f, (double)-0.3f);
        }
    }
}

